/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.db.dao.UserKeyDao;
import me.proton.core.user.data.entity.UserKeyEntity;

public final class UserKeyDao_Impl
extends UserKeyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserKeyEntity> __insertionAdapterOfUserKeyEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final UserConverters __userConverters = new UserConverters();
    private final EntityDeletionOrUpdateAdapter<UserKeyEntity> __deletionAdapterOfUserKeyEntity;
    private final EntityDeletionOrUpdateAdapter<UserKeyEntity> __updateAdapterOfUserKeyEntity;

    public UserKeyDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserKeyEntity = new EntityInsertionAdapter<UserKeyEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `UserKeyEntity` (`userId`,`keyId`,`version`,`privateKey`,`isPrimary`,`isUnlockable`,`fingerprint`,`activation`,`active`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserKeyEntity value) {
                Integer _tmp_4;
                String _tmp = UserKeyDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = UserKeyDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                stmt.bindLong(3, (long)value.getVersion());
                if (value.getPrivateKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPrivateKey());
                }
                int _tmp_2 = value.isPrimary() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                int _tmp_3 = value.isUnlockable() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_3);
                if (value.getFingerprint() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getFingerprint());
                }
                if (value.getActivation() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getActivation());
                }
                Integer n = value.getActive() == null ? null : (_tmp_4 = Integer.valueOf(value.getActive() != false ? 1 : 0));
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp_4.intValue());
                }
            }
        };
        this.__deletionAdapterOfUserKeyEntity = new EntityDeletionOrUpdateAdapter<UserKeyEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `UserKeyEntity` WHERE `keyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserKeyEntity value) {
                String _tmp = UserKeyDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfUserKeyEntity = new EntityDeletionOrUpdateAdapter<UserKeyEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `UserKeyEntity` SET `userId` = ?,`keyId` = ?,`version` = ?,`privateKey` = ?,`isPrimary` = ?,`isUnlockable` = ?,`fingerprint` = ?,`activation` = ?,`active` = ? WHERE `keyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserKeyEntity value) {
                Integer _tmp_4;
                String _tmp = UserKeyDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = UserKeyDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                stmt.bindLong(3, (long)value.getVersion());
                if (value.getPrivateKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPrivateKey());
                }
                int _tmp_2 = value.isPrimary() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                int _tmp_3 = value.isUnlockable() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_3);
                if (value.getFingerprint() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getFingerprint());
                }
                if (value.getActivation() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getActivation());
                }
                Integer n = value.getActive() == null ? null : (_tmp_4 = Integer.valueOf(value.getActive() != false ? 1 : 0));
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp_4.intValue());
                }
                String _tmp_5 = UserKeyDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_5 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_5);
                }
            }
        };
    }

    public Object insertOrIgnore(final UserKeyEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserKeyDao_Impl.this.__db.beginTransaction();
                try {
                    UserKeyDao_Impl.this.__insertionAdapterOfUserKeyEntity.insert((Object[])entities);
                    UserKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final UserKeyEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserKeyDao_Impl.this.__db.beginTransaction();
                try {
                    UserKeyDao_Impl.this.__deletionAdapterOfUserKeyEntity.handleMultiple((Object[])entities);
                    UserKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final UserKeyEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                UserKeyDao_Impl.this.__db.beginTransaction();
                try {
                    UserKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += UserKeyDao_Impl.this.__updateAdapterOfUserKeyEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    UserKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final UserKeyEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return UserKeyDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Flow<List<UserKeyEntity>> observeAllByUserId(UserId userId) {
        String _sql = "SELECT * FROM UserKeyEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM UserKeyEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"UserKeyEntity"}, (Callable)new Callable<List<UserKeyEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<UserKeyEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserKeyDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"keyId");
                    int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"version");
                    int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privateKey");
                    int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPrimary");
                    int _cursorIndexOfIsUnlockable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isUnlockable");
                    int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprint");
                    int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activation");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    ArrayList<UserKeyEntity> _result = new ArrayList<UserKeyEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = UserKeyDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfKeyId) ? null : _cursor.getString(_cursorIndexOfKeyId);
                        KeyId _tmpKeyId = UserKeyDao_Impl.this.__userConverters.fromStringToKeyId(_tmp_2);
                        int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                        String _tmpPrivateKey = _cursor.isNull(_cursorIndexOfPrivateKey) ? null : _cursor.getString(_cursorIndexOfPrivateKey);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsPrimary);
                        boolean _tmpIsPrimary = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsUnlockable);
                        boolean _tmpIsUnlockable = _tmp_4 != 0;
                        String _tmpFingerprint = _cursor.isNull(_cursorIndexOfFingerprint) ? null : _cursor.getString(_cursorIndexOfFingerprint);
                        String _tmpActivation = _cursor.isNull(_cursorIndexOfActivation) ? null : _cursor.getString(_cursorIndexOfActivation);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfActive) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfActive));
                        Boolean _tmpActive = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        UserKeyEntity _item = new UserKeyEntity(_tmpUserId, _tmpKeyId, _tmpVersion, _tmpPrivateKey, _tmpIsPrimary, _tmpIsUnlockable, _tmpFingerprint, _tmpActivation, _tmpActive);
                        _result.add(_item);
                    }
                    ArrayList<UserKeyEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getAllByUserId(UserId userId, Continuation<? super List<UserKeyEntity>> arg1) {
        String _sql = "SELECT * FROM UserKeyEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM UserKeyEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<UserKeyEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<UserKeyEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserKeyDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"keyId");
                    int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"version");
                    int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privateKey");
                    int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPrimary");
                    int _cursorIndexOfIsUnlockable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isUnlockable");
                    int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprint");
                    int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activation");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    ArrayList<UserKeyEntity> _result = new ArrayList<UserKeyEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = UserKeyDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfKeyId) ? null : _cursor.getString(_cursorIndexOfKeyId);
                        KeyId _tmpKeyId = UserKeyDao_Impl.this.__userConverters.fromStringToKeyId(_tmp_2);
                        int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                        String _tmpPrivateKey = _cursor.isNull(_cursorIndexOfPrivateKey) ? null : _cursor.getString(_cursorIndexOfPrivateKey);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsPrimary);
                        boolean _tmpIsPrimary = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsUnlockable);
                        boolean _tmpIsUnlockable = _tmp_4 != 0;
                        String _tmpFingerprint = _cursor.isNull(_cursorIndexOfFingerprint) ? null : _cursor.getString(_cursorIndexOfFingerprint);
                        String _tmpActivation = _cursor.isNull(_cursorIndexOfActivation) ? null : _cursor.getString(_cursorIndexOfActivation);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfActive) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfActive));
                        Boolean _tmpActive = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        UserKeyEntity _item = new UserKeyEntity(_tmpUserId, _tmpKeyId, _tmpVersion, _tmpPrivateKey, _tmpIsPrimary, _tmpIsUnlockable, _tmpFingerprint, _tmpActivation, _tmpActive);
                        _result.add(_item);
                    }
                    ArrayList<UserKeyEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

