/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.crypto.android.keystore.CryptoConverters;
import me.proton.core.crypto.common.keystore.EncryptedByteArray;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.user.data.db.dao.UserDao;
import me.proton.core.user.data.entity.UserEntity;

public final class UserDao_Impl
extends UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final CryptoConverters __cryptoConverters = new CryptoConverters();
    private final EntityDeletionOrUpdateAdapter<UserEntity> __deletionAdapterOfUserEntity;
    private final EntityDeletionOrUpdateAdapter<UserEntity> __updateAdapterOfUserEntity;
    private final SharedSQLiteStatement __preparedStmtOfSetPassphrase;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `UserEntity` (`userId`,`email`,`name`,`displayName`,`currency`,`credit`,`usedSpace`,`maxSpace`,`maxUpload`,`role`,`private`,`subscribed`,`services`,`delinquent`,`passphrase`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                String _tmp = UserDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEmail());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getCurrency() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCurrency());
                }
                stmt.bindLong(6, (long)value.getCredit());
                stmt.bindLong(7, value.getUsedSpace());
                stmt.bindLong(8, value.getMaxSpace());
                stmt.bindLong(9, value.getMaxUpload());
                if (value.getRole() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getRole().intValue());
                }
                int _tmp_1 = value.getPrivate() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_1);
                stmt.bindLong(12, (long)value.getSubscribed());
                stmt.bindLong(13, (long)value.getServices());
                if (value.getDelinquent() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getDelinquent().intValue());
                }
                byte[] _tmp_2 = UserDao_Impl.this.__cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
                if (_tmp_2 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindBlob(15, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `UserEntity` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                String _tmp = UserDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `UserEntity` SET `userId` = ?,`email` = ?,`name` = ?,`displayName` = ?,`currency` = ?,`credit` = ?,`usedSpace` = ?,`maxSpace` = ?,`maxUpload` = ?,`role` = ?,`private` = ?,`subscribed` = ?,`services` = ?,`delinquent` = ?,`passphrase` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                String _tmp = UserDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEmail());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getCurrency() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCurrency());
                }
                stmt.bindLong(6, (long)value.getCredit());
                stmt.bindLong(7, value.getUsedSpace());
                stmt.bindLong(8, value.getMaxSpace());
                stmt.bindLong(9, value.getMaxUpload());
                if (value.getRole() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getRole().intValue());
                }
                int _tmp_1 = value.getPrivate() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_1);
                stmt.bindLong(12, (long)value.getSubscribed());
                stmt.bindLong(13, (long)value.getServices());
                if (value.getDelinquent() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getDelinquent().intValue());
                }
                byte[] _tmp_2 = UserDao_Impl.this.__cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
                if (_tmp_2 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindBlob(15, _tmp_2);
                }
                String _tmp_3 = UserDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_3 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_3);
                }
            }
        };
        this.__preparedStmtOfSetPassphrase = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE UserEntity SET passphrase = ? WHERE userId = ?";
                return "UPDATE UserEntity SET passphrase = ? WHERE userId = ?";
            }
        };
    }

    public Object insertOrIgnore(final UserEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserDao_Impl.this.__db.beginTransaction();
                try {
                    UserDao_Impl.this.__insertionAdapterOfUserEntity.insert((Object[])entities);
                    UserDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final UserEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserDao_Impl.this.__db.beginTransaction();
                try {
                    UserDao_Impl.this.__deletionAdapterOfUserEntity.handleMultiple((Object[])entities);
                    UserDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final UserEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                UserDao_Impl.this.__db.beginTransaction();
                try {
                    UserDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += UserDao_Impl.this.__updateAdapterOfUserEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    UserDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final UserEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return UserDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object setPassphrase(final UserId userId, final EncryptedByteArray passphrase, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = UserDao_Impl.this.__preparedStmtOfSetPassphrase.acquire();
                int _argIndex = 1;
                byte[] _tmp = UserDao_Impl.this.__cryptoConverters.fromEncryptedByteArrayToByteArray(passphrase);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindBlob(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = UserDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                UserDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    UserDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserDao_Impl.this.__db.endTransaction();
                    UserDao_Impl.this.__preparedStmtOfSetPassphrase.release(_stmt);
                }
            }
        }, arg2);
    }

    public Flow<UserEntity> observeByUserId(UserId userId) {
        String _sql = "SELECT * FROM UserEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM UserEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"UserEntity"}, (Callable)new Callable<UserEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    UserEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
                    int _cursorIndexOfCredit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"credit");
                    int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usedSpace");
                    int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxSpace");
                    int _cursorIndexOfMaxUpload = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxUpload");
                    int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
                    int _cursorIndexOfPrivate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"private");
                    int _cursorIndexOfSubscribed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subscribed");
                    int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
                    int _cursorIndexOfDelinquent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delinquent");
                    int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"passphrase");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = UserDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                        int _tmpCredit = _cursor.getInt(_cursorIndexOfCredit);
                        long _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
                        long _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
                        long _tmpMaxUpload = _cursor.getLong(_cursorIndexOfMaxUpload);
                        Integer _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfRole));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfPrivate);
                        boolean _tmpPrivate = _tmp_2 != 0;
                        int _tmpSubscribed = _cursor.getInt(_cursorIndexOfSubscribed);
                        int _tmpServices = _cursor.getInt(_cursorIndexOfServices);
                        Integer _tmpDelinquent = _cursor.isNull(_cursorIndexOfDelinquent) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDelinquent));
                        byte[] _tmp_3 = _cursor.isNull(_cursorIndexOfPassphrase) ? null : _cursor.getBlob(_cursorIndexOfPassphrase);
                        EncryptedByteArray _tmpPassphrase = UserDao_Impl.this.__cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_3);
                        _result = new UserEntity(_tmpUserId, _tmpEmail, _tmpName, _tmpDisplayName, _tmpCurrency, _tmpCredit, _tmpUsedSpace, _tmpMaxSpace, _tmpMaxUpload, _tmpRole, _tmpPrivate, _tmpSubscribed, _tmpServices, _tmpDelinquent, _tmpPassphrase);
                    } else {
                        _result = null;
                    }
                    UserEntity userEntity = _result;
                    return userEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getByUserId(UserId userId, Continuation<? super UserEntity> arg1) {
        String _sql = "SELECT * FROM UserEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM UserEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<UserEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    UserEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
                    int _cursorIndexOfCredit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"credit");
                    int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usedSpace");
                    int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxSpace");
                    int _cursorIndexOfMaxUpload = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxUpload");
                    int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
                    int _cursorIndexOfPrivate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"private");
                    int _cursorIndexOfSubscribed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subscribed");
                    int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
                    int _cursorIndexOfDelinquent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delinquent");
                    int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"passphrase");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = UserDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                        int _tmpCredit = _cursor.getInt(_cursorIndexOfCredit);
                        long _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
                        long _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
                        long _tmpMaxUpload = _cursor.getLong(_cursorIndexOfMaxUpload);
                        Integer _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfRole));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfPrivate);
                        boolean _tmpPrivate = _tmp_2 != 0;
                        int _tmpSubscribed = _cursor.getInt(_cursorIndexOfSubscribed);
                        int _tmpServices = _cursor.getInt(_cursorIndexOfServices);
                        Integer _tmpDelinquent = _cursor.isNull(_cursorIndexOfDelinquent) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDelinquent));
                        byte[] _tmp_3 = _cursor.isNull(_cursorIndexOfPassphrase) ? null : _cursor.getBlob(_cursorIndexOfPassphrase);
                        EncryptedByteArray _tmpPassphrase = UserDao_Impl.this.__cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_3);
                        _result = new UserEntity(_tmpUserId, _tmpEmail, _tmpName, _tmpDisplayName, _tmpCurrency, _tmpCredit, _tmpUsedSpace, _tmpMaxSpace, _tmpMaxUpload, _tmpRole, _tmpPrivate, _tmpSubscribed, _tmpServices, _tmpDelinquent, _tmpPassphrase);
                    } else {
                        _result = null;
                    }
                    UserEntity userEntity = _result;
                    return userEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public Object getPassphrase(UserId userId, Continuation<? super EncryptedByteArray> arg1) {
        String _sql = "SELECT passphrase FROM UserEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT passphrase FROM UserEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<EncryptedByteArray>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EncryptedByteArray call() throws Exception {
                UserDao_Impl.this.__db.beginTransaction();
                try {
                    EncryptedByteArray encryptedByteArray;
                    Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                    try {
                        EncryptedByteArray _result;
                        if (_cursor.moveToFirst()) {
                            byte[] _tmp_1 = _cursor.isNull(0) ? null : _cursor.getBlob(0);
                            _result = UserDao_Impl.this.__cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_1);
                        } else {
                            _result = null;
                        }
                        UserDao_Impl.this.__db.setTransactionSuccessful();
                        encryptedByteArray = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return encryptedByteArray;
                }
                finally {
                    UserDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

