/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.account.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.account.data.db.AccountConverters;
import me.proton.core.account.data.db.AccountDao;
import me.proton.core.account.data.entity.AccountEntity;
import me.proton.core.account.domain.entity.AccountState;
import me.proton.core.account.domain.entity.SessionState;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.network.domain.session.SessionId;

public final class AccountDao_Impl
extends AccountDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AccountEntity> __insertionAdapterOfAccountEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final AccountConverters __accountConverters = new AccountConverters();
    private final EntityDeletionOrUpdateAdapter<AccountEntity> __deletionAdapterOfAccountEntity;
    private final EntityDeletionOrUpdateAdapter<AccountEntity> __updateAdapterOfAccountEntity;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfUpdateAccountState;
    private final SharedSQLiteStatement __preparedStmtOfUpdateSessionState;
    private final SharedSQLiteStatement __preparedStmtOfAddSession;
    private final SharedSQLiteStatement __preparedStmtOfRemoveSession;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public AccountDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAccountEntity = new EntityInsertionAdapter<AccountEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `AccountEntity` (`userId`,`username`,`email`,`state`,`sessionId`,`sessionState`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AccountEntity value) {
                String _tmp = AccountDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getUsername() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUsername());
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEmail());
                }
                String _tmp_1 = AccountDao_Impl.this.__accountConverters.fromAccountStateToString(value.getState());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = AccountDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = AccountDao_Impl.this.__accountConverters.fromSessionStateToString(value.getSessionState());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfAccountEntity = new EntityDeletionOrUpdateAdapter<AccountEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `AccountEntity` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AccountEntity value) {
                String _tmp = AccountDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfAccountEntity = new EntityDeletionOrUpdateAdapter<AccountEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `AccountEntity` SET `userId` = ?,`username` = ?,`email` = ?,`state` = ?,`sessionId` = ?,`sessionState` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AccountEntity value) {
                String _tmp = AccountDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getUsername() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUsername());
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEmail());
                }
                String _tmp_1 = AccountDao_Impl.this.__accountConverters.fromAccountStateToString(value.getState());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = AccountDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = AccountDao_Impl.this.__accountConverters.fromSessionStateToString(value.getSessionState());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                String _tmp_4 = AccountDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM AccountEntity WHERE userId = ?";
                return "DELETE FROM AccountEntity WHERE userId = ?";
            }
        };
        this.__preparedStmtOfUpdateAccountState = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE AccountEntity SET state = ? WHERE userId = ?";
                return "UPDATE AccountEntity SET state = ? WHERE userId = ?";
            }
        };
        this.__preparedStmtOfUpdateSessionState = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE AccountEntity SET sessionState = ? WHERE sessionId = ?";
                return "UPDATE AccountEntity SET sessionState = ? WHERE sessionId = ?";
            }
        };
        this.__preparedStmtOfAddSession = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE AccountEntity SET sessionId = ? WHERE userId = ?";
                return "UPDATE AccountEntity SET sessionId = ? WHERE userId = ?";
            }
        };
        this.__preparedStmtOfRemoveSession = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE AccountEntity SET sessionId = null, sessionState = null WHERE sessionId = ?";
                return "UPDATE AccountEntity SET sessionId = null, sessionState = null WHERE sessionId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM AccountEntity";
                return "DELETE FROM AccountEntity";
            }
        };
    }

    public Object insertOrIgnore(final AccountEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    AccountDao_Impl.this.__insertionAdapterOfAccountEntity.insert((Object[])entities);
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final AccountEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    AccountDao_Impl.this.__deletionAdapterOfAccountEntity.handleMultiple((Object[])entities);
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final AccountEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += AccountDao_Impl.this.__updateAdapterOfAccountEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final AccountEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return AccountDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object delete(final UserId userId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                String _tmp = AccountDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                    AccountDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object updateAccountState(final UserId userId, final AccountState state, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountDao_Impl.this.__preparedStmtOfUpdateAccountState.acquire();
                int _argIndex = 1;
                String _tmp = AccountDao_Impl.this.__accountConverters.fromAccountStateToString(state);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = AccountDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                    AccountDao_Impl.this.__preparedStmtOfUpdateAccountState.release(_stmt);
                }
            }
        }, arg2);
    }

    public Object updateSessionState(final SessionId sessionId, final SessionState state, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountDao_Impl.this.__preparedStmtOfUpdateSessionState.acquire();
                int _argIndex = 1;
                String _tmp = AccountDao_Impl.this.__accountConverters.fromSessionStateToString(state);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = AccountDao_Impl.this.__commonConverters.fromSessionIdToString(sessionId);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                    AccountDao_Impl.this.__preparedStmtOfUpdateSessionState.release(_stmt);
                }
            }
        }, arg2);
    }

    public Object addSession(final UserId userId, final SessionId sessionId, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountDao_Impl.this.__preparedStmtOfAddSession.acquire();
                int _argIndex = 1;
                String _tmp = AccountDao_Impl.this.__commonConverters.fromSessionIdToString(sessionId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = AccountDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                    AccountDao_Impl.this.__preparedStmtOfAddSession.release(_stmt);
                }
            }
        }, arg2);
    }

    public Object removeSession(final SessionId sessionId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountDao_Impl.this.__preparedStmtOfRemoveSession.acquire();
                int _argIndex = 1;
                String _tmp = AccountDao_Impl.this.__commonConverters.fromSessionIdToString(sessionId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                    AccountDao_Impl.this.__preparedStmtOfRemoveSession.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAll(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                    AccountDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<List<AccountEntity>> findAll() {
        String _sql = "SELECT * FROM AccountEntity";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AccountEntity", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"AccountEntity"}, (Callable)new Callable<List<AccountEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AccountEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfSessionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionState");
                    ArrayList<AccountEntity> _result = new ArrayList<AccountEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AccountDao_Impl.this.__commonConverters.fromStringToUserId(_tmp);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                        AccountState _tmpState = AccountDao_Impl.this.__accountConverters.fromStringToAccountState(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = AccountDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfSessionState) ? null : _cursor.getString(_cursorIndexOfSessionState);
                        SessionState _tmpSessionState = AccountDao_Impl.this.__accountConverters.fromStringToSessionState(_tmp_3);
                        AccountEntity _item = new AccountEntity(_tmpUserId, _tmpUsername, _tmpEmail, _tmpState, _tmpSessionId, _tmpSessionState);
                        _result.add(_item);
                    }
                    ArrayList<AccountEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Flow<AccountEntity> findByUserId(UserId userId) {
        String _sql = "SELECT * FROM AccountEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AccountEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"AccountEntity"}, (Callable)new Callable<AccountEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccountEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AccountEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfSessionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionState");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AccountDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                        AccountState _tmpState = AccountDao_Impl.this.__accountConverters.fromStringToAccountState(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = AccountDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfSessionState) ? null : _cursor.getString(_cursorIndexOfSessionState);
                        SessionState _tmpSessionState = AccountDao_Impl.this.__accountConverters.fromStringToSessionState(_tmp_4);
                        _result = new AccountEntity(_tmpUserId, _tmpUsername, _tmpEmail, _tmpState, _tmpSessionId, _tmpSessionState);
                    } else {
                        _result = null;
                    }
                    AccountEntity accountEntity = _result;
                    return accountEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Flow<AccountEntity> findBySessionId(SessionId sessionId) {
        String _sql = "SELECT * FROM AccountEntity WHERE sessionId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AccountEntity WHERE sessionId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"AccountEntity"}, (Callable)new Callable<AccountEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccountEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AccountEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfSessionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionState");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AccountDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                        AccountState _tmpState = AccountDao_Impl.this.__accountConverters.fromStringToAccountState(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = AccountDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfSessionState) ? null : _cursor.getString(_cursorIndexOfSessionState);
                        SessionState _tmpSessionState = AccountDao_Impl.this.__accountConverters.fromStringToSessionState(_tmp_4);
                        _result = new AccountEntity(_tmpUserId, _tmpUsername, _tmpEmail, _tmpState, _tmpSessionId, _tmpSessionState);
                    } else {
                        _result = null;
                    }
                    AccountEntity accountEntity = _result;
                    return accountEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getByUserId(UserId userId, Continuation<? super AccountEntity> arg1) {
        String _sql = "SELECT * FROM AccountEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AccountEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<AccountEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccountEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    AccountEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfSessionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionState");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AccountDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                        AccountState _tmpState = AccountDao_Impl.this.__accountConverters.fromStringToAccountState(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = AccountDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfSessionState) ? null : _cursor.getString(_cursorIndexOfSessionState);
                        SessionState _tmpSessionState = AccountDao_Impl.this.__accountConverters.fromStringToSessionState(_tmp_4);
                        _result = new AccountEntity(_tmpUserId, _tmpUsername, _tmpEmail, _tmpState, _tmpSessionId, _tmpSessionState);
                    } else {
                        _result = null;
                    }
                    AccountEntity accountEntity = _result;
                    return accountEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public Object getBySessionId(SessionId sessionId, Continuation<? super AccountEntity> arg1) {
        String _sql = "SELECT * FROM AccountEntity WHERE sessionId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AccountEntity WHERE sessionId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<AccountEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccountEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    AccountEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfSessionState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionState");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AccountDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                        AccountState _tmpState = AccountDao_Impl.this.__accountConverters.fromStringToAccountState(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = AccountDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfSessionState) ? null : _cursor.getString(_cursorIndexOfSessionState);
                        SessionState _tmpSessionState = AccountDao_Impl.this.__accountConverters.fromStringToSessionState(_tmp_4);
                        _result = new AccountEntity(_tmpUserId, _tmpUsername, _tmpEmail, _tmpState, _tmpSessionId, _tmpSessionState);
                    } else {
                        _result = null;
                    }
                    AccountEntity accountEntity = _result;
                    return accountEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

