/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.eventmanager.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.eventmanager.data.db.EventManagerConverters;
import me.proton.core.eventmanager.data.db.dao.EventMetadataDao;
import me.proton.core.eventmanager.data.entity.EventMetadataEntity;
import me.proton.core.eventmanager.domain.EventManagerConfig;
import me.proton.core.eventmanager.domain.entity.RefreshType;
import me.proton.core.eventmanager.domain.entity.State;

public final class EventMetadataDao_Impl
extends EventMetadataDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EventMetadataEntity> __insertionAdapterOfEventMetadataEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EventManagerConverters __eventManagerConverters = new EventManagerConverters();
    private final EntityDeletionOrUpdateAdapter<EventMetadataEntity> __deletionAdapterOfEventMetadataEntity;
    private final EntityDeletionOrUpdateAdapter<EventMetadataEntity> __updateAdapterOfEventMetadataEntity;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfUpdateState;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EventMetadataDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEventMetadataEntity = new EntityInsertionAdapter<EventMetadataEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `EventMetadataEntity` (`userId`,`config`,`eventId`,`nextEventId`,`refresh`,`more`,`response`,`retry`,`state`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EventMetadataEntity value) {
                Integer _tmp_2;
                String _tmp = EventMetadataDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = EventMetadataDao_Impl.this.__eventManagerConverters.fromEventManagerConfigToString(value.getConfig());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getEventId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEventId());
                }
                if (value.getNextEventId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getNextEventId());
                }
                if (value.getRefresh() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, EventMetadataDao_Impl.this.__RefreshType_enumToString(value.getRefresh()));
                }
                Integer n = value.getMore() == null ? null : (_tmp_2 = Integer.valueOf(value.getMore() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)_tmp_2.intValue());
                }
                if (value.getResponse() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getResponse());
                }
                stmt.bindLong(8, (long)value.getRetry());
                if (value.getState() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, EventMetadataDao_Impl.this.__State_enumToString(value.getState()));
                }
                stmt.bindLong(10, value.getCreatedAt());
                if (value.getUpdatedAt() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, value.getUpdatedAt().longValue());
                }
            }
        };
        this.__deletionAdapterOfEventMetadataEntity = new EntityDeletionOrUpdateAdapter<EventMetadataEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `EventMetadataEntity` WHERE `userId` = ? AND `config` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EventMetadataEntity value) {
                String _tmp = EventMetadataDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = EventMetadataDao_Impl.this.__eventManagerConverters.fromEventManagerConfigToString(value.getConfig());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
            }
        };
        this.__updateAdapterOfEventMetadataEntity = new EntityDeletionOrUpdateAdapter<EventMetadataEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `EventMetadataEntity` SET `userId` = ?,`config` = ?,`eventId` = ?,`nextEventId` = ?,`refresh` = ?,`more` = ?,`response` = ?,`retry` = ?,`state` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `userId` = ? AND `config` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EventMetadataEntity value) {
                Integer _tmp_2;
                String _tmp = EventMetadataDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = EventMetadataDao_Impl.this.__eventManagerConverters.fromEventManagerConfigToString(value.getConfig());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getEventId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEventId());
                }
                if (value.getNextEventId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getNextEventId());
                }
                if (value.getRefresh() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, EventMetadataDao_Impl.this.__RefreshType_enumToString(value.getRefresh()));
                }
                Integer n = value.getMore() == null ? null : (_tmp_2 = Integer.valueOf(value.getMore() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)_tmp_2.intValue());
                }
                if (value.getResponse() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getResponse());
                }
                stmt.bindLong(8, (long)value.getRetry());
                if (value.getState() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, EventMetadataDao_Impl.this.__State_enumToString(value.getState()));
                }
                stmt.bindLong(10, value.getCreatedAt());
                if (value.getUpdatedAt() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, value.getUpdatedAt().longValue());
                }
                String _tmp_3 = EventMetadataDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_3 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_3);
                }
                String _tmp_4 = EventMetadataDao_Impl.this.__eventManagerConverters.fromEventManagerConfigToString(value.getConfig());
                if (_tmp_4 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_4);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?";
                return "DELETE FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?";
            }
        };
        this.__preparedStmtOfUpdateState = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE EventMetadataEntity SET state = ?, updatedAt = ? WHERE config = ? AND userId = ? AND eventId = ?";
                return "UPDATE EventMetadataEntity SET state = ?, updatedAt = ? WHERE config = ? AND userId = ? AND eventId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM EventMetadataEntity WHERE config = ? AND userId = ?";
                return "DELETE FROM EventMetadataEntity WHERE config = ? AND userId = ?";
            }
        };
    }

    public Object insertOrIgnore(final EventMetadataEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                EventMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    EventMetadataDao_Impl.this.__insertionAdapterOfEventMetadataEntity.insert((Object[])entities);
                    EventMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EventMetadataDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final EventMetadataEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                EventMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    EventMetadataDao_Impl.this.__deletionAdapterOfEventMetadataEntity.handleMultiple((Object[])entities);
                    EventMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EventMetadataDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final EventMetadataEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                EventMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    EventMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += EventMetadataDao_Impl.this.__updateAdapterOfEventMetadataEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    EventMetadataDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final EventMetadataEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return EventMetadataDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object delete(final UserId userId, final EventManagerConfig config, final String eventId, Continuation<? super Unit> arg3) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = EventMetadataDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                String _tmp = EventMetadataDao_Impl.this.__eventManagerConverters.fromEventManagerConfigToString(config);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = EventMetadataDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                _argIndex = 3;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, eventId);
                }
                EventMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EventMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EventMetadataDao_Impl.this.__db.endTransaction();
                    EventMetadataDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, arg3);
    }

    public Object updateState(final UserId userId, final EventManagerConfig config, final String eventId, final State state, final long updatedAt, Continuation<? super Unit> arg5) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = EventMetadataDao_Impl.this.__preparedStmtOfUpdateState.acquire();
                int _argIndex = 1;
                if (state == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, EventMetadataDao_Impl.this.__State_enumToString(state));
                }
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updatedAt);
                _argIndex = 3;
                String _tmp = EventMetadataDao_Impl.this.__eventManagerConverters.fromEventManagerConfigToString(config);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 4;
                String _tmp_1 = EventMetadataDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                _argIndex = 5;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, eventId);
                }
                EventMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EventMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EventMetadataDao_Impl.this.__db.endTransaction();
                    EventMetadataDao_Impl.this.__preparedStmtOfUpdateState.release(_stmt);
                }
            }
        }, arg5);
    }

    public Object deleteAll(final UserId userId, final EventManagerConfig config, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = EventMetadataDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                int _argIndex = 1;
                String _tmp = EventMetadataDao_Impl.this.__eventManagerConverters.fromEventManagerConfigToString(config);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = EventMetadataDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                EventMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EventMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EventMetadataDao_Impl.this.__db.endTransaction();
                    EventMetadataDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg2);
    }

    public Flow<List<EventMetadataEntity>> observe(UserId userId, EventManagerConfig config) {
        String _sql = "SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? ORDER BY createdAt";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? ORDER BY createdAt", (int)2);
        int _argIndex = 1;
        String _tmp = this.__eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        String _tmp_1 = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_1);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"EventMetadataEntity"}, (Callable)new Callable<List<EventMetadataEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EventMetadataEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EventMetadataDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"config");
                    int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
                    int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nextEventId");
                    int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refresh");
                    int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"more");
                    int _cursorIndexOfResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"response");
                    int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retry");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    ArrayList<EventMetadataEntity> _result = new ArrayList<EventMetadataEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = EventMetadataDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfConfig) ? null : _cursor.getString(_cursorIndexOfConfig);
                        EventManagerConfig _tmpConfig = EventMetadataDao_Impl.this.__eventManagerConverters.fromStringToEventManagerConfig(_tmp_3);
                        String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                        String _tmpNextEventId = _cursor.isNull(_cursorIndexOfNextEventId) ? null : _cursor.getString(_cursorIndexOfNextEventId);
                        RefreshType _tmpRefresh = EventMetadataDao_Impl.this.__RefreshType_stringToEnum(_cursor.getString(_cursorIndexOfRefresh));
                        Integer _tmp_4 = _cursor.isNull(_cursorIndexOfMore) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMore));
                        Boolean _tmpMore = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        String _tmpResponse = _cursor.isNull(_cursorIndexOfResponse) ? null : _cursor.getString(_cursorIndexOfResponse);
                        int _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
                        State _tmpState = EventMetadataDao_Impl.this.__State_stringToEnum(_cursor.getString(_cursorIndexOfState));
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        Long _tmpUpdatedAt = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        EventMetadataEntity _item = new EventMetadataEntity(_tmpUserId, _tmpConfig, _tmpEventId, _tmpNextEventId, _tmpRefresh, _tmpMore, _tmpResponse, _tmpRetry, _tmpState, _tmpCreatedAt, _tmpUpdatedAt);
                        _result.add(_item);
                    }
                    ArrayList<EventMetadataEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Flow<EventMetadataEntity> observe(UserId userId, EventManagerConfig config, String eventId) {
        String _sql = "SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?", (int)3);
        int _argIndex = 1;
        String _tmp = this.__eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        String _tmp_1 = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 3;
        if (eventId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, eventId);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"EventMetadataEntity"}, (Callable)new Callable<EventMetadataEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EventMetadataEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EventMetadataDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EventMetadataEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"config");
                    int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
                    int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nextEventId");
                    int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refresh");
                    int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"more");
                    int _cursorIndexOfResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"response");
                    int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retry");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = EventMetadataDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfConfig) ? null : _cursor.getString(_cursorIndexOfConfig);
                        EventManagerConfig _tmpConfig = EventMetadataDao_Impl.this.__eventManagerConverters.fromStringToEventManagerConfig(_tmp_3);
                        String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                        String _tmpNextEventId = _cursor.isNull(_cursorIndexOfNextEventId) ? null : _cursor.getString(_cursorIndexOfNextEventId);
                        RefreshType _tmpRefresh = EventMetadataDao_Impl.this.__RefreshType_stringToEnum(_cursor.getString(_cursorIndexOfRefresh));
                        Integer _tmp_4 = _cursor.isNull(_cursorIndexOfMore) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMore));
                        Boolean _tmpMore = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        String _tmpResponse = _cursor.isNull(_cursorIndexOfResponse) ? null : _cursor.getString(_cursorIndexOfResponse);
                        int _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
                        State _tmpState = EventMetadataDao_Impl.this.__State_stringToEnum(_cursor.getString(_cursorIndexOfState));
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        Long _tmpUpdatedAt = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        _result = new EventMetadataEntity(_tmpUserId, _tmpConfig, _tmpEventId, _tmpNextEventId, _tmpRefresh, _tmpMore, _tmpResponse, _tmpRetry, _tmpState, _tmpCreatedAt, _tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EventMetadataEntity eventMetadataEntity = _result;
                    return eventMetadataEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object get(UserId userId, EventManagerConfig config, Continuation<? super List<EventMetadataEntity>> arg2) {
        String _sql = "SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? ORDER BY createdAt";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? ORDER BY createdAt", (int)2);
        int _argIndex = 1;
        String _tmp = this.__eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        String _tmp_1 = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_1);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<EventMetadataEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EventMetadataEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)EventMetadataDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"config");
                    int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
                    int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nextEventId");
                    int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refresh");
                    int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"more");
                    int _cursorIndexOfResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"response");
                    int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retry");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    ArrayList<EventMetadataEntity> _result = new ArrayList<EventMetadataEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = EventMetadataDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfConfig) ? null : _cursor.getString(_cursorIndexOfConfig);
                        EventManagerConfig _tmpConfig = EventMetadataDao_Impl.this.__eventManagerConverters.fromStringToEventManagerConfig(_tmp_3);
                        String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                        String _tmpNextEventId = _cursor.isNull(_cursorIndexOfNextEventId) ? null : _cursor.getString(_cursorIndexOfNextEventId);
                        RefreshType _tmpRefresh = EventMetadataDao_Impl.this.__RefreshType_stringToEnum(_cursor.getString(_cursorIndexOfRefresh));
                        Integer _tmp_4 = _cursor.isNull(_cursorIndexOfMore) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMore));
                        Boolean _tmpMore = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        String _tmpResponse = _cursor.isNull(_cursorIndexOfResponse) ? null : _cursor.getString(_cursorIndexOfResponse);
                        int _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
                        State _tmpState = EventMetadataDao_Impl.this.__State_stringToEnum(_cursor.getString(_cursorIndexOfState));
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        Long _tmpUpdatedAt = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        EventMetadataEntity _item = new EventMetadataEntity(_tmpUserId, _tmpConfig, _tmpEventId, _tmpNextEventId, _tmpRefresh, _tmpMore, _tmpResponse, _tmpRetry, _tmpState, _tmpCreatedAt, _tmpUpdatedAt);
                        _result.add(_item);
                    }
                    ArrayList<EventMetadataEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg2);
    }

    public Object get(UserId userId, EventManagerConfig config, String eventId, Continuation<? super EventMetadataEntity> arg3) {
        String _sql = "SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventMetadataEntity WHERE config = ? AND userId = ? AND eventId = ?", (int)3);
        int _argIndex = 1;
        String _tmp = this.__eventManagerConverters.fromEventManagerConfigToString(config);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        String _tmp_1 = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 3;
        if (eventId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, eventId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<EventMetadataEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EventMetadataEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)EventMetadataDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    EventMetadataEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfConfig = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"config");
                    int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
                    int _cursorIndexOfNextEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nextEventId");
                    int _cursorIndexOfRefresh = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refresh");
                    int _cursorIndexOfMore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"more");
                    int _cursorIndexOfResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"response");
                    int _cursorIndexOfRetry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retry");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = EventMetadataDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfConfig) ? null : _cursor.getString(_cursorIndexOfConfig);
                        EventManagerConfig _tmpConfig = EventMetadataDao_Impl.this.__eventManagerConverters.fromStringToEventManagerConfig(_tmp_3);
                        String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                        String _tmpNextEventId = _cursor.isNull(_cursorIndexOfNextEventId) ? null : _cursor.getString(_cursorIndexOfNextEventId);
                        RefreshType _tmpRefresh = EventMetadataDao_Impl.this.__RefreshType_stringToEnum(_cursor.getString(_cursorIndexOfRefresh));
                        Integer _tmp_4 = _cursor.isNull(_cursorIndexOfMore) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMore));
                        Boolean _tmpMore = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        String _tmpResponse = _cursor.isNull(_cursorIndexOfResponse) ? null : _cursor.getString(_cursorIndexOfResponse);
                        int _tmpRetry = _cursor.getInt(_cursorIndexOfRetry);
                        State _tmpState = EventMetadataDao_Impl.this.__State_stringToEnum(_cursor.getString(_cursorIndexOfState));
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        Long _tmpUpdatedAt = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfUpdatedAt));
                        _result = new EventMetadataEntity(_tmpUserId, _tmpConfig, _tmpEventId, _tmpNextEventId, _tmpRefresh, _tmpMore, _tmpResponse, _tmpRetry, _tmpState, _tmpCreatedAt, _tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EventMetadataEntity eventMetadataEntity = _result;
                    return eventMetadataEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg3);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __RefreshType_enumToString(RefreshType _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case Nothing: {
                return "Nothing";
            }
            case Mail: {
                return "Mail";
            }
            case Contact: {
                return "Contact";
            }
            case All: {
                return "All";
            }
        }
        throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + _value);
    }

    private String __State_enumToString(State _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case Enqueued: {
                return "Enqueued";
            }
            case Fetching: {
                return "Fetching";
            }
            case Persisted: {
                return "Persisted";
            }
            case NotifyPrepare: {
                return "NotifyPrepare";
            }
            case NotifyEvents: {
                return "NotifyEvents";
            }
            case NotifyResetAll: {
                return "NotifyResetAll";
            }
            case NotifyComplete: {
                return "NotifyComplete";
            }
            case Completed: {
                return "Completed";
            }
        }
        throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + _value);
    }

    private RefreshType __RefreshType_stringToEnum(String _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case "Nothing": {
                return RefreshType.Nothing;
            }
            case "Mail": {
                return RefreshType.Mail;
            }
            case "Contact": {
                return RefreshType.Contact;
            }
            case "All": {
                return RefreshType.All;
            }
        }
        throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }

    private State __State_stringToEnum(String _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case "Enqueued": {
                return State.Enqueued;
            }
            case "Fetching": {
                return State.Fetching;
            }
            case "Persisted": {
                return State.Persisted;
            }
            case "NotifyPrepare": {
                return State.NotifyPrepare;
            }
            case "NotifyEvents": {
                return State.NotifyEvents;
            }
            case "NotifyResetAll": {
                return State.NotifyResetAll;
            }
            case "NotifyComplete": {
                return State.NotifyComplete;
            }
            case "Completed": {
                return State.Completed;
            }
        }
        throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
}

