/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.key.data.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.key.data.db.PublicAddressDao;
import me.proton.core.key.data.entity.PublicAddressEntity;
import me.proton.core.key.data.entity.SignedKeyListEntity;

public final class PublicAddressDao_Impl
extends PublicAddressDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PublicAddressEntity> __insertionAdapterOfPublicAddressEntity;
    private final EntityDeletionOrUpdateAdapter<PublicAddressEntity> __deletionAdapterOfPublicAddressEntity;
    private final EntityDeletionOrUpdateAdapter<PublicAddressEntity> __updateAdapterOfPublicAddressEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByEmail;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public PublicAddressDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPublicAddressEntity = new EntityInsertionAdapter<PublicAddressEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `PublicAddressEntity` (`email`,`recipientType`,`mimeType`,`signedKeyList_data`,`signedKeyList_signature`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PublicAddressEntity value) {
                if (value.getEmail() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEmail());
                }
                stmt.bindLong(2, (long)value.getRecipientType());
                if (value.getMimeType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getMimeType());
                }
                SignedKeyListEntity _tmpSignedKeyListEntity = value.getSignedKeyListEntity();
                if (_tmpSignedKeyListEntity != null) {
                    if (_tmpSignedKeyListEntity.getData() == null) {
                        stmt.bindNull(4);
                    } else {
                        stmt.bindString(4, _tmpSignedKeyListEntity.getData());
                    }
                    if (_tmpSignedKeyListEntity.getSignature() == null) {
                        stmt.bindNull(5);
                    } else {
                        stmt.bindString(5, _tmpSignedKeyListEntity.getSignature());
                    }
                } else {
                    stmt.bindNull(4);
                    stmt.bindNull(5);
                }
            }
        };
        this.__deletionAdapterOfPublicAddressEntity = new EntityDeletionOrUpdateAdapter<PublicAddressEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `PublicAddressEntity` WHERE `email` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PublicAddressEntity value) {
                if (value.getEmail() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEmail());
                }
            }
        };
        this.__updateAdapterOfPublicAddressEntity = new EntityDeletionOrUpdateAdapter<PublicAddressEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `PublicAddressEntity` SET `email` = ?,`recipientType` = ?,`mimeType` = ?,`signedKeyList_data` = ?,`signedKeyList_signature` = ? WHERE `email` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PublicAddressEntity value) {
                if (value.getEmail() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEmail());
                }
                stmt.bindLong(2, (long)value.getRecipientType());
                if (value.getMimeType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getMimeType());
                }
                SignedKeyListEntity _tmpSignedKeyListEntity = value.getSignedKeyListEntity();
                if (_tmpSignedKeyListEntity != null) {
                    if (_tmpSignedKeyListEntity.getData() == null) {
                        stmt.bindNull(4);
                    } else {
                        stmt.bindString(4, _tmpSignedKeyListEntity.getData());
                    }
                    if (_tmpSignedKeyListEntity.getSignature() == null) {
                        stmt.bindNull(5);
                    } else {
                        stmt.bindString(5, _tmpSignedKeyListEntity.getSignature());
                    }
                } else {
                    stmt.bindNull(4);
                    stmt.bindNull(5);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getEmail());
                }
            }
        };
        this.__preparedStmtOfDeleteByEmail = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM PublicAddressEntity WHERE email = ?";
                return "DELETE FROM PublicAddressEntity WHERE email = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM PublicAddressEntity";
                return "DELETE FROM PublicAddressEntity";
            }
        };
    }

    public Object insertOrIgnore(final PublicAddressEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                PublicAddressDao_Impl.this.__db.beginTransaction();
                try {
                    PublicAddressDao_Impl.this.__insertionAdapterOfPublicAddressEntity.insert((Object[])entities);
                    PublicAddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PublicAddressDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final PublicAddressEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                PublicAddressDao_Impl.this.__db.beginTransaction();
                try {
                    PublicAddressDao_Impl.this.__deletionAdapterOfPublicAddressEntity.handleMultiple((Object[])entities);
                    PublicAddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PublicAddressDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final PublicAddressEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                PublicAddressDao_Impl.this.__db.beginTransaction();
                try {
                    PublicAddressDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += PublicAddressDao_Impl.this.__updateAdapterOfPublicAddressEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    PublicAddressDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final PublicAddressEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return PublicAddressDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteByEmail(final String email, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PublicAddressDao_Impl.this.__preparedStmtOfDeleteByEmail.acquire();
                int _argIndex = 1;
                if (email == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, email);
                }
                PublicAddressDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PublicAddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PublicAddressDao_Impl.this.__db.endTransaction();
                    PublicAddressDao_Impl.this.__preparedStmtOfDeleteByEmail.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAll(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PublicAddressDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                PublicAddressDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PublicAddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PublicAddressDao_Impl.this.__db.endTransaction();
                    PublicAddressDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<PublicAddressEntity> findByEmail(String email) {
        String _sql = "SELECT * FROM PublicAddressEntity WHERE email = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PublicAddressEntity WHERE email = ?", (int)1);
        int _argIndex = 1;
        if (email == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, email);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"PublicAddressEntity"}, (Callable)new Callable<PublicAddressEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PublicAddressEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PublicAddressDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PublicAddressEntity _result;
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfRecipientType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recipientType");
                    int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_data");
                    int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_signature");
                    if (_cursor.moveToFirst()) {
                        SignedKeyListEntity _tmpSignedKeyListEntity;
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        int _tmpRecipientType = _cursor.getInt(_cursorIndexOfRecipientType);
                        String _tmpMimeType = _cursor.isNull(_cursorIndexOfMimeType) ? null : _cursor.getString(_cursorIndexOfMimeType);
                        if (!_cursor.isNull(_cursorIndexOfData) || !_cursor.isNull(_cursorIndexOfSignature)) {
                            String _tmpData = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                            String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                            _tmpSignedKeyListEntity = new SignedKeyListEntity(_tmpData, _tmpSignature);
                        } else {
                            _tmpSignedKeyListEntity = null;
                        }
                        _result = new PublicAddressEntity(_tmpEmail, _tmpRecipientType, _tmpMimeType, _tmpSignedKeyListEntity);
                    } else {
                        _result = null;
                    }
                    PublicAddressEntity publicAddressEntity = _result;
                    return publicAddressEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

