/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.label.data.local;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.label.data.local.LabelDao;
import me.proton.core.label.data.local.LabelEntity;

public final class LabelDao_Impl
extends LabelDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<LabelEntity> __insertionAdapterOfLabelEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EntityDeletionOrUpdateAdapter<LabelEntity> __deletionAdapterOfLabelEntity;
    private final EntityDeletionOrUpdateAdapter<LabelEntity> __updateAdapterOfLabelEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public LabelDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLabelEntity = new EntityInsertionAdapter<LabelEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `LabelEntity` (`userId`,`labelId`,`parentId`,`name`,`type`,`path`,`color`,`order`,`isNotified`,`isExpanded`,`isSticky`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, LabelEntity value) {
                Integer _tmp_3;
                Integer _tmp_2;
                Integer _tmp_1;
                String _tmp = LabelDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getLabelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getLabelId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getParentId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                stmt.bindLong(5, (long)value.getType());
                if (value.getPath() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPath());
                }
                if (value.getColor() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getColor());
                }
                stmt.bindLong(8, (long)value.getOrder());
                Integer n = value.isNotified() == null ? null : (_tmp_1 = Integer.valueOf(value.isNotified() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp_1.intValue());
                }
                Integer n2 = value.isExpanded() == null ? null : (_tmp_2 = Integer.valueOf(value.isExpanded() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)_tmp_2.intValue());
                }
                Integer n3 = value.isSticky() == null ? null : (_tmp_3 = Integer.valueOf(value.isSticky() != false ? 1 : 0));
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)_tmp_3.intValue());
                }
            }
        };
        this.__deletionAdapterOfLabelEntity = new EntityDeletionOrUpdateAdapter<LabelEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `LabelEntity` WHERE `userId` = ? AND `labelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, LabelEntity value) {
                String _tmp = LabelDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getLabelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getLabelId());
                }
            }
        };
        this.__updateAdapterOfLabelEntity = new EntityDeletionOrUpdateAdapter<LabelEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `LabelEntity` SET `userId` = ?,`labelId` = ?,`parentId` = ?,`name` = ?,`type` = ?,`path` = ?,`color` = ?,`order` = ?,`isNotified` = ?,`isExpanded` = ?,`isSticky` = ? WHERE `userId` = ? AND `labelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, LabelEntity value) {
                Integer _tmp_3;
                Integer _tmp_2;
                Integer _tmp_1;
                String _tmp = LabelDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getLabelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getLabelId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getParentId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                stmt.bindLong(5, (long)value.getType());
                if (value.getPath() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPath());
                }
                if (value.getColor() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getColor());
                }
                stmt.bindLong(8, (long)value.getOrder());
                Integer n = value.isNotified() == null ? null : (_tmp_1 = Integer.valueOf(value.isNotified() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp_1.intValue());
                }
                Integer n2 = value.isExpanded() == null ? null : (_tmp_2 = Integer.valueOf(value.isExpanded() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)_tmp_2.intValue());
                }
                Integer n3 = value.isSticky() == null ? null : (_tmp_3 = Integer.valueOf(value.isSticky() != false ? 1 : 0));
                if (_tmp_3 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)_tmp_3.intValue());
                }
                String _tmp_4 = LabelDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                if (value.getLabelId() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getLabelId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM LabelEntity WHERE userId = ?";
                return "DELETE FROM LabelEntity WHERE userId = ?";
            }
        };
    }

    public Object insertOrIgnore(final LabelEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                LabelDao_Impl.this.__db.beginTransaction();
                try {
                    LabelDao_Impl.this.__insertionAdapterOfLabelEntity.insert((Object[])entities);
                    LabelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    LabelDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final LabelEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                LabelDao_Impl.this.__db.beginTransaction();
                try {
                    LabelDao_Impl.this.__deletionAdapterOfLabelEntity.handleMultiple((Object[])entities);
                    LabelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    LabelDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final LabelEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                LabelDao_Impl.this.__db.beginTransaction();
                try {
                    LabelDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += LabelDao_Impl.this.__updateAdapterOfLabelEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    LabelDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final LabelEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return LabelDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteAll(final UserId userId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = LabelDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                int _argIndex = 1;
                String _tmp = LabelDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                LabelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    LabelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    LabelDao_Impl.this.__db.endTransaction();
                    LabelDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg1);
    }

    public Flow<List<LabelEntity>> observeAll(UserId userId, int type) {
        String _sql = "SELECT * FROM LabelEntity WHERE userId = ? AND type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM LabelEntity WHERE userId = ? AND type = ?", (int)2);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)type);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"LabelEntity"}, (Callable)new Callable<List<LabelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LabelEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)LabelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfLabelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"labelId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfColor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"color");
                    int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                    int _cursorIndexOfIsNotified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isNotified");
                    int _cursorIndexOfIsExpanded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isExpanded");
                    int _cursorIndexOfIsSticky = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSticky");
                    ArrayList<LabelEntity> _result = new ArrayList<LabelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = LabelDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpLabelId = _cursor.isNull(_cursorIndexOfLabelId) ? null : _cursor.getString(_cursorIndexOfLabelId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        int _tmpType = _cursor.getInt(_cursorIndexOfType);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpColor = _cursor.isNull(_cursorIndexOfColor) ? null : _cursor.getString(_cursorIndexOfColor);
                        int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfIsNotified) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsNotified));
                        Boolean _tmpIsNotified = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        Integer _tmp_3 = _cursor.isNull(_cursorIndexOfIsExpanded) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsExpanded));
                        Boolean _tmpIsExpanded = _tmp_3 == null ? null : Boolean.valueOf(_tmp_3 != 0);
                        Integer _tmp_4 = _cursor.isNull(_cursorIndexOfIsSticky) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsSticky));
                        Boolean _tmpIsSticky = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        LabelEntity _item = new LabelEntity(_tmpUserId, _tmpLabelId, _tmpParentId, _tmpName, _tmpType, _tmpPath, _tmpColor, _tmpOrder, _tmpIsNotified, _tmpIsExpanded, _tmpIsSticky);
                        _result.add(_item);
                    }
                    ArrayList<LabelEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getAll(UserId userId, int type, Continuation<? super List<LabelEntity>> arg2) {
        String _sql = "SELECT * FROM LabelEntity WHERE userId = ? AND type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM LabelEntity WHERE userId = ? AND type = ?", (int)2);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)type);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<LabelEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LabelEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)LabelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfLabelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"labelId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfColor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"color");
                    int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                    int _cursorIndexOfIsNotified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isNotified");
                    int _cursorIndexOfIsExpanded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isExpanded");
                    int _cursorIndexOfIsSticky = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSticky");
                    ArrayList<LabelEntity> _result = new ArrayList<LabelEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = LabelDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpLabelId = _cursor.isNull(_cursorIndexOfLabelId) ? null : _cursor.getString(_cursorIndexOfLabelId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        int _tmpType = _cursor.getInt(_cursorIndexOfType);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpColor = _cursor.isNull(_cursorIndexOfColor) ? null : _cursor.getString(_cursorIndexOfColor);
                        int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfIsNotified) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsNotified));
                        Boolean _tmpIsNotified = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        Integer _tmp_3 = _cursor.isNull(_cursorIndexOfIsExpanded) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsExpanded));
                        Boolean _tmpIsExpanded = _tmp_3 == null ? null : Boolean.valueOf(_tmp_3 != 0);
                        Integer _tmp_4 = _cursor.isNull(_cursorIndexOfIsSticky) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsSticky));
                        Boolean _tmpIsSticky = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        LabelEntity _item = new LabelEntity(_tmpUserId, _tmpLabelId, _tmpParentId, _tmpName, _tmpType, _tmpPath, _tmpColor, _tmpOrder, _tmpIsNotified, _tmpIsExpanded, _tmpIsSticky);
                        _result.add(_item);
                    }
                    ArrayList<LabelEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg2);
    }

    public Object delete(final UserId userId, final List<String> labelIds, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM LabelEntity WHERE userId = ");
                _stringBuilder.append("?");
                _stringBuilder.append(" AND labelId IN (");
                int _inputSize = labelIds.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = LabelDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                String _tmp = LabelDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                for (String _item : labelIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                LabelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    LabelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    LabelDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg2);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

