/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.usersettings.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.usersettings.data.db.dao.OrganizationKeysDao;
import me.proton.core.usersettings.data.entity.OrganizationKeysEntity;

public final class OrganizationKeysDao_Impl
extends OrganizationKeysDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OrganizationKeysEntity> __insertionAdapterOfOrganizationKeysEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EntityDeletionOrUpdateAdapter<OrganizationKeysEntity> __deletionAdapterOfOrganizationKeysEntity;
    private final EntityDeletionOrUpdateAdapter<OrganizationKeysEntity> __updateAdapterOfOrganizationKeysEntity;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public OrganizationKeysDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOrganizationKeysEntity = new EntityInsertionAdapter<OrganizationKeysEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `OrganizationKeysEntity` (`userId`,`publicKey`,`privateKey`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, OrganizationKeysEntity value) {
                String _tmp = OrganizationKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getPublicKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPublicKey());
                }
                if (value.getPrivateKey() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPrivateKey());
                }
            }
        };
        this.__deletionAdapterOfOrganizationKeysEntity = new EntityDeletionOrUpdateAdapter<OrganizationKeysEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `OrganizationKeysEntity` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, OrganizationKeysEntity value) {
                String _tmp = OrganizationKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfOrganizationKeysEntity = new EntityDeletionOrUpdateAdapter<OrganizationKeysEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `OrganizationKeysEntity` SET `userId` = ?,`publicKey` = ?,`privateKey` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, OrganizationKeysEntity value) {
                String _tmp = OrganizationKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getPublicKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPublicKey());
                }
                if (value.getPrivateKey() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPrivateKey());
                }
                String _tmp_1 = OrganizationKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM OrganizationKeysEntity WHERE userId = ?";
                return "DELETE FROM OrganizationKeysEntity WHERE userId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM OrganizationKeysEntity";
                return "DELETE FROM OrganizationKeysEntity";
            }
        };
    }

    public Object insertOrIgnore(final OrganizationKeysEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                OrganizationKeysDao_Impl.this.__db.beginTransaction();
                try {
                    OrganizationKeysDao_Impl.this.__insertionAdapterOfOrganizationKeysEntity.insert((Object[])entities);
                    OrganizationKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OrganizationKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final OrganizationKeysEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                OrganizationKeysDao_Impl.this.__db.beginTransaction();
                try {
                    OrganizationKeysDao_Impl.this.__deletionAdapterOfOrganizationKeysEntity.handleMultiple((Object[])entities);
                    OrganizationKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OrganizationKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final OrganizationKeysEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                OrganizationKeysDao_Impl.this.__db.beginTransaction();
                try {
                    OrganizationKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += OrganizationKeysDao_Impl.this.__updateAdapterOfOrganizationKeysEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    OrganizationKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final OrganizationKeysEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return OrganizationKeysDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object delete(final UserId userId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = OrganizationKeysDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                String _tmp = OrganizationKeysDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                OrganizationKeysDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    OrganizationKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OrganizationKeysDao_Impl.this.__db.endTransaction();
                    OrganizationKeysDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAll(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = OrganizationKeysDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                OrganizationKeysDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    OrganizationKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    OrganizationKeysDao_Impl.this.__db.endTransaction();
                    OrganizationKeysDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<OrganizationKeysEntity> observeByUserId(UserId userId) {
        String _sql = "SELECT * FROM OrganizationKeysEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM OrganizationKeysEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"OrganizationKeysEntity"}, (Callable)new Callable<OrganizationKeysEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OrganizationKeysEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OrganizationKeysDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    OrganizationKeysEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privateKey");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = OrganizationKeysDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpPublicKey = _cursor.isNull(_cursorIndexOfPublicKey) ? null : _cursor.getString(_cursorIndexOfPublicKey);
                        String _tmpPrivateKey = _cursor.isNull(_cursorIndexOfPrivateKey) ? null : _cursor.getString(_cursorIndexOfPrivateKey);
                        _result = new OrganizationKeysEntity(_tmpUserId, _tmpPublicKey, _tmpPrivateKey);
                    } else {
                        _result = null;
                    }
                    OrganizationKeysEntity organizationKeysEntity = _result;
                    return organizationKeysEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getByUserId(UserId userId, Continuation<? super OrganizationKeysEntity> arg1) {
        String _sql = "SELECT * FROM OrganizationKeysEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM OrganizationKeysEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<OrganizationKeysEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OrganizationKeysEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)OrganizationKeysDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    OrganizationKeysEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privateKey");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = OrganizationKeysDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpPublicKey = _cursor.isNull(_cursorIndexOfPublicKey) ? null : _cursor.getString(_cursorIndexOfPublicKey);
                        String _tmpPrivateKey = _cursor.isNull(_cursorIndexOfPrivateKey) ? null : _cursor.getString(_cursorIndexOfPrivateKey);
                        _result = new OrganizationKeysEntity(_tmpUserId, _tmpPublicKey, _tmpPrivateKey);
                    } else {
                        _result = null;
                    }
                    OrganizationKeysEntity organizationKeysEntity = _result;
                    return organizationKeysEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

