/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.accountmanager.data.db;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.proton.core.account.data.db.AccountDao;
import me.proton.core.account.data.db.AccountDao_Impl;
import me.proton.core.account.data.db.AccountMetadataDao;
import me.proton.core.account.data.db.AccountMetadataDao_Impl;
import me.proton.core.account.data.db.SessionDao;
import me.proton.core.account.data.db.SessionDao_Impl;
import me.proton.core.account.data.db.SessionDetailsDao;
import me.proton.core.account.data.db.SessionDetailsDao_Impl;
import me.proton.core.accountmanager.data.db.AccountManagerDatabase;
import me.proton.core.challenge.data.db.ChallengeFramesDao;
import me.proton.core.challenge.data.db.ChallengeFramesDao_Impl;
import me.proton.core.contact.data.local.db.dao.ContactCardDao;
import me.proton.core.contact.data.local.db.dao.ContactCardDao_Impl;
import me.proton.core.contact.data.local.db.dao.ContactDao;
import me.proton.core.contact.data.local.db.dao.ContactDao_Impl;
import me.proton.core.contact.data.local.db.dao.ContactEmailDao;
import me.proton.core.contact.data.local.db.dao.ContactEmailDao_Impl;
import me.proton.core.contact.data.local.db.dao.ContactEmailLabelDao;
import me.proton.core.contact.data.local.db.dao.ContactEmailLabelDao_Impl;
import me.proton.core.eventmanager.data.db.dao.EventMetadataDao;
import me.proton.core.eventmanager.data.db.dao.EventMetadataDao_Impl;
import me.proton.core.featureflag.data.db.dao.FeatureFlagDao;
import me.proton.core.featureflag.data.db.dao.FeatureFlagDao_Impl;
import me.proton.core.humanverification.data.db.HumanVerificationDetailsDao;
import me.proton.core.humanverification.data.db.HumanVerificationDetailsDao_Impl;
import me.proton.core.key.data.db.KeySaltDao;
import me.proton.core.key.data.db.KeySaltDao_Impl;
import me.proton.core.key.data.db.PublicAddressDao;
import me.proton.core.key.data.db.PublicAddressDao_Impl;
import me.proton.core.key.data.db.PublicAddressKeyDao;
import me.proton.core.key.data.db.PublicAddressKeyDao_Impl;
import me.proton.core.key.data.db.PublicAddressWithKeysDao;
import me.proton.core.key.data.db.PublicAddressWithKeysDao_Impl;
import me.proton.core.label.data.local.LabelDao;
import me.proton.core.label.data.local.LabelDao_Impl;
import me.proton.core.mailsettings.data.db.dao.MailSettingsDao;
import me.proton.core.mailsettings.data.db.dao.MailSettingsDao_Impl;
import me.proton.core.user.data.db.dao.AddressDao;
import me.proton.core.user.data.db.dao.AddressDao_Impl;
import me.proton.core.user.data.db.dao.AddressKeyDao;
import me.proton.core.user.data.db.dao.AddressKeyDao_Impl;
import me.proton.core.user.data.db.dao.AddressWithKeysDao;
import me.proton.core.user.data.db.dao.AddressWithKeysDao_Impl;
import me.proton.core.user.data.db.dao.UserDao;
import me.proton.core.user.data.db.dao.UserDao_Impl;
import me.proton.core.user.data.db.dao.UserKeyDao;
import me.proton.core.user.data.db.dao.UserKeyDao_Impl;
import me.proton.core.user.data.db.dao.UserWithKeysDao;
import me.proton.core.user.data.db.dao.UserWithKeysDao_Impl;
import me.proton.core.usersettings.data.db.dao.OrganizationDao;
import me.proton.core.usersettings.data.db.dao.OrganizationDao_Impl;
import me.proton.core.usersettings.data.db.dao.OrganizationKeysDao;
import me.proton.core.usersettings.data.db.dao.OrganizationKeysDao_Impl;
import me.proton.core.usersettings.data.db.dao.UserSettingsDao;
import me.proton.core.usersettings.data.db.dao.UserSettingsDao_Impl;

public final class AccountManagerDatabase_Impl
extends AccountManagerDatabase {
    private volatile AccountDao _accountDao;
    private volatile SessionDao _sessionDao;
    private volatile AccountMetadataDao _accountMetadataDao;
    private volatile SessionDetailsDao _sessionDetailsDao;
    private volatile UserKeyDao _userKeyDao;
    private volatile UserDao _userDao;
    private volatile UserWithKeysDao _userWithKeysDao;
    private volatile AddressKeyDao _addressKeyDao;
    private volatile AddressDao _addressDao;
    private volatile AddressWithKeysDao _addressWithKeysDao;
    private volatile KeySaltDao _keySaltDao;
    private volatile HumanVerificationDetailsDao _humanVerificationDetailsDao;
    private volatile PublicAddressDao _publicAddressDao;
    private volatile PublicAddressKeyDao _publicAddressKeyDao;
    private volatile PublicAddressWithKeysDao _publicAddressWithKeysDao;
    private volatile MailSettingsDao _mailSettingsDao;
    private volatile UserSettingsDao _userSettingsDao;
    private volatile OrganizationDao _organizationDao;
    private volatile OrganizationKeysDao _organizationKeysDao;
    private volatile ContactDao _contactDao;
    private volatile ContactCardDao _contactCardDao;
    private volatile ContactEmailDao _contactEmailDao;
    private volatile ContactEmailLabelDao _contactEmailLabelDao;
    private volatile EventMetadataDao _eventMetadataDao;
    private volatile LabelDao _labelDao;
    private volatile FeatureFlagDao _featureFlagDao;
    private volatile ChallengeFramesDao _challengeFramesDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(17){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `AccountEntity` (`userId` TEXT NOT NULL, `username` TEXT NOT NULL, `email` TEXT, `state` TEXT NOT NULL, `sessionId` TEXT, `sessionState` TEXT, PRIMARY KEY(`userId`), FOREIGN KEY(`sessionId`) REFERENCES `SessionEntity`(`sessionId`) ON UPDATE NO ACTION ON DELETE NO ACTION )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountEntity_sessionId` ON `AccountEntity` (`sessionId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountEntity_userId` ON `AccountEntity` (`userId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `AccountMetadataEntity` (`userId` TEXT NOT NULL, `product` TEXT NOT NULL, `primaryAtUtc` INTEGER NOT NULL, `migrations` TEXT, PRIMARY KEY(`userId`, `product`), FOREIGN KEY(`userId`) REFERENCES `AccountEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountMetadataEntity_userId` ON `AccountMetadataEntity` (`userId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountMetadataEntity_product` ON `AccountMetadataEntity` (`product`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountMetadataEntity_primaryAtUtc` ON `AccountMetadataEntity` (`primaryAtUtc`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `SessionEntity` (`userId` TEXT NOT NULL, `sessionId` TEXT NOT NULL, `accessToken` TEXT NOT NULL, `refreshToken` TEXT NOT NULL, `scopes` TEXT NOT NULL, `product` TEXT NOT NULL, PRIMARY KEY(`sessionId`), FOREIGN KEY(`userId`) REFERENCES `AccountEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SessionEntity_sessionId` ON `SessionEntity` (`sessionId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SessionEntity_userId` ON `SessionEntity` (`userId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `SessionDetailsEntity` (`sessionId` TEXT NOT NULL, `initialEventId` TEXT NOT NULL, `requiredAccountType` TEXT NOT NULL, `secondFactorEnabled` INTEGER NOT NULL, `twoPassModeEnabled` INTEGER NOT NULL, `password` TEXT, PRIMARY KEY(`sessionId`), FOREIGN KEY(`sessionId`) REFERENCES `SessionEntity`(`sessionId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SessionDetailsEntity_sessionId` ON `SessionDetailsEntity` (`sessionId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `UserEntity` (`userId` TEXT NOT NULL, `email` TEXT, `name` TEXT, `displayName` TEXT, `currency` TEXT NOT NULL, `credit` INTEGER NOT NULL, `usedSpace` INTEGER NOT NULL, `maxSpace` INTEGER NOT NULL, `maxUpload` INTEGER NOT NULL, `role` INTEGER, `private` INTEGER NOT NULL, `subscribed` INTEGER NOT NULL, `services` INTEGER NOT NULL, `delinquent` INTEGER, `passphrase` BLOB, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `AccountEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_UserEntity_userId` ON `UserEntity` (`userId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `UserKeyEntity` (`userId` TEXT NOT NULL, `keyId` TEXT NOT NULL, `version` INTEGER NOT NULL, `privateKey` TEXT NOT NULL, `isPrimary` INTEGER NOT NULL, `isUnlockable` INTEGER NOT NULL, `fingerprint` TEXT, `activation` TEXT, `active` INTEGER, PRIMARY KEY(`keyId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_UserKeyEntity_userId` ON `UserKeyEntity` (`userId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_UserKeyEntity_keyId` ON `UserKeyEntity` (`keyId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `AddressEntity` (`userId` TEXT NOT NULL, `addressId` TEXT NOT NULL, `email` TEXT NOT NULL, `displayName` TEXT, `signature` TEXT, `domainId` TEXT, `canSend` INTEGER NOT NULL, `canReceive` INTEGER NOT NULL, `enabled` INTEGER NOT NULL, `type` INTEGER, `order` INTEGER NOT NULL, `signedKeyList_data` TEXT, `signedKeyList_signature` TEXT, PRIMARY KEY(`addressId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AddressEntity_addressId` ON `AddressEntity` (`addressId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AddressEntity_userId` ON `AddressEntity` (`userId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `AddressKeyEntity` (`addressId` TEXT NOT NULL, `keyId` TEXT NOT NULL, `version` INTEGER NOT NULL, `privateKey` TEXT NOT NULL, `isPrimary` INTEGER NOT NULL, `isUnlockable` INTEGER NOT NULL, `flags` INTEGER NOT NULL, `passphrase` BLOB, `token` TEXT, `signature` TEXT, `fingerprint` TEXT, `fingerprints` TEXT, `activation` TEXT, `active` INTEGER NOT NULL, PRIMARY KEY(`keyId`), FOREIGN KEY(`addressId`) REFERENCES `AddressEntity`(`addressId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AddressKeyEntity_addressId` ON `AddressKeyEntity` (`addressId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AddressKeyEntity_keyId` ON `AddressKeyEntity` (`keyId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `KeySaltEntity` (`userId` TEXT NOT NULL, `keyId` TEXT NOT NULL, `keySalt` TEXT, PRIMARY KEY(`userId`, `keyId`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_KeySaltEntity_userId` ON `KeySaltEntity` (`userId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_KeySaltEntity_keyId` ON `KeySaltEntity` (`keyId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `PublicAddressEntity` (`email` TEXT NOT NULL, `recipientType` INTEGER NOT NULL, `mimeType` TEXT, `signedKeyList_data` TEXT, `signedKeyList_signature` TEXT, PRIMARY KEY(`email`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PublicAddressEntity_email` ON `PublicAddressEntity` (`email`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `PublicAddressKeyEntity` (`email` TEXT NOT NULL, `flags` INTEGER NOT NULL, `publicKey` TEXT NOT NULL, `isPrimary` INTEGER NOT NULL, PRIMARY KEY(`email`, `publicKey`), FOREIGN KEY(`email`) REFERENCES `PublicAddressEntity`(`email`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PublicAddressKeyEntity_email` ON `PublicAddressKeyEntity` (`email`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `HumanVerificationEntity` (`clientId` TEXT NOT NULL, `clientIdType` TEXT NOT NULL, `verificationMethods` TEXT NOT NULL, `captchaVerificationToken` TEXT, `state` TEXT NOT NULL, `humanHeaderTokenType` TEXT, `humanHeaderTokenCode` TEXT, PRIMARY KEY(`clientId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `MailSettingsEntity` (`userId` TEXT NOT NULL, `displayName` TEXT, `signature` TEXT, `autoSaveContacts` INTEGER, `composerMode` INTEGER, `messageButtons` INTEGER, `showImages` INTEGER, `showMoved` INTEGER, `viewMode` INTEGER, `viewLayout` INTEGER, `swipeLeft` INTEGER, `swipeRight` INTEGER, `shortcuts` INTEGER, `pmSignature` INTEGER, `numMessagePerPage` INTEGER, `draftMimeType` TEXT, `receiveMimeType` TEXT, `showMimeType` TEXT, `enableFolderColor` INTEGER, `inheritParentFolderColor` INTEGER, `rightToLeft` INTEGER, `attachPublicKey` INTEGER, `sign` INTEGER, `pgpScheme` INTEGER, `promptPin` INTEGER, `stickyLabels` INTEGER, `confirmLink` INTEGER, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `UserSettingsEntity` (`userId` TEXT NOT NULL, `news` INTEGER, `locale` TEXT, `logAuth` INTEGER, `invoiceText` TEXT, `density` INTEGER, `theme` TEXT, `themeType` INTEGER, `weekStart` INTEGER, `dateFormat` INTEGER, `timeFormat` INTEGER, `welcome` INTEGER, `earlyAccess` INTEGER, `email_value` TEXT, `email_status` INTEGER, `email_notify` INTEGER, `email_reset` INTEGER, `phone_value` TEXT, `phone_status` INTEGER, `phone_notify` INTEGER, `phone_reset` INTEGER, `password_mode` INTEGER, `password_expirationTime` INTEGER, `twoFA_enabled` INTEGER, `twoFA_allowed` INTEGER, `twoFA_expirationTime` INTEGER, `twoFA_u2fKeys` TEXT, `flags_welcomed` INTEGER, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `OrganizationEntity` (`userId` TEXT NOT NULL, `name` TEXT NOT NULL, `displayName` TEXT, `planName` TEXT, `vpnPlanName` TEXT, `twoFactorGracePeriod` INTEGER, `theme` TEXT, `email` TEXT, `maxDomains` INTEGER, `maxAddresses` INTEGER, `maxSpace` INTEGER, `maxMembers` INTEGER, `maxVPN` INTEGER, `maxCalendars` INTEGER, `features` INTEGER, `flags` INTEGER, `usedDomains` INTEGER, `usedAddresses` INTEGER, `usedSpace` INTEGER, `assignedSpace` INTEGER, `usedMembers` INTEGER, `usedVPN` INTEGER, `usedCalendars` INTEGER, `hasKeys` INTEGER, `toMigrate` INTEGER, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `OrganizationKeysEntity` (`userId` TEXT NOT NULL, `publicKey` TEXT NOT NULL, `privateKey` TEXT NOT NULL, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `ContactEntity` (`userId` TEXT NOT NULL, `contactId` TEXT NOT NULL, `name` TEXT NOT NULL, PRIMARY KEY(`contactId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContactEntity_userId` ON `ContactEntity` (`userId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `ContactCardEntity` (`contactId` TEXT NOT NULL, `type` INTEGER NOT NULL, `data` TEXT NOT NULL, `signature` TEXT, `cardId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, FOREIGN KEY(`contactId`) REFERENCES `ContactEntity`(`contactId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContactCardEntity_contactId` ON `ContactCardEntity` (`contactId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `ContactEmailEntity` (`userId` TEXT NOT NULL, `contactEmailId` TEXT NOT NULL, `name` TEXT NOT NULL, `email` TEXT NOT NULL, `defaults` INTEGER NOT NULL, `order` INTEGER NOT NULL, `contactId` TEXT NOT NULL, `canonicalEmail` TEXT, PRIMARY KEY(`contactEmailId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE , FOREIGN KEY(`contactId`) REFERENCES `ContactEntity`(`contactId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContactEmailEntity_userId` ON `ContactEmailEntity` (`userId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContactEmailEntity_contactId` ON `ContactEmailEntity` (`contactId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `ContactEmailLabelEntity` (`contactEmailId` TEXT NOT NULL, `labelId` TEXT NOT NULL, PRIMARY KEY(`contactEmailId`, `labelId`), FOREIGN KEY(`contactEmailId`) REFERENCES `ContactEmailEntity`(`contactEmailId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `EventMetadataEntity` (`userId` TEXT NOT NULL, `config` TEXT NOT NULL, `eventId` TEXT, `nextEventId` TEXT, `refresh` TEXT, `more` INTEGER, `response` TEXT, `retry` INTEGER NOT NULL, `state` TEXT NOT NULL, `createdAt` INTEGER NOT NULL, `updatedAt` INTEGER, PRIMARY KEY(`userId`, `config`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_EventMetadataEntity_userId` ON `EventMetadataEntity` (`userId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_EventMetadataEntity_config` ON `EventMetadataEntity` (`config`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_EventMetadataEntity_createdAt` ON `EventMetadataEntity` (`createdAt`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `LabelEntity` (`userId` TEXT NOT NULL, `labelId` TEXT NOT NULL, `parentId` TEXT, `name` TEXT NOT NULL, `type` INTEGER NOT NULL, `path` TEXT NOT NULL, `color` TEXT NOT NULL, `order` INTEGER NOT NULL, `isNotified` INTEGER, `isExpanded` INTEGER, `isSticky` INTEGER, PRIMARY KEY(`userId`, `labelId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_userId` ON `LabelEntity` (`userId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_labelId` ON `LabelEntity` (`labelId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_parentId` ON `LabelEntity` (`parentId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_name` ON `LabelEntity` (`name`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_type` ON `LabelEntity` (`type`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `FeatureFlagEntity` (`userId` TEXT, `featureId` TEXT NOT NULL, `isGlobal` INTEGER NOT NULL, `defaultValue` INTEGER NOT NULL, `value` INTEGER NOT NULL, PRIMARY KEY(`featureId`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_FeatureFlagEntity_userId` ON `FeatureFlagEntity` (`userId`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_FeatureFlagEntity_featureId` ON `FeatureFlagEntity` (`featureId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `ChallengeFrameEntity` (`challengeFrame` TEXT NOT NULL, `flow` TEXT NOT NULL, `focusTime` INTEGER NOT NULL, `clicks` INTEGER NOT NULL, `copy` TEXT NOT NULL, `paste` TEXT NOT NULL, `keys` TEXT NOT NULL, PRIMARY KEY(`challengeFrame`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '7575a152cffc6a797c6e72d5cfb725f3')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `AccountEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `AccountMetadataEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `SessionEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `SessionDetailsEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `UserEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `UserKeyEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `AddressEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `AddressKeyEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `KeySaltEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `PublicAddressEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `PublicAddressKeyEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `HumanVerificationEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `MailSettingsEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `UserSettingsEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `OrganizationEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `OrganizationKeysEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `ContactEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `ContactCardEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `ContactEmailEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `ContactEmailLabelEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `EventMetadataEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `LabelEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `FeatureFlagEntity`");
                _db.execSQL("DROP TABLE IF EXISTS `ChallengeFrameEntity`");
                if (AccountManagerDatabase_Impl.this.mCallbacks != null) {
                    int _size = AccountManagerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AccountManagerDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (AccountManagerDatabase_Impl.this.mCallbacks != null) {
                    int _size = AccountManagerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AccountManagerDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                AccountManagerDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                AccountManagerDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (AccountManagerDatabase_Impl.this.mCallbacks != null) {
                    int _size = AccountManagerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AccountManagerDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsAccountEntity = new HashMap<String, TableInfo.Column>(6);
                _columnsAccountEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsAccountEntity.put("username", new TableInfo.Column("username", "TEXT", true, 0, null, 1));
                _columnsAccountEntity.put("email", new TableInfo.Column("email", "TEXT", false, 0, null, 1));
                _columnsAccountEntity.put("state", new TableInfo.Column("state", "TEXT", true, 0, null, 1));
                _columnsAccountEntity.put("sessionId", new TableInfo.Column("sessionId", "TEXT", false, 0, null, 1));
                _columnsAccountEntity.put("sessionState", new TableInfo.Column("sessionState", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysAccountEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysAccountEntity.add(new TableInfo.ForeignKey("SessionEntity", "NO ACTION", "NO ACTION", Arrays.asList("sessionId"), Arrays.asList("sessionId")));
                HashSet<TableInfo.Index> _indicesAccountEntity = new HashSet<TableInfo.Index>(2);
                _indicesAccountEntity.add(new TableInfo.Index("index_AccountEntity_sessionId", false, Arrays.asList("sessionId"), Arrays.asList("ASC")));
                _indicesAccountEntity.add(new TableInfo.Index("index_AccountEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                TableInfo _infoAccountEntity = new TableInfo("AccountEntity", _columnsAccountEntity, _foreignKeysAccountEntity, _indicesAccountEntity);
                TableInfo _existingAccountEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"AccountEntity");
                if (!_infoAccountEntity.equals((Object)_existingAccountEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "AccountEntity(me.proton.core.account.data.entity.AccountEntity).\n Expected:\n" + _infoAccountEntity + "\n Found:\n" + _existingAccountEntity);
                }
                HashMap<String, TableInfo.Column> _columnsAccountMetadataEntity = new HashMap<String, TableInfo.Column>(4);
                _columnsAccountMetadataEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsAccountMetadataEntity.put("product", new TableInfo.Column("product", "TEXT", true, 2, null, 1));
                _columnsAccountMetadataEntity.put("primaryAtUtc", new TableInfo.Column("primaryAtUtc", "INTEGER", true, 0, null, 1));
                _columnsAccountMetadataEntity.put("migrations", new TableInfo.Column("migrations", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysAccountMetadataEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysAccountMetadataEntity.add(new TableInfo.ForeignKey("AccountEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet<TableInfo.Index> _indicesAccountMetadataEntity = new HashSet<TableInfo.Index>(3);
                _indicesAccountMetadataEntity.add(new TableInfo.Index("index_AccountMetadataEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                _indicesAccountMetadataEntity.add(new TableInfo.Index("index_AccountMetadataEntity_product", false, Arrays.asList("product"), Arrays.asList("ASC")));
                _indicesAccountMetadataEntity.add(new TableInfo.Index("index_AccountMetadataEntity_primaryAtUtc", false, Arrays.asList("primaryAtUtc"), Arrays.asList("ASC")));
                TableInfo _infoAccountMetadataEntity = new TableInfo("AccountMetadataEntity", _columnsAccountMetadataEntity, _foreignKeysAccountMetadataEntity, _indicesAccountMetadataEntity);
                TableInfo _existingAccountMetadataEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"AccountMetadataEntity");
                if (!_infoAccountMetadataEntity.equals((Object)_existingAccountMetadataEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "AccountMetadataEntity(me.proton.core.account.data.entity.AccountMetadataEntity).\n Expected:\n" + _infoAccountMetadataEntity + "\n Found:\n" + _existingAccountMetadataEntity);
                }
                HashMap<String, TableInfo.Column> _columnsSessionEntity = new HashMap<String, TableInfo.Column>(6);
                _columnsSessionEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, 1));
                _columnsSessionEntity.put("sessionId", new TableInfo.Column("sessionId", "TEXT", true, 1, null, 1));
                _columnsSessionEntity.put("accessToken", new TableInfo.Column("accessToken", "TEXT", true, 0, null, 1));
                _columnsSessionEntity.put("refreshToken", new TableInfo.Column("refreshToken", "TEXT", true, 0, null, 1));
                _columnsSessionEntity.put("scopes", new TableInfo.Column("scopes", "TEXT", true, 0, null, 1));
                _columnsSessionEntity.put("product", new TableInfo.Column("product", "TEXT", true, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysSessionEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysSessionEntity.add(new TableInfo.ForeignKey("AccountEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet<TableInfo.Index> _indicesSessionEntity = new HashSet<TableInfo.Index>(2);
                _indicesSessionEntity.add(new TableInfo.Index("index_SessionEntity_sessionId", false, Arrays.asList("sessionId"), Arrays.asList("ASC")));
                _indicesSessionEntity.add(new TableInfo.Index("index_SessionEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                TableInfo _infoSessionEntity = new TableInfo("SessionEntity", _columnsSessionEntity, _foreignKeysSessionEntity, _indicesSessionEntity);
                TableInfo _existingSessionEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"SessionEntity");
                if (!_infoSessionEntity.equals((Object)_existingSessionEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "SessionEntity(me.proton.core.account.data.entity.SessionEntity).\n Expected:\n" + _infoSessionEntity + "\n Found:\n" + _existingSessionEntity);
                }
                HashMap<String, TableInfo.Column> _columnsSessionDetailsEntity = new HashMap<String, TableInfo.Column>(6);
                _columnsSessionDetailsEntity.put("sessionId", new TableInfo.Column("sessionId", "TEXT", true, 1, null, 1));
                _columnsSessionDetailsEntity.put("initialEventId", new TableInfo.Column("initialEventId", "TEXT", true, 0, null, 1));
                _columnsSessionDetailsEntity.put("requiredAccountType", new TableInfo.Column("requiredAccountType", "TEXT", true, 0, null, 1));
                _columnsSessionDetailsEntity.put("secondFactorEnabled", new TableInfo.Column("secondFactorEnabled", "INTEGER", true, 0, null, 1));
                _columnsSessionDetailsEntity.put("twoPassModeEnabled", new TableInfo.Column("twoPassModeEnabled", "INTEGER", true, 0, null, 1));
                _columnsSessionDetailsEntity.put("password", new TableInfo.Column("password", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysSessionDetailsEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysSessionDetailsEntity.add(new TableInfo.ForeignKey("SessionEntity", "CASCADE", "NO ACTION", Arrays.asList("sessionId"), Arrays.asList("sessionId")));
                HashSet<TableInfo.Index> _indicesSessionDetailsEntity = new HashSet<TableInfo.Index>(1);
                _indicesSessionDetailsEntity.add(new TableInfo.Index("index_SessionDetailsEntity_sessionId", false, Arrays.asList("sessionId"), Arrays.asList("ASC")));
                TableInfo _infoSessionDetailsEntity = new TableInfo("SessionDetailsEntity", _columnsSessionDetailsEntity, _foreignKeysSessionDetailsEntity, _indicesSessionDetailsEntity);
                TableInfo _existingSessionDetailsEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"SessionDetailsEntity");
                if (!_infoSessionDetailsEntity.equals((Object)_existingSessionDetailsEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "SessionDetailsEntity(me.proton.core.account.data.entity.SessionDetailsEntity).\n Expected:\n" + _infoSessionDetailsEntity + "\n Found:\n" + _existingSessionDetailsEntity);
                }
                HashMap<String, TableInfo.Column> _columnsUserEntity = new HashMap<String, TableInfo.Column>(15);
                _columnsUserEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsUserEntity.put("email", new TableInfo.Column("email", "TEXT", false, 0, null, 1));
                _columnsUserEntity.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsUserEntity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0, null, 1));
                _columnsUserEntity.put("currency", new TableInfo.Column("currency", "TEXT", true, 0, null, 1));
                _columnsUserEntity.put("credit", new TableInfo.Column("credit", "INTEGER", true, 0, null, 1));
                _columnsUserEntity.put("usedSpace", new TableInfo.Column("usedSpace", "INTEGER", true, 0, null, 1));
                _columnsUserEntity.put("maxSpace", new TableInfo.Column("maxSpace", "INTEGER", true, 0, null, 1));
                _columnsUserEntity.put("maxUpload", new TableInfo.Column("maxUpload", "INTEGER", true, 0, null, 1));
                _columnsUserEntity.put("role", new TableInfo.Column("role", "INTEGER", false, 0, null, 1));
                _columnsUserEntity.put("private", new TableInfo.Column("private", "INTEGER", true, 0, null, 1));
                _columnsUserEntity.put("subscribed", new TableInfo.Column("subscribed", "INTEGER", true, 0, null, 1));
                _columnsUserEntity.put("services", new TableInfo.Column("services", "INTEGER", true, 0, null, 1));
                _columnsUserEntity.put("delinquent", new TableInfo.Column("delinquent", "INTEGER", false, 0, null, 1));
                _columnsUserEntity.put("passphrase", new TableInfo.Column("passphrase", "BLOB", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysUserEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysUserEntity.add(new TableInfo.ForeignKey("AccountEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet<TableInfo.Index> _indicesUserEntity = new HashSet<TableInfo.Index>(1);
                _indicesUserEntity.add(new TableInfo.Index("index_UserEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                TableInfo _infoUserEntity = new TableInfo("UserEntity", _columnsUserEntity, _foreignKeysUserEntity, _indicesUserEntity);
                TableInfo _existingUserEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"UserEntity");
                if (!_infoUserEntity.equals((Object)_existingUserEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "UserEntity(me.proton.core.user.data.entity.UserEntity).\n Expected:\n" + _infoUserEntity + "\n Found:\n" + _existingUserEntity);
                }
                HashMap<String, TableInfo.Column> _columnsUserKeyEntity = new HashMap<String, TableInfo.Column>(9);
                _columnsUserKeyEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, 1));
                _columnsUserKeyEntity.put("keyId", new TableInfo.Column("keyId", "TEXT", true, 1, null, 1));
                _columnsUserKeyEntity.put("version", new TableInfo.Column("version", "INTEGER", true, 0, null, 1));
                _columnsUserKeyEntity.put("privateKey", new TableInfo.Column("privateKey", "TEXT", true, 0, null, 1));
                _columnsUserKeyEntity.put("isPrimary", new TableInfo.Column("isPrimary", "INTEGER", true, 0, null, 1));
                _columnsUserKeyEntity.put("isUnlockable", new TableInfo.Column("isUnlockable", "INTEGER", true, 0, null, 1));
                _columnsUserKeyEntity.put("fingerprint", new TableInfo.Column("fingerprint", "TEXT", false, 0, null, 1));
                _columnsUserKeyEntity.put("activation", new TableInfo.Column("activation", "TEXT", false, 0, null, 1));
                _columnsUserKeyEntity.put("active", new TableInfo.Column("active", "INTEGER", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysUserKeyEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysUserKeyEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet<TableInfo.Index> _indicesUserKeyEntity = new HashSet<TableInfo.Index>(2);
                _indicesUserKeyEntity.add(new TableInfo.Index("index_UserKeyEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                _indicesUserKeyEntity.add(new TableInfo.Index("index_UserKeyEntity_keyId", false, Arrays.asList("keyId"), Arrays.asList("ASC")));
                TableInfo _infoUserKeyEntity = new TableInfo("UserKeyEntity", _columnsUserKeyEntity, _foreignKeysUserKeyEntity, _indicesUserKeyEntity);
                TableInfo _existingUserKeyEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"UserKeyEntity");
                if (!_infoUserKeyEntity.equals((Object)_existingUserKeyEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "UserKeyEntity(me.proton.core.user.data.entity.UserKeyEntity).\n Expected:\n" + _infoUserKeyEntity + "\n Found:\n" + _existingUserKeyEntity);
                }
                HashMap<String, TableInfo.Column> _columnsAddressEntity = new HashMap<String, TableInfo.Column>(13);
                _columnsAddressEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, 1));
                _columnsAddressEntity.put("addressId", new TableInfo.Column("addressId", "TEXT", true, 1, null, 1));
                _columnsAddressEntity.put("email", new TableInfo.Column("email", "TEXT", true, 0, null, 1));
                _columnsAddressEntity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0, null, 1));
                _columnsAddressEntity.put("signature", new TableInfo.Column("signature", "TEXT", false, 0, null, 1));
                _columnsAddressEntity.put("domainId", new TableInfo.Column("domainId", "TEXT", false, 0, null, 1));
                _columnsAddressEntity.put("canSend", new TableInfo.Column("canSend", "INTEGER", true, 0, null, 1));
                _columnsAddressEntity.put("canReceive", new TableInfo.Column("canReceive", "INTEGER", true, 0, null, 1));
                _columnsAddressEntity.put("enabled", new TableInfo.Column("enabled", "INTEGER", true, 0, null, 1));
                _columnsAddressEntity.put("type", new TableInfo.Column("type", "INTEGER", false, 0, null, 1));
                _columnsAddressEntity.put("order", new TableInfo.Column("order", "INTEGER", true, 0, null, 1));
                _columnsAddressEntity.put("signedKeyList_data", new TableInfo.Column("signedKeyList_data", "TEXT", false, 0, null, 1));
                _columnsAddressEntity.put("signedKeyList_signature", new TableInfo.Column("signedKeyList_signature", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysAddressEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysAddressEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet<TableInfo.Index> _indicesAddressEntity = new HashSet<TableInfo.Index>(2);
                _indicesAddressEntity.add(new TableInfo.Index("index_AddressEntity_addressId", false, Arrays.asList("addressId"), Arrays.asList("ASC")));
                _indicesAddressEntity.add(new TableInfo.Index("index_AddressEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                TableInfo _infoAddressEntity = new TableInfo("AddressEntity", _columnsAddressEntity, _foreignKeysAddressEntity, _indicesAddressEntity);
                TableInfo _existingAddressEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"AddressEntity");
                if (!_infoAddressEntity.equals((Object)_existingAddressEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "AddressEntity(me.proton.core.user.data.entity.AddressEntity).\n Expected:\n" + _infoAddressEntity + "\n Found:\n" + _existingAddressEntity);
                }
                HashMap<String, TableInfo.Column> _columnsAddressKeyEntity = new HashMap<String, TableInfo.Column>(14);
                _columnsAddressKeyEntity.put("addressId", new TableInfo.Column("addressId", "TEXT", true, 0, null, 1));
                _columnsAddressKeyEntity.put("keyId", new TableInfo.Column("keyId", "TEXT", true, 1, null, 1));
                _columnsAddressKeyEntity.put("version", new TableInfo.Column("version", "INTEGER", true, 0, null, 1));
                _columnsAddressKeyEntity.put("privateKey", new TableInfo.Column("privateKey", "TEXT", true, 0, null, 1));
                _columnsAddressKeyEntity.put("isPrimary", new TableInfo.Column("isPrimary", "INTEGER", true, 0, null, 1));
                _columnsAddressKeyEntity.put("isUnlockable", new TableInfo.Column("isUnlockable", "INTEGER", true, 0, null, 1));
                _columnsAddressKeyEntity.put("flags", new TableInfo.Column("flags", "INTEGER", true, 0, null, 1));
                _columnsAddressKeyEntity.put("passphrase", new TableInfo.Column("passphrase", "BLOB", false, 0, null, 1));
                _columnsAddressKeyEntity.put("token", new TableInfo.Column("token", "TEXT", false, 0, null, 1));
                _columnsAddressKeyEntity.put("signature", new TableInfo.Column("signature", "TEXT", false, 0, null, 1));
                _columnsAddressKeyEntity.put("fingerprint", new TableInfo.Column("fingerprint", "TEXT", false, 0, null, 1));
                _columnsAddressKeyEntity.put("fingerprints", new TableInfo.Column("fingerprints", "TEXT", false, 0, null, 1));
                _columnsAddressKeyEntity.put("activation", new TableInfo.Column("activation", "TEXT", false, 0, null, 1));
                _columnsAddressKeyEntity.put("active", new TableInfo.Column("active", "INTEGER", true, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysAddressKeyEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysAddressKeyEntity.add(new TableInfo.ForeignKey("AddressEntity", "CASCADE", "NO ACTION", Arrays.asList("addressId"), Arrays.asList("addressId")));
                HashSet<TableInfo.Index> _indicesAddressKeyEntity = new HashSet<TableInfo.Index>(2);
                _indicesAddressKeyEntity.add(new TableInfo.Index("index_AddressKeyEntity_addressId", false, Arrays.asList("addressId"), Arrays.asList("ASC")));
                _indicesAddressKeyEntity.add(new TableInfo.Index("index_AddressKeyEntity_keyId", false, Arrays.asList("keyId"), Arrays.asList("ASC")));
                TableInfo _infoAddressKeyEntity = new TableInfo("AddressKeyEntity", _columnsAddressKeyEntity, _foreignKeysAddressKeyEntity, _indicesAddressKeyEntity);
                TableInfo _existingAddressKeyEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"AddressKeyEntity");
                if (!_infoAddressKeyEntity.equals((Object)_existingAddressKeyEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "AddressKeyEntity(me.proton.core.user.data.entity.AddressKeyEntity).\n Expected:\n" + _infoAddressKeyEntity + "\n Found:\n" + _existingAddressKeyEntity);
                }
                HashMap<String, TableInfo.Column> _columnsKeySaltEntity = new HashMap<String, TableInfo.Column>(3);
                _columnsKeySaltEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsKeySaltEntity.put("keyId", new TableInfo.Column("keyId", "TEXT", true, 2, null, 1));
                _columnsKeySaltEntity.put("keySalt", new TableInfo.Column("keySalt", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysKeySaltEntity = new HashSet(0);
                HashSet<TableInfo.Index> _indicesKeySaltEntity = new HashSet<TableInfo.Index>(2);
                _indicesKeySaltEntity.add(new TableInfo.Index("index_KeySaltEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                _indicesKeySaltEntity.add(new TableInfo.Index("index_KeySaltEntity_keyId", false, Arrays.asList("keyId"), Arrays.asList("ASC")));
                TableInfo _infoKeySaltEntity = new TableInfo("KeySaltEntity", _columnsKeySaltEntity, _foreignKeysKeySaltEntity, _indicesKeySaltEntity);
                TableInfo _existingKeySaltEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"KeySaltEntity");
                if (!_infoKeySaltEntity.equals((Object)_existingKeySaltEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "KeySaltEntity(me.proton.core.key.data.entity.KeySaltEntity).\n Expected:\n" + _infoKeySaltEntity + "\n Found:\n" + _existingKeySaltEntity);
                }
                HashMap<String, TableInfo.Column> _columnsPublicAddressEntity = new HashMap<String, TableInfo.Column>(5);
                _columnsPublicAddressEntity.put("email", new TableInfo.Column("email", "TEXT", true, 1, null, 1));
                _columnsPublicAddressEntity.put("recipientType", new TableInfo.Column("recipientType", "INTEGER", true, 0, null, 1));
                _columnsPublicAddressEntity.put("mimeType", new TableInfo.Column("mimeType", "TEXT", false, 0, null, 1));
                _columnsPublicAddressEntity.put("signedKeyList_data", new TableInfo.Column("signedKeyList_data", "TEXT", false, 0, null, 1));
                _columnsPublicAddressEntity.put("signedKeyList_signature", new TableInfo.Column("signedKeyList_signature", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysPublicAddressEntity = new HashSet(0);
                HashSet<TableInfo.Index> _indicesPublicAddressEntity = new HashSet<TableInfo.Index>(1);
                _indicesPublicAddressEntity.add(new TableInfo.Index("index_PublicAddressEntity_email", false, Arrays.asList("email"), Arrays.asList("ASC")));
                TableInfo _infoPublicAddressEntity = new TableInfo("PublicAddressEntity", _columnsPublicAddressEntity, _foreignKeysPublicAddressEntity, _indicesPublicAddressEntity);
                TableInfo _existingPublicAddressEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"PublicAddressEntity");
                if (!_infoPublicAddressEntity.equals((Object)_existingPublicAddressEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "PublicAddressEntity(me.proton.core.key.data.entity.PublicAddressEntity).\n Expected:\n" + _infoPublicAddressEntity + "\n Found:\n" + _existingPublicAddressEntity);
                }
                HashMap<String, TableInfo.Column> _columnsPublicAddressKeyEntity = new HashMap<String, TableInfo.Column>(4);
                _columnsPublicAddressKeyEntity.put("email", new TableInfo.Column("email", "TEXT", true, 1, null, 1));
                _columnsPublicAddressKeyEntity.put("flags", new TableInfo.Column("flags", "INTEGER", true, 0, null, 1));
                _columnsPublicAddressKeyEntity.put("publicKey", new TableInfo.Column("publicKey", "TEXT", true, 2, null, 1));
                _columnsPublicAddressKeyEntity.put("isPrimary", new TableInfo.Column("isPrimary", "INTEGER", true, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysPublicAddressKeyEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysPublicAddressKeyEntity.add(new TableInfo.ForeignKey("PublicAddressEntity", "CASCADE", "NO ACTION", Arrays.asList("email"), Arrays.asList("email")));
                HashSet<TableInfo.Index> _indicesPublicAddressKeyEntity = new HashSet<TableInfo.Index>(1);
                _indicesPublicAddressKeyEntity.add(new TableInfo.Index("index_PublicAddressKeyEntity_email", false, Arrays.asList("email"), Arrays.asList("ASC")));
                TableInfo _infoPublicAddressKeyEntity = new TableInfo("PublicAddressKeyEntity", _columnsPublicAddressKeyEntity, _foreignKeysPublicAddressKeyEntity, _indicesPublicAddressKeyEntity);
                TableInfo _existingPublicAddressKeyEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"PublicAddressKeyEntity");
                if (!_infoPublicAddressKeyEntity.equals((Object)_existingPublicAddressKeyEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "PublicAddressKeyEntity(me.proton.core.key.data.entity.PublicAddressKeyEntity).\n Expected:\n" + _infoPublicAddressKeyEntity + "\n Found:\n" + _existingPublicAddressKeyEntity);
                }
                HashMap<String, TableInfo.Column> _columnsHumanVerificationEntity = new HashMap<String, TableInfo.Column>(7);
                _columnsHumanVerificationEntity.put("clientId", new TableInfo.Column("clientId", "TEXT", true, 1, null, 1));
                _columnsHumanVerificationEntity.put("clientIdType", new TableInfo.Column("clientIdType", "TEXT", true, 0, null, 1));
                _columnsHumanVerificationEntity.put("verificationMethods", new TableInfo.Column("verificationMethods", "TEXT", true, 0, null, 1));
                _columnsHumanVerificationEntity.put("captchaVerificationToken", new TableInfo.Column("captchaVerificationToken", "TEXT", false, 0, null, 1));
                _columnsHumanVerificationEntity.put("state", new TableInfo.Column("state", "TEXT", true, 0, null, 1));
                _columnsHumanVerificationEntity.put("humanHeaderTokenType", new TableInfo.Column("humanHeaderTokenType", "TEXT", false, 0, null, 1));
                _columnsHumanVerificationEntity.put("humanHeaderTokenCode", new TableInfo.Column("humanHeaderTokenCode", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysHumanVerificationEntity = new HashSet(0);
                HashSet _indicesHumanVerificationEntity = new HashSet(0);
                TableInfo _infoHumanVerificationEntity = new TableInfo("HumanVerificationEntity", _columnsHumanVerificationEntity, _foreignKeysHumanVerificationEntity, _indicesHumanVerificationEntity);
                TableInfo _existingHumanVerificationEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"HumanVerificationEntity");
                if (!_infoHumanVerificationEntity.equals((Object)_existingHumanVerificationEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "HumanVerificationEntity(me.proton.core.humanverification.data.entity.HumanVerificationEntity).\n Expected:\n" + _infoHumanVerificationEntity + "\n Found:\n" + _existingHumanVerificationEntity);
                }
                HashMap<String, TableInfo.Column> _columnsMailSettingsEntity = new HashMap<String, TableInfo.Column>(27);
                _columnsMailSettingsEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsMailSettingsEntity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0, null, 1));
                _columnsMailSettingsEntity.put("signature", new TableInfo.Column("signature", "TEXT", false, 0, null, 1));
                _columnsMailSettingsEntity.put("autoSaveContacts", new TableInfo.Column("autoSaveContacts", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("composerMode", new TableInfo.Column("composerMode", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("messageButtons", new TableInfo.Column("messageButtons", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("showImages", new TableInfo.Column("showImages", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("showMoved", new TableInfo.Column("showMoved", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("viewMode", new TableInfo.Column("viewMode", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("viewLayout", new TableInfo.Column("viewLayout", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("swipeLeft", new TableInfo.Column("swipeLeft", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("swipeRight", new TableInfo.Column("swipeRight", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("shortcuts", new TableInfo.Column("shortcuts", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("pmSignature", new TableInfo.Column("pmSignature", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("numMessagePerPage", new TableInfo.Column("numMessagePerPage", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("draftMimeType", new TableInfo.Column("draftMimeType", "TEXT", false, 0, null, 1));
                _columnsMailSettingsEntity.put("receiveMimeType", new TableInfo.Column("receiveMimeType", "TEXT", false, 0, null, 1));
                _columnsMailSettingsEntity.put("showMimeType", new TableInfo.Column("showMimeType", "TEXT", false, 0, null, 1));
                _columnsMailSettingsEntity.put("enableFolderColor", new TableInfo.Column("enableFolderColor", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("inheritParentFolderColor", new TableInfo.Column("inheritParentFolderColor", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("rightToLeft", new TableInfo.Column("rightToLeft", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("attachPublicKey", new TableInfo.Column("attachPublicKey", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("sign", new TableInfo.Column("sign", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("pgpScheme", new TableInfo.Column("pgpScheme", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("promptPin", new TableInfo.Column("promptPin", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("stickyLabels", new TableInfo.Column("stickyLabels", "INTEGER", false, 0, null, 1));
                _columnsMailSettingsEntity.put("confirmLink", new TableInfo.Column("confirmLink", "INTEGER", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysMailSettingsEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysMailSettingsEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet _indicesMailSettingsEntity = new HashSet(0);
                TableInfo _infoMailSettingsEntity = new TableInfo("MailSettingsEntity", _columnsMailSettingsEntity, _foreignKeysMailSettingsEntity, _indicesMailSettingsEntity);
                TableInfo _existingMailSettingsEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"MailSettingsEntity");
                if (!_infoMailSettingsEntity.equals((Object)_existingMailSettingsEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "MailSettingsEntity(me.proton.core.mailsettings.data.entity.MailSettingsEntity).\n Expected:\n" + _infoMailSettingsEntity + "\n Found:\n" + _existingMailSettingsEntity);
                }
                HashMap<String, TableInfo.Column> _columnsUserSettingsEntity = new HashMap<String, TableInfo.Column>(28);
                _columnsUserSettingsEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsUserSettingsEntity.put("news", new TableInfo.Column("news", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("locale", new TableInfo.Column("locale", "TEXT", false, 0, null, 1));
                _columnsUserSettingsEntity.put("logAuth", new TableInfo.Column("logAuth", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("invoiceText", new TableInfo.Column("invoiceText", "TEXT", false, 0, null, 1));
                _columnsUserSettingsEntity.put("density", new TableInfo.Column("density", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("theme", new TableInfo.Column("theme", "TEXT", false, 0, null, 1));
                _columnsUserSettingsEntity.put("themeType", new TableInfo.Column("themeType", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("weekStart", new TableInfo.Column("weekStart", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("dateFormat", new TableInfo.Column("dateFormat", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("timeFormat", new TableInfo.Column("timeFormat", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("welcome", new TableInfo.Column("welcome", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("earlyAccess", new TableInfo.Column("earlyAccess", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("email_value", new TableInfo.Column("email_value", "TEXT", false, 0, null, 1));
                _columnsUserSettingsEntity.put("email_status", new TableInfo.Column("email_status", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("email_notify", new TableInfo.Column("email_notify", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("email_reset", new TableInfo.Column("email_reset", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("phone_value", new TableInfo.Column("phone_value", "TEXT", false, 0, null, 1));
                _columnsUserSettingsEntity.put("phone_status", new TableInfo.Column("phone_status", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("phone_notify", new TableInfo.Column("phone_notify", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("phone_reset", new TableInfo.Column("phone_reset", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("password_mode", new TableInfo.Column("password_mode", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("password_expirationTime", new TableInfo.Column("password_expirationTime", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("twoFA_enabled", new TableInfo.Column("twoFA_enabled", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("twoFA_allowed", new TableInfo.Column("twoFA_allowed", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("twoFA_expirationTime", new TableInfo.Column("twoFA_expirationTime", "INTEGER", false, 0, null, 1));
                _columnsUserSettingsEntity.put("twoFA_u2fKeys", new TableInfo.Column("twoFA_u2fKeys", "TEXT", false, 0, null, 1));
                _columnsUserSettingsEntity.put("flags_welcomed", new TableInfo.Column("flags_welcomed", "INTEGER", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysUserSettingsEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysUserSettingsEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet _indicesUserSettingsEntity = new HashSet(0);
                TableInfo _infoUserSettingsEntity = new TableInfo("UserSettingsEntity", _columnsUserSettingsEntity, _foreignKeysUserSettingsEntity, _indicesUserSettingsEntity);
                TableInfo _existingUserSettingsEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"UserSettingsEntity");
                if (!_infoUserSettingsEntity.equals((Object)_existingUserSettingsEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "UserSettingsEntity(me.proton.core.usersettings.data.entity.UserSettingsEntity).\n Expected:\n" + _infoUserSettingsEntity + "\n Found:\n" + _existingUserSettingsEntity);
                }
                HashMap<String, TableInfo.Column> _columnsOrganizationEntity = new HashMap<String, TableInfo.Column>(25);
                _columnsOrganizationEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsOrganizationEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsOrganizationEntity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0, null, 1));
                _columnsOrganizationEntity.put("planName", new TableInfo.Column("planName", "TEXT", false, 0, null, 1));
                _columnsOrganizationEntity.put("vpnPlanName", new TableInfo.Column("vpnPlanName", "TEXT", false, 0, null, 1));
                _columnsOrganizationEntity.put("twoFactorGracePeriod", new TableInfo.Column("twoFactorGracePeriod", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("theme", new TableInfo.Column("theme", "TEXT", false, 0, null, 1));
                _columnsOrganizationEntity.put("email", new TableInfo.Column("email", "TEXT", false, 0, null, 1));
                _columnsOrganizationEntity.put("maxDomains", new TableInfo.Column("maxDomains", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("maxAddresses", new TableInfo.Column("maxAddresses", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("maxSpace", new TableInfo.Column("maxSpace", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("maxMembers", new TableInfo.Column("maxMembers", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("maxVPN", new TableInfo.Column("maxVPN", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("maxCalendars", new TableInfo.Column("maxCalendars", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("features", new TableInfo.Column("features", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("flags", new TableInfo.Column("flags", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("usedDomains", new TableInfo.Column("usedDomains", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("usedAddresses", new TableInfo.Column("usedAddresses", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("usedSpace", new TableInfo.Column("usedSpace", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("assignedSpace", new TableInfo.Column("assignedSpace", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("usedMembers", new TableInfo.Column("usedMembers", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("usedVPN", new TableInfo.Column("usedVPN", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("usedCalendars", new TableInfo.Column("usedCalendars", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("hasKeys", new TableInfo.Column("hasKeys", "INTEGER", false, 0, null, 1));
                _columnsOrganizationEntity.put("toMigrate", new TableInfo.Column("toMigrate", "INTEGER", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysOrganizationEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysOrganizationEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet _indicesOrganizationEntity = new HashSet(0);
                TableInfo _infoOrganizationEntity = new TableInfo("OrganizationEntity", _columnsOrganizationEntity, _foreignKeysOrganizationEntity, _indicesOrganizationEntity);
                TableInfo _existingOrganizationEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"OrganizationEntity");
                if (!_infoOrganizationEntity.equals((Object)_existingOrganizationEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "OrganizationEntity(me.proton.core.usersettings.data.entity.OrganizationEntity).\n Expected:\n" + _infoOrganizationEntity + "\n Found:\n" + _existingOrganizationEntity);
                }
                HashMap<String, TableInfo.Column> _columnsOrganizationKeysEntity = new HashMap<String, TableInfo.Column>(3);
                _columnsOrganizationKeysEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsOrganizationKeysEntity.put("publicKey", new TableInfo.Column("publicKey", "TEXT", true, 0, null, 1));
                _columnsOrganizationKeysEntity.put("privateKey", new TableInfo.Column("privateKey", "TEXT", true, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysOrganizationKeysEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysOrganizationKeysEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet _indicesOrganizationKeysEntity = new HashSet(0);
                TableInfo _infoOrganizationKeysEntity = new TableInfo("OrganizationKeysEntity", _columnsOrganizationKeysEntity, _foreignKeysOrganizationKeysEntity, _indicesOrganizationKeysEntity);
                TableInfo _existingOrganizationKeysEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"OrganizationKeysEntity");
                if (!_infoOrganizationKeysEntity.equals((Object)_existingOrganizationKeysEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "OrganizationKeysEntity(me.proton.core.usersettings.data.entity.OrganizationKeysEntity).\n Expected:\n" + _infoOrganizationKeysEntity + "\n Found:\n" + _existingOrganizationKeysEntity);
                }
                HashMap<String, TableInfo.Column> _columnsContactEntity = new HashMap<String, TableInfo.Column>(3);
                _columnsContactEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, 1));
                _columnsContactEntity.put("contactId", new TableInfo.Column("contactId", "TEXT", true, 1, null, 1));
                _columnsContactEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysContactEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysContactEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet<TableInfo.Index> _indicesContactEntity = new HashSet<TableInfo.Index>(1);
                _indicesContactEntity.add(new TableInfo.Index("index_ContactEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                TableInfo _infoContactEntity = new TableInfo("ContactEntity", _columnsContactEntity, _foreignKeysContactEntity, _indicesContactEntity);
                TableInfo _existingContactEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"ContactEntity");
                if (!_infoContactEntity.equals((Object)_existingContactEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "ContactEntity(me.proton.core.contact.data.local.db.entity.ContactEntity).\n Expected:\n" + _infoContactEntity + "\n Found:\n" + _existingContactEntity);
                }
                HashMap<String, TableInfo.Column> _columnsContactCardEntity = new HashMap<String, TableInfo.Column>(5);
                _columnsContactCardEntity.put("contactId", new TableInfo.Column("contactId", "TEXT", true, 0, null, 1));
                _columnsContactCardEntity.put("type", new TableInfo.Column("type", "INTEGER", true, 0, null, 1));
                _columnsContactCardEntity.put("data", new TableInfo.Column("data", "TEXT", true, 0, null, 1));
                _columnsContactCardEntity.put("signature", new TableInfo.Column("signature", "TEXT", false, 0, null, 1));
                _columnsContactCardEntity.put("cardId", new TableInfo.Column("cardId", "INTEGER", true, 1, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysContactCardEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysContactCardEntity.add(new TableInfo.ForeignKey("ContactEntity", "CASCADE", "NO ACTION", Arrays.asList("contactId"), Arrays.asList("contactId")));
                HashSet<TableInfo.Index> _indicesContactCardEntity = new HashSet<TableInfo.Index>(1);
                _indicesContactCardEntity.add(new TableInfo.Index("index_ContactCardEntity_contactId", false, Arrays.asList("contactId"), Arrays.asList("ASC")));
                TableInfo _infoContactCardEntity = new TableInfo("ContactCardEntity", _columnsContactCardEntity, _foreignKeysContactCardEntity, _indicesContactCardEntity);
                TableInfo _existingContactCardEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"ContactCardEntity");
                if (!_infoContactCardEntity.equals((Object)_existingContactCardEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "ContactCardEntity(me.proton.core.contact.data.local.db.entity.ContactCardEntity).\n Expected:\n" + _infoContactCardEntity + "\n Found:\n" + _existingContactCardEntity);
                }
                HashMap<String, TableInfo.Column> _columnsContactEmailEntity = new HashMap<String, TableInfo.Column>(8);
                _columnsContactEmailEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, 1));
                _columnsContactEmailEntity.put("contactEmailId", new TableInfo.Column("contactEmailId", "TEXT", true, 1, null, 1));
                _columnsContactEmailEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsContactEmailEntity.put("email", new TableInfo.Column("email", "TEXT", true, 0, null, 1));
                _columnsContactEmailEntity.put("defaults", new TableInfo.Column("defaults", "INTEGER", true, 0, null, 1));
                _columnsContactEmailEntity.put("order", new TableInfo.Column("order", "INTEGER", true, 0, null, 1));
                _columnsContactEmailEntity.put("contactId", new TableInfo.Column("contactId", "TEXT", true, 0, null, 1));
                _columnsContactEmailEntity.put("canonicalEmail", new TableInfo.Column("canonicalEmail", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysContactEmailEntity = new HashSet<TableInfo.ForeignKey>(2);
                _foreignKeysContactEmailEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                _foreignKeysContactEmailEntity.add(new TableInfo.ForeignKey("ContactEntity", "CASCADE", "NO ACTION", Arrays.asList("contactId"), Arrays.asList("contactId")));
                HashSet<TableInfo.Index> _indicesContactEmailEntity = new HashSet<TableInfo.Index>(2);
                _indicesContactEmailEntity.add(new TableInfo.Index("index_ContactEmailEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                _indicesContactEmailEntity.add(new TableInfo.Index("index_ContactEmailEntity_contactId", false, Arrays.asList("contactId"), Arrays.asList("ASC")));
                TableInfo _infoContactEmailEntity = new TableInfo("ContactEmailEntity", _columnsContactEmailEntity, _foreignKeysContactEmailEntity, _indicesContactEmailEntity);
                TableInfo _existingContactEmailEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"ContactEmailEntity");
                if (!_infoContactEmailEntity.equals((Object)_existingContactEmailEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "ContactEmailEntity(me.proton.core.contact.data.local.db.entity.ContactEmailEntity).\n Expected:\n" + _infoContactEmailEntity + "\n Found:\n" + _existingContactEmailEntity);
                }
                HashMap<String, TableInfo.Column> _columnsContactEmailLabelEntity = new HashMap<String, TableInfo.Column>(2);
                _columnsContactEmailLabelEntity.put("contactEmailId", new TableInfo.Column("contactEmailId", "TEXT", true, 1, null, 1));
                _columnsContactEmailLabelEntity.put("labelId", new TableInfo.Column("labelId", "TEXT", true, 2, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysContactEmailLabelEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysContactEmailLabelEntity.add(new TableInfo.ForeignKey("ContactEmailEntity", "CASCADE", "NO ACTION", Arrays.asList("contactEmailId"), Arrays.asList("contactEmailId")));
                HashSet _indicesContactEmailLabelEntity = new HashSet(0);
                TableInfo _infoContactEmailLabelEntity = new TableInfo("ContactEmailLabelEntity", _columnsContactEmailLabelEntity, _foreignKeysContactEmailLabelEntity, _indicesContactEmailLabelEntity);
                TableInfo _existingContactEmailLabelEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"ContactEmailLabelEntity");
                if (!_infoContactEmailLabelEntity.equals((Object)_existingContactEmailLabelEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "ContactEmailLabelEntity(me.proton.core.contact.data.local.db.entity.ContactEmailLabelEntity).\n Expected:\n" + _infoContactEmailLabelEntity + "\n Found:\n" + _existingContactEmailLabelEntity);
                }
                HashMap<String, TableInfo.Column> _columnsEventMetadataEntity = new HashMap<String, TableInfo.Column>(11);
                _columnsEventMetadataEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsEventMetadataEntity.put("config", new TableInfo.Column("config", "TEXT", true, 2, null, 1));
                _columnsEventMetadataEntity.put("eventId", new TableInfo.Column("eventId", "TEXT", false, 0, null, 1));
                _columnsEventMetadataEntity.put("nextEventId", new TableInfo.Column("nextEventId", "TEXT", false, 0, null, 1));
                _columnsEventMetadataEntity.put("refresh", new TableInfo.Column("refresh", "TEXT", false, 0, null, 1));
                _columnsEventMetadataEntity.put("more", new TableInfo.Column("more", "INTEGER", false, 0, null, 1));
                _columnsEventMetadataEntity.put("response", new TableInfo.Column("response", "TEXT", false, 0, null, 1));
                _columnsEventMetadataEntity.put("retry", new TableInfo.Column("retry", "INTEGER", true, 0, null, 1));
                _columnsEventMetadataEntity.put("state", new TableInfo.Column("state", "TEXT", true, 0, null, 1));
                _columnsEventMetadataEntity.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", true, 0, null, 1));
                _columnsEventMetadataEntity.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysEventMetadataEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysEventMetadataEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet<TableInfo.Index> _indicesEventMetadataEntity = new HashSet<TableInfo.Index>(3);
                _indicesEventMetadataEntity.add(new TableInfo.Index("index_EventMetadataEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                _indicesEventMetadataEntity.add(new TableInfo.Index("index_EventMetadataEntity_config", false, Arrays.asList("config"), Arrays.asList("ASC")));
                _indicesEventMetadataEntity.add(new TableInfo.Index("index_EventMetadataEntity_createdAt", false, Arrays.asList("createdAt"), Arrays.asList("ASC")));
                TableInfo _infoEventMetadataEntity = new TableInfo("EventMetadataEntity", _columnsEventMetadataEntity, _foreignKeysEventMetadataEntity, _indicesEventMetadataEntity);
                TableInfo _existingEventMetadataEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"EventMetadataEntity");
                if (!_infoEventMetadataEntity.equals((Object)_existingEventMetadataEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "EventMetadataEntity(me.proton.core.eventmanager.data.entity.EventMetadataEntity).\n Expected:\n" + _infoEventMetadataEntity + "\n Found:\n" + _existingEventMetadataEntity);
                }
                HashMap<String, TableInfo.Column> _columnsLabelEntity = new HashMap<String, TableInfo.Column>(11);
                _columnsLabelEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsLabelEntity.put("labelId", new TableInfo.Column("labelId", "TEXT", true, 2, null, 1));
                _columnsLabelEntity.put("parentId", new TableInfo.Column("parentId", "TEXT", false, 0, null, 1));
                _columnsLabelEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsLabelEntity.put("type", new TableInfo.Column("type", "INTEGER", true, 0, null, 1));
                _columnsLabelEntity.put("path", new TableInfo.Column("path", "TEXT", true, 0, null, 1));
                _columnsLabelEntity.put("color", new TableInfo.Column("color", "TEXT", true, 0, null, 1));
                _columnsLabelEntity.put("order", new TableInfo.Column("order", "INTEGER", true, 0, null, 1));
                _columnsLabelEntity.put("isNotified", new TableInfo.Column("isNotified", "INTEGER", false, 0, null, 1));
                _columnsLabelEntity.put("isExpanded", new TableInfo.Column("isExpanded", "INTEGER", false, 0, null, 1));
                _columnsLabelEntity.put("isSticky", new TableInfo.Column("isSticky", "INTEGER", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysLabelEntity = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysLabelEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet<TableInfo.Index> _indicesLabelEntity = new HashSet<TableInfo.Index>(5);
                _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_labelId", false, Arrays.asList("labelId"), Arrays.asList("ASC")));
                _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_parentId", false, Arrays.asList("parentId"), Arrays.asList("ASC")));
                _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_name", false, Arrays.asList("name"), Arrays.asList("ASC")));
                _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_type", false, Arrays.asList("type"), Arrays.asList("ASC")));
                TableInfo _infoLabelEntity = new TableInfo("LabelEntity", _columnsLabelEntity, _foreignKeysLabelEntity, _indicesLabelEntity);
                TableInfo _existingLabelEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"LabelEntity");
                if (!_infoLabelEntity.equals((Object)_existingLabelEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "LabelEntity(me.proton.core.label.data.local.LabelEntity).\n Expected:\n" + _infoLabelEntity + "\n Found:\n" + _existingLabelEntity);
                }
                HashMap<String, TableInfo.Column> _columnsFeatureFlagEntity = new HashMap<String, TableInfo.Column>(5);
                _columnsFeatureFlagEntity.put("userId", new TableInfo.Column("userId", "TEXT", false, 0, null, 1));
                _columnsFeatureFlagEntity.put("featureId", new TableInfo.Column("featureId", "TEXT", true, 1, null, 1));
                _columnsFeatureFlagEntity.put("isGlobal", new TableInfo.Column("isGlobal", "INTEGER", true, 0, null, 1));
                _columnsFeatureFlagEntity.put("defaultValue", new TableInfo.Column("defaultValue", "INTEGER", true, 0, null, 1));
                _columnsFeatureFlagEntity.put("value", new TableInfo.Column("value", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysFeatureFlagEntity = new HashSet(0);
                HashSet<TableInfo.Index> _indicesFeatureFlagEntity = new HashSet<TableInfo.Index>(2);
                _indicesFeatureFlagEntity.add(new TableInfo.Index("index_FeatureFlagEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
                _indicesFeatureFlagEntity.add(new TableInfo.Index("index_FeatureFlagEntity_featureId", false, Arrays.asList("featureId"), Arrays.asList("ASC")));
                TableInfo _infoFeatureFlagEntity = new TableInfo("FeatureFlagEntity", _columnsFeatureFlagEntity, _foreignKeysFeatureFlagEntity, _indicesFeatureFlagEntity);
                TableInfo _existingFeatureFlagEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"FeatureFlagEntity");
                if (!_infoFeatureFlagEntity.equals((Object)_existingFeatureFlagEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "FeatureFlagEntity(me.proton.core.featureflag.data.entity.FeatureFlagEntity).\n Expected:\n" + _infoFeatureFlagEntity + "\n Found:\n" + _existingFeatureFlagEntity);
                }
                HashMap<String, TableInfo.Column> _columnsChallengeFrameEntity = new HashMap<String, TableInfo.Column>(7);
                _columnsChallengeFrameEntity.put("challengeFrame", new TableInfo.Column("challengeFrame", "TEXT", true, 1, null, 1));
                _columnsChallengeFrameEntity.put("flow", new TableInfo.Column("flow", "TEXT", true, 0, null, 1));
                _columnsChallengeFrameEntity.put("focusTime", new TableInfo.Column("focusTime", "INTEGER", true, 0, null, 1));
                _columnsChallengeFrameEntity.put("clicks", new TableInfo.Column("clicks", "INTEGER", true, 0, null, 1));
                _columnsChallengeFrameEntity.put("copy", new TableInfo.Column("copy", "TEXT", true, 0, null, 1));
                _columnsChallengeFrameEntity.put("paste", new TableInfo.Column("paste", "TEXT", true, 0, null, 1));
                _columnsChallengeFrameEntity.put("keys", new TableInfo.Column("keys", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysChallengeFrameEntity = new HashSet(0);
                HashSet _indicesChallengeFrameEntity = new HashSet(0);
                TableInfo _infoChallengeFrameEntity = new TableInfo("ChallengeFrameEntity", _columnsChallengeFrameEntity, _foreignKeysChallengeFrameEntity, _indicesChallengeFrameEntity);
                TableInfo _existingChallengeFrameEntity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"ChallengeFrameEntity");
                if (!_infoChallengeFrameEntity.equals((Object)_existingChallengeFrameEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "ChallengeFrameEntity(me.proton.core.challenge.data.entity.ChallengeFrameEntity).\n Expected:\n" + _infoChallengeFrameEntity + "\n Found:\n" + _existingChallengeFrameEntity);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "7575a152cffc6a797c6e72d5cfb725f3", "414ffff2b8d558c31ff568ddae4516d2");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"AccountEntity", "AccountMetadataEntity", "SessionEntity", "SessionDetailsEntity", "UserEntity", "UserKeyEntity", "AddressEntity", "AddressKeyEntity", "KeySaltEntity", "PublicAddressEntity", "PublicAddressKeyEntity", "HumanVerificationEntity", "MailSettingsEntity", "UserSettingsEntity", "OrganizationEntity", "OrganizationKeysEntity", "ContactEntity", "ContactCardEntity", "ContactEmailEntity", "ContactEmailLabelEntity", "EventMetadataEntity", "LabelEntity", "FeatureFlagEntity", "ChallengeFrameEntity"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `AccountEntity`");
            _db.execSQL("DELETE FROM `AccountMetadataEntity`");
            _db.execSQL("DELETE FROM `SessionEntity`");
            _db.execSQL("DELETE FROM `SessionDetailsEntity`");
            _db.execSQL("DELETE FROM `UserEntity`");
            _db.execSQL("DELETE FROM `UserKeyEntity`");
            _db.execSQL("DELETE FROM `AddressEntity`");
            _db.execSQL("DELETE FROM `AddressKeyEntity`");
            _db.execSQL("DELETE FROM `KeySaltEntity`");
            _db.execSQL("DELETE FROM `PublicAddressEntity`");
            _db.execSQL("DELETE FROM `PublicAddressKeyEntity`");
            _db.execSQL("DELETE FROM `HumanVerificationEntity`");
            _db.execSQL("DELETE FROM `MailSettingsEntity`");
            _db.execSQL("DELETE FROM `UserSettingsEntity`");
            _db.execSQL("DELETE FROM `OrganizationEntity`");
            _db.execSQL("DELETE FROM `OrganizationKeysEntity`");
            _db.execSQL("DELETE FROM `ContactEntity`");
            _db.execSQL("DELETE FROM `ContactCardEntity`");
            _db.execSQL("DELETE FROM `ContactEmailEntity`");
            _db.execSQL("DELETE FROM `ContactEmailLabelEntity`");
            _db.execSQL("DELETE FROM `EventMetadataEntity`");
            _db.execSQL("DELETE FROM `LabelEntity`");
            _db.execSQL("DELETE FROM `FeatureFlagEntity`");
            _db.execSQL("DELETE FROM `ChallengeFrameEntity`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(AccountDao.class, AccountDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(SessionDao.class, SessionDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(AccountMetadataDao.class, AccountMetadataDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(SessionDetailsDao.class, SessionDetailsDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(UserKeyDao.class, UserKeyDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(UserDao.class, UserDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(UserWithKeysDao.class, UserWithKeysDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(AddressKeyDao.class, AddressKeyDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(AddressDao.class, AddressDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(AddressWithKeysDao.class, AddressWithKeysDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(KeySaltDao.class, KeySaltDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(HumanVerificationDetailsDao.class, HumanVerificationDetailsDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(PublicAddressDao.class, PublicAddressDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(PublicAddressKeyDao.class, PublicAddressKeyDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(PublicAddressWithKeysDao.class, PublicAddressWithKeysDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(MailSettingsDao.class, MailSettingsDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(UserSettingsDao.class, UserSettingsDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(OrganizationDao.class, OrganizationDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(OrganizationKeysDao.class, OrganizationKeysDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ContactDao.class, ContactDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ContactCardDao.class, ContactCardDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ContactEmailDao.class, ContactEmailDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ContactEmailLabelDao.class, ContactEmailLabelDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(EventMetadataDao.class, EventMetadataDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(LabelDao.class, LabelDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(FeatureFlagDao.class, FeatureFlagDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ChallengeFramesDao.class, ChallengeFramesDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountDao accountDao() {
        if (this._accountDao != null) {
            return this._accountDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._accountDao == null) {
                this._accountDao = new AccountDao_Impl((RoomDatabase)this);
            }
            return this._accountDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionDao sessionDao() {
        if (this._sessionDao != null) {
            return this._sessionDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._sessionDao == null) {
                this._sessionDao = new SessionDao_Impl((RoomDatabase)this);
            }
            return this._sessionDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountMetadataDao accountMetadataDao() {
        if (this._accountMetadataDao != null) {
            return this._accountMetadataDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._accountMetadataDao == null) {
                this._accountMetadataDao = new AccountMetadataDao_Impl((RoomDatabase)this);
            }
            return this._accountMetadataDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionDetailsDao sessionDetailsDao() {
        if (this._sessionDetailsDao != null) {
            return this._sessionDetailsDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._sessionDetailsDao == null) {
                this._sessionDetailsDao = new SessionDetailsDao_Impl((RoomDatabase)this);
            }
            return this._sessionDetailsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserKeyDao userKeyDao() {
        if (this._userKeyDao != null) {
            return this._userKeyDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._userKeyDao == null) {
                this._userKeyDao = new UserKeyDao_Impl((RoomDatabase)this);
            }
            return this._userKeyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDao userDao() {
        if (this._userDao != null) {
            return this._userDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._userDao == null) {
                this._userDao = new UserDao_Impl((RoomDatabase)this);
            }
            return this._userDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserWithKeysDao userWithKeysDao() {
        if (this._userWithKeysDao != null) {
            return this._userWithKeysDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._userWithKeysDao == null) {
                this._userWithKeysDao = new UserWithKeysDao_Impl((RoomDatabase)this);
            }
            return this._userWithKeysDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressKeyDao addressKeyDao() {
        if (this._addressKeyDao != null) {
            return this._addressKeyDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._addressKeyDao == null) {
                this._addressKeyDao = new AddressKeyDao_Impl((RoomDatabase)this);
            }
            return this._addressKeyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressDao addressDao() {
        if (this._addressDao != null) {
            return this._addressDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._addressDao == null) {
                this._addressDao = new AddressDao_Impl((RoomDatabase)this);
            }
            return this._addressDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressWithKeysDao addressWithKeysDao() {
        if (this._addressWithKeysDao != null) {
            return this._addressWithKeysDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._addressWithKeysDao == null) {
                this._addressWithKeysDao = new AddressWithKeysDao_Impl((RoomDatabase)this);
            }
            return this._addressWithKeysDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeySaltDao keySaltDao() {
        if (this._keySaltDao != null) {
            return this._keySaltDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._keySaltDao == null) {
                this._keySaltDao = new KeySaltDao_Impl((RoomDatabase)this);
            }
            return this._keySaltDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HumanVerificationDetailsDao humanVerificationDetailsDao() {
        if (this._humanVerificationDetailsDao != null) {
            return this._humanVerificationDetailsDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._humanVerificationDetailsDao == null) {
                this._humanVerificationDetailsDao = new HumanVerificationDetailsDao_Impl((RoomDatabase)this);
            }
            return this._humanVerificationDetailsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicAddressDao publicAddressDao() {
        if (this._publicAddressDao != null) {
            return this._publicAddressDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._publicAddressDao == null) {
                this._publicAddressDao = new PublicAddressDao_Impl((RoomDatabase)this);
            }
            return this._publicAddressDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicAddressKeyDao publicAddressKeyDao() {
        if (this._publicAddressKeyDao != null) {
            return this._publicAddressKeyDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._publicAddressKeyDao == null) {
                this._publicAddressKeyDao = new PublicAddressKeyDao_Impl((RoomDatabase)this);
            }
            return this._publicAddressKeyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicAddressWithKeysDao publicAddressWithKeysDao() {
        if (this._publicAddressWithKeysDao != null) {
            return this._publicAddressWithKeysDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._publicAddressWithKeysDao == null) {
                this._publicAddressWithKeysDao = new PublicAddressWithKeysDao_Impl((RoomDatabase)this);
            }
            return this._publicAddressWithKeysDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailSettingsDao mailSettingsDao() {
        if (this._mailSettingsDao != null) {
            return this._mailSettingsDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._mailSettingsDao == null) {
                this._mailSettingsDao = new MailSettingsDao_Impl((RoomDatabase)this);
            }
            return this._mailSettingsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSettingsDao userSettingsDao() {
        if (this._userSettingsDao != null) {
            return this._userSettingsDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._userSettingsDao == null) {
                this._userSettingsDao = new UserSettingsDao_Impl((RoomDatabase)this);
            }
            return this._userSettingsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationDao organizationDao() {
        if (this._organizationDao != null) {
            return this._organizationDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._organizationDao == null) {
                this._organizationDao = new OrganizationDao_Impl((RoomDatabase)this);
            }
            return this._organizationDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationKeysDao organizationKeysDao() {
        if (this._organizationKeysDao != null) {
            return this._organizationKeysDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._organizationKeysDao == null) {
                this._organizationKeysDao = new OrganizationKeysDao_Impl((RoomDatabase)this);
            }
            return this._organizationKeysDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactDao contactDao() {
        if (this._contactDao != null) {
            return this._contactDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._contactDao == null) {
                this._contactDao = new ContactDao_Impl((RoomDatabase)this);
            }
            return this._contactDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactCardDao contactCardDao() {
        if (this._contactCardDao != null) {
            return this._contactCardDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._contactCardDao == null) {
                this._contactCardDao = new ContactCardDao_Impl((RoomDatabase)this);
            }
            return this._contactCardDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactEmailDao contactEmailDao() {
        if (this._contactEmailDao != null) {
            return this._contactEmailDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._contactEmailDao == null) {
                this._contactEmailDao = new ContactEmailDao_Impl((RoomDatabase)this);
            }
            return this._contactEmailDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactEmailLabelDao contactEmailLabelDao() {
        if (this._contactEmailLabelDao != null) {
            return this._contactEmailLabelDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._contactEmailLabelDao == null) {
                this._contactEmailLabelDao = new ContactEmailLabelDao_Impl((RoomDatabase)this);
            }
            return this._contactEmailLabelDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventMetadataDao eventMetadataDao() {
        if (this._eventMetadataDao != null) {
            return this._eventMetadataDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._eventMetadataDao == null) {
                this._eventMetadataDao = new EventMetadataDao_Impl((RoomDatabase)this);
            }
            return this._eventMetadataDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelDao labelDao() {
        if (this._labelDao != null) {
            return this._labelDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._labelDao == null) {
                this._labelDao = new LabelDao_Impl((RoomDatabase)this);
            }
            return this._labelDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureFlagDao featureFlagDao() {
        if (this._featureFlagDao != null) {
            return this._featureFlagDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._featureFlagDao == null) {
                this._featureFlagDao = new FeatureFlagDao_Impl((RoomDatabase)this);
            }
            return this._featureFlagDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChallengeFramesDao challengeFramesDao() {
        if (this._challengeFramesDao != null) {
            return this._challengeFramesDao;
        }
        AccountManagerDatabase_Impl accountManagerDatabase_Impl = this;
        synchronized (accountManagerDatabase_Impl) {
            if (this._challengeFramesDao == null) {
                this._challengeFramesDao = new ChallengeFramesDao_Impl((RoomDatabase)this);
            }
            return this._challengeFramesDao;
        }
    }
}

