/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.contact.data.local.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.dao.ContactEmailDao;
import me.proton.core.contact.data.local.db.entity.ContactEmailEntity;
import me.proton.core.contact.data.local.db.entity.relation.ContactEmailWithLabelsRelation;
import me.proton.core.contact.domain.entity.ContactEmailId;
import me.proton.core.contact.domain.entity.ContactId;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;

public final class ContactEmailDao_Impl
extends ContactEmailDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContactEmailEntity> __insertionAdapterOfContactEmailEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final ContactConverters __contactConverters = new ContactConverters();
    private final EntityDeletionOrUpdateAdapter<ContactEmailEntity> __deletionAdapterOfContactEmailEntity;
    private final EntityDeletionOrUpdateAdapter<ContactEmailEntity> __updateAdapterOfContactEmailEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllContactsEmails;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllContactsEmails_1;

    public ContactEmailDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContactEmailEntity = new EntityInsertionAdapter<ContactEmailEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ContactEmailEntity` (`userId`,`contactEmailId`,`name`,`email`,`defaults`,`order`,`contactId`,`canonicalEmail`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEmailEntity value) {
                String _tmp = ContactEmailDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = ContactEmailDao_Impl.this.__contactConverters.fromContactEmailIdToString(value.getContactEmailId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getEmail());
                }
                stmt.bindLong(5, (long)value.getDefaults());
                stmt.bindLong(6, (long)value.getOrder());
                String _tmp_2 = ContactEmailDao_Impl.this.__contactConverters.fromContactIdToString(value.getContactId());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                if (value.getCanonicalEmail() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCanonicalEmail());
                }
            }
        };
        this.__deletionAdapterOfContactEmailEntity = new EntityDeletionOrUpdateAdapter<ContactEmailEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `ContactEmailEntity` WHERE `contactEmailId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEmailEntity value) {
                String _tmp = ContactEmailDao_Impl.this.__contactConverters.fromContactEmailIdToString(value.getContactEmailId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfContactEmailEntity = new EntityDeletionOrUpdateAdapter<ContactEmailEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `ContactEmailEntity` SET `userId` = ?,`contactEmailId` = ?,`name` = ?,`email` = ?,`defaults` = ?,`order` = ?,`contactId` = ?,`canonicalEmail` = ? WHERE `contactEmailId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEmailEntity value) {
                String _tmp = ContactEmailDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = ContactEmailDao_Impl.this.__contactConverters.fromContactEmailIdToString(value.getContactEmailId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getEmail());
                }
                stmt.bindLong(5, (long)value.getDefaults());
                stmt.bindLong(6, (long)value.getOrder());
                String _tmp_2 = ContactEmailDao_Impl.this.__contactConverters.fromContactIdToString(value.getContactId());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                if (value.getCanonicalEmail() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCanonicalEmail());
                }
                String _tmp_3 = ContactEmailDao_Impl.this.__contactConverters.fromContactEmailIdToString(value.getContactEmailId());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
            }
        };
        this.__preparedStmtOfDeleteAllContactsEmails = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM ContactEmailEntity WHERE userId = ?";
                return "DELETE FROM ContactEmailEntity WHERE userId = ?";
            }
        };
        this.__preparedStmtOfDeleteAllContactsEmails_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM ContactEmailEntity";
                return "DELETE FROM ContactEmailEntity";
            }
        };
    }

    public Object insertOrIgnore(final ContactEmailEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    ContactEmailDao_Impl.this.__insertionAdapterOfContactEmailEntity.insert((Object[])entities);
                    ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final ContactEmailEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    ContactEmailDao_Impl.this.__deletionAdapterOfContactEmailEntity.handleMultiple((Object[])entities);
                    ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final ContactEmailEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += ContactEmailDao_Impl.this.__updateAdapterOfContactEmailEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final ContactEmailEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactEmailDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteContactsEmails(final ContactEmailId[] contactEmailIds, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactEmailDao_Impl.super.deleteContactsEmails(contactEmailIds, __cont);
            }
        }, $completion);
    }

    public Object deleteAllContactsEmails(final ContactId[] contactIds, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactEmailDao_Impl.super.deleteAllContactsEmails(contactIds, __cont);
            }
        }, $completion);
    }

    public Object deleteAllContactsEmails(final UserId userId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ContactEmailDao_Impl.this.__preparedStmtOfDeleteAllContactsEmails.acquire();
                int _argIndex = 1;
                String _tmp = ContactEmailDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                    ContactEmailDao_Impl.this.__preparedStmtOfDeleteAllContactsEmails.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAllContactsEmails(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ContactEmailDao_Impl.this.__preparedStmtOfDeleteAllContactsEmails_1.acquire();
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                    ContactEmailDao_Impl.this.__preparedStmtOfDeleteAllContactsEmails_1.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<List<ContactEmailWithLabelsRelation>> observeAllContactsEmails(UserId userId) {
        String _sql = "SELECT * FROM ContactEmailEntity WHERE userId = ? ORDER BY `order`, name";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContactEmailEntity WHERE userId = ? ORDER BY `order`, name", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"ContactEmailLabelEntity", "ContactEmailEntity"}, (Callable)new Callable<List<ContactEmailWithLabelsRelation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ContactEmailWithLabelsRelation> call() throws Exception {
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<ContactEmailWithLabelsRelation> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)ContactEmailDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfContactEmailId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactEmailId");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                        int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                        int _cursorIndexOfDefaults = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaults");
                        int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                        int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactId");
                        int _cursorIndexOfCanonicalEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canonicalEmail");
                        HashMap _collectionLabelIds = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfContactEmailId);
                            ArrayList _tmpLabelIdsCollection = (ArrayList)_collectionLabelIds.get(_tmpKey);
                            if (_tmpLabelIdsCollection != null) continue;
                            _tmpLabelIdsCollection = new ArrayList();
                            _collectionLabelIds.put(_tmpKey, _tmpLabelIdsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        ContactEmailDao_Impl.this.__fetchRelationshipContactEmailLabelEntityAsjavaLangString(_collectionLabelIds);
                        ArrayList<ContactEmailWithLabelsRelation> _result = new ArrayList<ContactEmailWithLabelsRelation>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            ContactEmailEntity _tmpContactEmail;
                            if (!(_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactEmailId) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDefaults) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfCanonicalEmail))) {
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                UserId _tmpUserId = ContactEmailDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfContactEmailId) ? null : _cursor.getString(_cursorIndexOfContactEmailId);
                                ContactEmailId _tmpContactEmailId = ContactEmailDao_Impl.this.__contactConverters.fromStringToContactEmailId(_tmp_2);
                                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                                int _tmpDefaults = _cursor.getInt(_cursorIndexOfDefaults);
                                int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                                String _tmp_3 = _cursor.isNull(_cursorIndexOfContactId) ? null : _cursor.getString(_cursorIndexOfContactId);
                                ContactId _tmpContactId = ContactEmailDao_Impl.this.__contactConverters.fromStringToContactId(_tmp_3);
                                String _tmpCanonicalEmail = _cursor.isNull(_cursorIndexOfCanonicalEmail) ? null : _cursor.getString(_cursorIndexOfCanonicalEmail);
                                _tmpContactEmail = new ContactEmailEntity(_tmpUserId, _tmpContactEmailId, _tmpName, _tmpEmail, _tmpDefaults, _tmpOrder, _tmpContactId, _tmpCanonicalEmail);
                            } else {
                                _tmpContactEmail = null;
                            }
                            ArrayList _tmpLabelIdsCollection_1 = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfContactEmailId);
                            _tmpLabelIdsCollection_1 = (ArrayList)_collectionLabelIds.get(_tmpKey_1);
                            if (_tmpLabelIdsCollection_1 == null) {
                                _tmpLabelIdsCollection_1 = new ArrayList();
                            }
                            ContactEmailWithLabelsRelation _item = new ContactEmailWithLabelsRelation(_tmpContactEmail, _tmpLabelIdsCollection_1);
                            _result.add(_item);
                        }
                        ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Flow<List<ContactEmailWithLabelsRelation>> observeAllContactsEmails(ContactId contactId) {
        String _sql = "SELECT * FROM ContactEmailEntity WHERE contactId = ? ORDER BY `order`, name";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContactEmailEntity WHERE contactId = ? ORDER BY `order`, name", (int)1);
        int _argIndex = 1;
        String _tmp = this.__contactConverters.fromContactIdToString(contactId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"ContactEmailLabelEntity", "ContactEmailEntity"}, (Callable)new Callable<List<ContactEmailWithLabelsRelation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ContactEmailWithLabelsRelation> call() throws Exception {
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<ContactEmailWithLabelsRelation> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)ContactEmailDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfContactEmailId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactEmailId");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                        int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                        int _cursorIndexOfDefaults = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaults");
                        int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                        int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactId");
                        int _cursorIndexOfCanonicalEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canonicalEmail");
                        HashMap _collectionLabelIds = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfContactEmailId);
                            ArrayList _tmpLabelIdsCollection = (ArrayList)_collectionLabelIds.get(_tmpKey);
                            if (_tmpLabelIdsCollection != null) continue;
                            _tmpLabelIdsCollection = new ArrayList();
                            _collectionLabelIds.put(_tmpKey, _tmpLabelIdsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        ContactEmailDao_Impl.this.__fetchRelationshipContactEmailLabelEntityAsjavaLangString(_collectionLabelIds);
                        ArrayList<ContactEmailWithLabelsRelation> _result = new ArrayList<ContactEmailWithLabelsRelation>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            ContactEmailEntity _tmpContactEmail;
                            if (!(_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactEmailId) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDefaults) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfCanonicalEmail))) {
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                UserId _tmpUserId = ContactEmailDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfContactEmailId) ? null : _cursor.getString(_cursorIndexOfContactEmailId);
                                ContactEmailId _tmpContactEmailId = ContactEmailDao_Impl.this.__contactConverters.fromStringToContactEmailId(_tmp_2);
                                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                                int _tmpDefaults = _cursor.getInt(_cursorIndexOfDefaults);
                                int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                                String _tmp_3 = _cursor.isNull(_cursorIndexOfContactId) ? null : _cursor.getString(_cursorIndexOfContactId);
                                ContactId _tmpContactId = ContactEmailDao_Impl.this.__contactConverters.fromStringToContactId(_tmp_3);
                                String _tmpCanonicalEmail = _cursor.isNull(_cursorIndexOfCanonicalEmail) ? null : _cursor.getString(_cursorIndexOfCanonicalEmail);
                                _tmpContactEmail = new ContactEmailEntity(_tmpUserId, _tmpContactEmailId, _tmpName, _tmpEmail, _tmpDefaults, _tmpOrder, _tmpContactId, _tmpCanonicalEmail);
                            } else {
                                _tmpContactEmail = null;
                            }
                            ArrayList _tmpLabelIdsCollection_1 = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfContactEmailId);
                            _tmpLabelIdsCollection_1 = (ArrayList)_collectionLabelIds.get(_tmpKey_1);
                            if (_tmpLabelIdsCollection_1 == null) {
                                _tmpLabelIdsCollection_1 = new ArrayList();
                            }
                            ContactEmailWithLabelsRelation _item = new ContactEmailWithLabelsRelation(_tmpContactEmail, _tmpLabelIdsCollection_1);
                            _result.add(_item);
                        }
                        ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    protected Object deleteContactsEmailsSingleBatch(final ContactEmailId[] contactEmailIds, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM ContactEmailEntity WHERE contactId IN (");
                int _inputSize = contactEmailIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ContactEmailDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (ContactEmailId _item : contactEmailIds) {
                    String _tmp = ContactEmailDao_Impl.this.__contactConverters.fromContactEmailIdToString(_item);
                    if (_tmp == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp);
                    }
                    ++_argIndex;
                }
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    protected Object deleteAllContactsEmailsSingleBatch(final ContactId[] contactIds, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM ContactEmailEntity WHERE contactId IN (");
                int _inputSize = contactIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ContactEmailDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (ContactId _item : contactIds) {
                    String _tmp = ContactEmailDao_Impl.this.__contactConverters.fromContactIdToString(_item);
                    if (_tmp == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp);
                    }
                    ++_argIndex;
                }
                ContactEmailDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactEmailDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipContactEmailLabelEntityAsjavaLangString(HashMap<String, ArrayList<String>> _map) {
        Set<String> __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            HashMap<String, ArrayList<String>> _tmpInnerMap = new HashMap<String, ArrayList<String>>(999);
            int _tmpIndex = 0;
            for (String _mapKey : __mapKeySet) {
                _tmpInnerMap.put(_mapKey, _map.get(_mapKey));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipContactEmailLabelEntityAsjavaLangString(_tmpInnerMap);
                _tmpInnerMap = new HashMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipContactEmailLabelEntityAsjavaLangString(_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `labelId`,`contactEmailId` FROM `ContactEmailLabelEntity` WHERE `contactEmailId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"contactEmailId");
            if (_itemKeyIndex == -1) {
                return;
            }
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList<String> _tmpRelation = _map.get(_tmpKey);
                if (_tmpRelation == null) continue;
                String _item_1 = _cursor.isNull(0) ? null : _cursor.getString(0);
                _tmpRelation.add(_item_1);
            }
        }
    }
}

