/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.featureflag.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.featureflag.data.db.dao.FeatureFlagDao;
import me.proton.core.featureflag.data.entity.FeatureFlagEntity;

public final class FeatureFlagDao_Impl
extends FeatureFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<FeatureFlagEntity> __insertionAdapterOfFeatureFlagEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EntityDeletionOrUpdateAdapter<FeatureFlagEntity> __deletionAdapterOfFeatureFlagEntity;
    private final EntityDeletionOrUpdateAdapter<FeatureFlagEntity> __updateAdapterOfFeatureFlagEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll$feature_flag_data_release;

    public FeatureFlagDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfFeatureFlagEntity = new EntityInsertionAdapter<FeatureFlagEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `FeatureFlagEntity` (`userId`,`featureId`,`isGlobal`,`defaultValue`,`value`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, FeatureFlagEntity value) {
                String _tmp = FeatureFlagDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getFeatureId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFeatureId());
                }
                int _tmp_1 = value.isGlobal() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp_1);
                int _tmp_2 = value.getDefaultValue() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_2);
                int _tmp_3 = value.getValue() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_3);
            }
        };
        this.__deletionAdapterOfFeatureFlagEntity = new EntityDeletionOrUpdateAdapter<FeatureFlagEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `FeatureFlagEntity` WHERE `featureId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FeatureFlagEntity value) {
                if (value.getFeatureId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFeatureId());
                }
            }
        };
        this.__updateAdapterOfFeatureFlagEntity = new EntityDeletionOrUpdateAdapter<FeatureFlagEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `FeatureFlagEntity` SET `userId` = ?,`featureId` = ?,`isGlobal` = ?,`defaultValue` = ?,`value` = ? WHERE `featureId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FeatureFlagEntity value) {
                String _tmp = FeatureFlagDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getFeatureId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFeatureId());
                }
                int _tmp_1 = value.isGlobal() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp_1);
                int _tmp_2 = value.getDefaultValue() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_2);
                int _tmp_3 = value.getValue() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_3);
                if (value.getFeatureId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getFeatureId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll$feature_flag_data_release = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM FeatureFlagEntity WHERE userId = ?";
                return "DELETE FROM FeatureFlagEntity WHERE userId = ?";
            }
        };
    }

    public Object insertOrIgnore(final FeatureFlagEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                FeatureFlagDao_Impl.this.__db.beginTransaction();
                try {
                    FeatureFlagDao_Impl.this.__insertionAdapterOfFeatureFlagEntity.insert((Object[])entities);
                    FeatureFlagDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    FeatureFlagDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final FeatureFlagEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                FeatureFlagDao_Impl.this.__db.beginTransaction();
                try {
                    FeatureFlagDao_Impl.this.__deletionAdapterOfFeatureFlagEntity.handleMultiple((Object[])entities);
                    FeatureFlagDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    FeatureFlagDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final FeatureFlagEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                FeatureFlagDao_Impl.this.__db.beginTransaction();
                try {
                    FeatureFlagDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += FeatureFlagDao_Impl.this.__updateAdapterOfFeatureFlagEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    FeatureFlagDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final FeatureFlagEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return FeatureFlagDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteAll$feature_flag_data_release(final UserId userId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = FeatureFlagDao_Impl.this.__preparedStmtOfDeleteAll$feature_flag_data_release.acquire();
                int _argIndex = 1;
                String _tmp = FeatureFlagDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                FeatureFlagDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    FeatureFlagDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    FeatureFlagDao_Impl.this.__db.endTransaction();
                    FeatureFlagDao_Impl.this.__preparedStmtOfDeleteAll$feature_flag_data_release.release(_stmt);
                }
            }
        }, arg1);
    }

    public Flow<FeatureFlagEntity> observeByUserId$feature_flag_data_release(UserId userId, String feature) {
        String _sql = "SELECT * FROM FeatureFlagEntity WHERE featureId = ? AND userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM FeatureFlagEntity WHERE featureId = ? AND userId = ?", (int)2);
        int _argIndex = 1;
        if (feature == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feature);
        }
        _argIndex = 2;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"FeatureFlagEntity"}, (Callable)new Callable<FeatureFlagEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FeatureFlagEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FeatureFlagDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    FeatureFlagEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFeatureId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"featureId");
                    int _cursorIndexOfIsGlobal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isGlobal");
                    int _cursorIndexOfDefaultValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaultValue");
                    int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"value");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = FeatureFlagDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpFeatureId = _cursor.isNull(_cursorIndexOfFeatureId) ? null : _cursor.getString(_cursorIndexOfFeatureId);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsGlobal);
                        boolean _tmpIsGlobal = _tmp_2 != 0;
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfDefaultValue);
                        boolean _tmpDefaultValue = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfValue);
                        boolean _tmpValue = _tmp_4 != 0;
                        _result = new FeatureFlagEntity(_tmpUserId, _tmpFeatureId, _tmpIsGlobal, _tmpDefaultValue, _tmpValue);
                    } else {
                        _result = null;
                    }
                    FeatureFlagEntity featureFlagEntity = _result;
                    return featureFlagEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Flow<FeatureFlagEntity> observeGlobal$feature_flag_data_release(String feature) {
        String _sql = "SELECT * FROM FeatureFlagEntity WHERE featureId = ? AND userId IS NULL";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM FeatureFlagEntity WHERE featureId = ? AND userId IS NULL", (int)1);
        int _argIndex = 1;
        if (feature == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feature);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"FeatureFlagEntity"}, (Callable)new Callable<FeatureFlagEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FeatureFlagEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FeatureFlagDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    FeatureFlagEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFeatureId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"featureId");
                    int _cursorIndexOfIsGlobal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isGlobal");
                    int _cursorIndexOfDefaultValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaultValue");
                    int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"value");
                    if (_cursor.moveToFirst()) {
                        String _tmp = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = FeatureFlagDao_Impl.this.__commonConverters.fromStringToUserId(_tmp);
                        String _tmpFeatureId = _cursor.isNull(_cursorIndexOfFeatureId) ? null : _cursor.getString(_cursorIndexOfFeatureId);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsGlobal);
                        boolean _tmpIsGlobal = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfDefaultValue);
                        boolean _tmpDefaultValue = _tmp_2 != 0;
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfValue);
                        boolean _tmpValue = _tmp_3 != 0;
                        _result = new FeatureFlagEntity(_tmpUserId, _tmpFeatureId, _tmpIsGlobal, _tmpDefaultValue, _tmpValue);
                    } else {
                        _result = null;
                    }
                    FeatureFlagEntity featureFlagEntity = _result;
                    return featureFlagEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object get$feature_flag_data_release(UserId userId, String feature, Continuation<? super FeatureFlagEntity> arg2) {
        String _sql = "SELECT * FROM FeatureFlagEntity WHERE featureId = ? AND userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM FeatureFlagEntity WHERE featureId = ? AND userId = ?", (int)2);
        int _argIndex = 1;
        if (feature == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feature);
        }
        _argIndex = 2;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<FeatureFlagEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FeatureFlagEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)FeatureFlagDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    FeatureFlagEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFeatureId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"featureId");
                    int _cursorIndexOfIsGlobal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isGlobal");
                    int _cursorIndexOfDefaultValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaultValue");
                    int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"value");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = FeatureFlagDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpFeatureId = _cursor.isNull(_cursorIndexOfFeatureId) ? null : _cursor.getString(_cursorIndexOfFeatureId);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsGlobal);
                        boolean _tmpIsGlobal = _tmp_2 != 0;
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfDefaultValue);
                        boolean _tmpDefaultValue = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfValue);
                        boolean _tmpValue = _tmp_4 != 0;
                        _result = new FeatureFlagEntity(_tmpUserId, _tmpFeatureId, _tmpIsGlobal, _tmpDefaultValue, _tmpValue);
                    } else {
                        _result = null;
                    }
                    FeatureFlagEntity featureFlagEntity = _result;
                    return featureFlagEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg2);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

