/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.key.data.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.data.db.KeySaltDao;
import me.proton.core.key.data.entity.KeySaltEntity;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;

public final class KeySaltDao_Impl
extends KeySaltDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<KeySaltEntity> __insertionAdapterOfKeySaltEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final UserConverters __userConverters = new UserConverters();
    private final EntityDeletionOrUpdateAdapter<KeySaltEntity> __deletionAdapterOfKeySaltEntity;
    private final EntityDeletionOrUpdateAdapter<KeySaltEntity> __updateAdapterOfKeySaltEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByUserId;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public KeySaltDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfKeySaltEntity = new EntityInsertionAdapter<KeySaltEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `KeySaltEntity` (`userId`,`keyId`,`keySalt`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, KeySaltEntity value) {
                String _tmp = KeySaltDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = KeySaltDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getKeySalt() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getKeySalt());
                }
            }
        };
        this.__deletionAdapterOfKeySaltEntity = new EntityDeletionOrUpdateAdapter<KeySaltEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `KeySaltEntity` WHERE `userId` = ? AND `keyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, KeySaltEntity value) {
                String _tmp = KeySaltDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = KeySaltDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
            }
        };
        this.__updateAdapterOfKeySaltEntity = new EntityDeletionOrUpdateAdapter<KeySaltEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `KeySaltEntity` SET `userId` = ?,`keyId` = ?,`keySalt` = ? WHERE `userId` = ? AND `keyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, KeySaltEntity value) {
                String _tmp = KeySaltDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = KeySaltDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getKeySalt() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getKeySalt());
                }
                String _tmp_2 = KeySaltDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = KeySaltDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
            }
        };
        this.__preparedStmtOfDeleteByUserId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM KeySaltEntity WHERE userId = ?";
                return "DELETE FROM KeySaltEntity WHERE userId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM KeySaltEntity";
                return "DELETE FROM KeySaltEntity";
            }
        };
    }

    public Object insertOrIgnore(final KeySaltEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                KeySaltDao_Impl.this.__db.beginTransaction();
                try {
                    KeySaltDao_Impl.this.__insertionAdapterOfKeySaltEntity.insert((Object[])entities);
                    KeySaltDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    KeySaltDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final KeySaltEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                KeySaltDao_Impl.this.__db.beginTransaction();
                try {
                    KeySaltDao_Impl.this.__deletionAdapterOfKeySaltEntity.handleMultiple((Object[])entities);
                    KeySaltDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    KeySaltDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final KeySaltEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                KeySaltDao_Impl.this.__db.beginTransaction();
                try {
                    KeySaltDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += KeySaltDao_Impl.this.__updateAdapterOfKeySaltEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    KeySaltDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final KeySaltEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return KeySaltDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteByUserId(final UserId userId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = KeySaltDao_Impl.this.__preparedStmtOfDeleteByUserId.acquire();
                int _argIndex = 1;
                String _tmp = KeySaltDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                KeySaltDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    KeySaltDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    KeySaltDao_Impl.this.__db.endTransaction();
                    KeySaltDao_Impl.this.__preparedStmtOfDeleteByUserId.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAll(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = KeySaltDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                KeySaltDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    KeySaltDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    KeySaltDao_Impl.this.__db.endTransaction();
                    KeySaltDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<List<KeySaltEntity>> findAllByUserId(UserId userId) {
        String _sql = "SELECT * FROM KeySaltEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM KeySaltEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"KeySaltEntity"}, (Callable)new Callable<List<KeySaltEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<KeySaltEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)KeySaltDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"keyId");
                    int _cursorIndexOfKeySalt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"keySalt");
                    ArrayList<KeySaltEntity> _result = new ArrayList<KeySaltEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = KeySaltDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfKeyId) ? null : _cursor.getString(_cursorIndexOfKeyId);
                        KeyId _tmpKeyId = KeySaltDao_Impl.this.__userConverters.fromStringToKeyId(_tmp_2);
                        String _tmpKeySalt = _cursor.isNull(_cursorIndexOfKeySalt) ? null : _cursor.getString(_cursorIndexOfKeySalt);
                        KeySaltEntity _item = new KeySaltEntity(_tmpUserId, _tmpKeyId, _tmpKeySalt);
                        _result.add(_item);
                    }
                    ArrayList<KeySaltEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

