/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.account.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.account.data.db.SessionDao;
import me.proton.core.account.data.entity.SessionEntity;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.Product;
import me.proton.core.domain.entity.UserId;
import me.proton.core.network.domain.session.SessionId;

public final class SessionDao_Impl
extends SessionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SessionEntity> __insertionAdapterOfSessionEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EntityDeletionOrUpdateAdapter<SessionEntity> __deletionAdapterOfSessionEntity;
    private final EntityDeletionOrUpdateAdapter<SessionEntity> __updateAdapterOfSessionEntity;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfUpdateScopes;
    private final SharedSQLiteStatement __preparedStmtOfUpdateToken;

    public SessionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSessionEntity = new EntityInsertionAdapter<SessionEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `SessionEntity` (`userId`,`sessionId`,`accessToken`,`refreshToken`,`scopes`,`product`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SessionEntity value) {
                String _tmp = SessionDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = SessionDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getAccessToken() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAccessToken());
                }
                if (value.getRefreshToken() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getRefreshToken());
                }
                String _tmp_2 = SessionDao_Impl.this.__commonConverters.fromListOfStringToString(value.getScopes());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = SessionDao_Impl.this.__commonConverters.fromProductToString(value.getProduct());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfSessionEntity = new EntityDeletionOrUpdateAdapter<SessionEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `SessionEntity` WHERE `sessionId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SessionEntity value) {
                String _tmp = SessionDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfSessionEntity = new EntityDeletionOrUpdateAdapter<SessionEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `SessionEntity` SET `userId` = ?,`sessionId` = ?,`accessToken` = ?,`refreshToken` = ?,`scopes` = ?,`product` = ? WHERE `sessionId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SessionEntity value) {
                String _tmp = SessionDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = SessionDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getAccessToken() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAccessToken());
                }
                if (value.getRefreshToken() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getRefreshToken());
                }
                String _tmp_2 = SessionDao_Impl.this.__commonConverters.fromListOfStringToString(value.getScopes());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = SessionDao_Impl.this.__commonConverters.fromProductToString(value.getProduct());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                String _tmp_4 = SessionDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM SessionEntity WHERE sessionId = ?";
                return "DELETE FROM SessionEntity WHERE sessionId = ?";
            }
        };
        this.__preparedStmtOfUpdateScopes = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE SessionEntity SET scopes = ? WHERE sessionId = ?";
                return "UPDATE SessionEntity SET scopes = ? WHERE sessionId = ?";
            }
        };
        this.__preparedStmtOfUpdateToken = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE SessionEntity SET accessToken = ?, refreshToken = ? WHERE sessionId = ?";
                return "UPDATE SessionEntity SET accessToken = ?, refreshToken = ? WHERE sessionId = ?";
            }
        };
    }

    public Object insertOrIgnore(final SessionEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SessionDao_Impl.this.__db.beginTransaction();
                try {
                    SessionDao_Impl.this.__insertionAdapterOfSessionEntity.insert((Object[])entities);
                    SessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final SessionEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SessionDao_Impl.this.__db.beginTransaction();
                try {
                    SessionDao_Impl.this.__deletionAdapterOfSessionEntity.handleMultiple((Object[])entities);
                    SessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final SessionEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                SessionDao_Impl.this.__db.beginTransaction();
                try {
                    SessionDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += SessionDao_Impl.this.__updateAdapterOfSessionEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    SessionDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final SessionEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return SessionDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object delete(final SessionId sessionId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = SessionDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                String _tmp = SessionDao_Impl.this.__commonConverters.fromSessionIdToString(sessionId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                SessionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    SessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDao_Impl.this.__db.endTransaction();
                    SessionDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object updateScopes(final SessionId sessionId, final String scopes, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = SessionDao_Impl.this.__preparedStmtOfUpdateScopes.acquire();
                int _argIndex = 1;
                if (scopes == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, scopes);
                }
                _argIndex = 2;
                String _tmp = SessionDao_Impl.this.__commonConverters.fromSessionIdToString(sessionId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                SessionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    SessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDao_Impl.this.__db.endTransaction();
                    SessionDao_Impl.this.__preparedStmtOfUpdateScopes.release(_stmt);
                }
            }
        }, arg2);
    }

    public Object updateToken(final SessionId sessionId, final String accessToken, final String refreshToken, Continuation<? super Unit> arg3) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = SessionDao_Impl.this.__preparedStmtOfUpdateToken.acquire();
                int _argIndex = 1;
                if (accessToken == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, accessToken);
                }
                _argIndex = 2;
                if (refreshToken == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, refreshToken);
                }
                _argIndex = 3;
                String _tmp = SessionDao_Impl.this.__commonConverters.fromSessionIdToString(sessionId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                SessionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    SessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDao_Impl.this.__db.endTransaction();
                    SessionDao_Impl.this.__preparedStmtOfUpdateToken.release(_stmt);
                }
            }
        }, arg3);
    }

    public Flow<List<SessionEntity>> findAll(Product product) {
        String _sql = "SELECT * FROM SessionEntity WHERE product = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SessionEntity WHERE product = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromProductToString(product);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"SessionEntity"}, (Callable)new Callable<List<SessionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SessionEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfScopes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scopes");
                    int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"product");
                    ArrayList<SessionEntity> _result = new ArrayList<SessionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = SessionDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = SessionDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_2);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScopes) ? null : _cursor.getString(_cursorIndexOfScopes);
                        List _tmpScopes = SessionDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfProduct) ? null : _cursor.getString(_cursorIndexOfProduct);
                        Product _tmpProduct = SessionDao_Impl.this.__commonConverters.fromStringToProduct(_tmp_4);
                        SessionEntity _item = new SessionEntity(_tmpUserId, _tmpSessionId, _tmpAccessToken, _tmpRefreshToken, _tmpScopes, _tmpProduct);
                        _result.add(_item);
                    }
                    ArrayList<SessionEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Flow<SessionEntity> findBySessionId(SessionId sessionId) {
        String _sql = "SELECT * FROM SessionEntity WHERE sessionId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SessionEntity WHERE sessionId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"SessionEntity"}, (Callable)new Callable<SessionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SessionEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    SessionEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfScopes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scopes");
                    int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"product");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = SessionDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = SessionDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_2);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScopes) ? null : _cursor.getString(_cursorIndexOfScopes);
                        List _tmpScopes = SessionDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfProduct) ? null : _cursor.getString(_cursorIndexOfProduct);
                        Product _tmpProduct = SessionDao_Impl.this.__commonConverters.fromStringToProduct(_tmp_4);
                        _result = new SessionEntity(_tmpUserId, _tmpSessionId, _tmpAccessToken, _tmpRefreshToken, _tmpScopes, _tmpProduct);
                    } else {
                        _result = null;
                    }
                    SessionEntity sessionEntity = _result;
                    return sessionEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object get(SessionId sessionId, Continuation<? super SessionEntity> arg1) {
        String _sql = "SELECT * FROM SessionEntity WHERE sessionId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SessionEntity WHERE sessionId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<SessionEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SessionEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    SessionEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfScopes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scopes");
                    int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"product");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = SessionDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = SessionDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_2);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfScopes) ? null : _cursor.getString(_cursorIndexOfScopes);
                        List _tmpScopes = SessionDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfProduct) ? null : _cursor.getString(_cursorIndexOfProduct);
                        Product _tmpProduct = SessionDao_Impl.this.__commonConverters.fromStringToProduct(_tmp_4);
                        _result = new SessionEntity(_tmpUserId, _tmpSessionId, _tmpAccessToken, _tmpRefreshToken, _tmpScopes, _tmpProduct);
                    } else {
                        _result = null;
                    }
                    SessionEntity sessionEntity = _result;
                    return sessionEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public Object getSessionId(UserId userId, Continuation<? super SessionId> arg1) {
        String _sql = "SELECT sessionId FROM SessionEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT sessionId FROM SessionEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<SessionId>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SessionId call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    SessionId _result;
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(0) ? null : _cursor.getString(0);
                        _result = SessionDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_1);
                    } else {
                        _result = null;
                    }
                    SessionId sessionId = _result;
                    return sessionId;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

