/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.contact.data.local.db.dao;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.dao.ContactDao;
import me.proton.core.contact.data.local.db.entity.ContactCardEntity;
import me.proton.core.contact.data.local.db.entity.ContactEmailEntity;
import me.proton.core.contact.data.local.db.entity.ContactEntity;
import me.proton.core.contact.data.local.db.entity.relation.ContactEmailWithLabelsRelation;
import me.proton.core.contact.data.local.db.entity.relation.ContactWithMailsAndCardsRelation;
import me.proton.core.contact.data.local.db.entity.relation.ContactWithMailsRelation;
import me.proton.core.contact.domain.entity.ContactEmailId;
import me.proton.core.contact.domain.entity.ContactId;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;

public final class ContactDao_Impl
extends ContactDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContactEntity> __insertionAdapterOfContactEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final ContactConverters __contactConverters = new ContactConverters();
    private final EntityDeletionOrUpdateAdapter<ContactEntity> __deletionAdapterOfContactEntity;
    private final EntityDeletionOrUpdateAdapter<ContactEntity> __updateAdapterOfContactEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllContacts;

    public ContactDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContactEntity = new EntityInsertionAdapter<ContactEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ContactEntity` (`userId`,`contactId`,`name`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEntity value) {
                String _tmp = ContactDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = ContactDao_Impl.this.__contactConverters.fromContactIdToString(value.getContactId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
            }
        };
        this.__deletionAdapterOfContactEntity = new EntityDeletionOrUpdateAdapter<ContactEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `ContactEntity` WHERE `contactId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEntity value) {
                String _tmp = ContactDao_Impl.this.__contactConverters.fromContactIdToString(value.getContactId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfContactEntity = new EntityDeletionOrUpdateAdapter<ContactEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `ContactEntity` SET `userId` = ?,`contactId` = ?,`name` = ? WHERE `contactId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEntity value) {
                String _tmp = ContactDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = ContactDao_Impl.this.__contactConverters.fromContactIdToString(value.getContactId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                String _tmp_2 = ContactDao_Impl.this.__contactConverters.fromContactIdToString(value.getContactId());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
            }
        };
        this.__preparedStmtOfDeleteAllContacts = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM ContactEntity";
                return "DELETE FROM ContactEntity";
            }
        };
    }

    public Object insertOrIgnore(final ContactEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ContactDao_Impl.this.__db.beginTransaction();
                try {
                    ContactDao_Impl.this.__insertionAdapterOfContactEntity.insert((Object[])entities);
                    ContactDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final ContactEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ContactDao_Impl.this.__db.beginTransaction();
                try {
                    ContactDao_Impl.this.__deletionAdapterOfContactEntity.handleMultiple((Object[])entities);
                    ContactDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final ContactEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                ContactDao_Impl.this.__db.beginTransaction();
                try {
                    ContactDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += ContactDao_Impl.this.__updateAdapterOfContactEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    ContactDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final ContactEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteContacts(final ContactId[] contactIds, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactDao_Impl.super.deleteContacts(contactIds, __cont);
            }
        }, $completion);
    }

    public Object deleteAllContacts(final UserId[] userIds, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactDao_Impl.super.deleteAllContacts(userIds, __cont);
            }
        }, $completion);
    }

    public Object deleteAllContacts(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ContactDao_Impl.this.__preparedStmtOfDeleteAllContacts.acquire();
                ContactDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactDao_Impl.this.__db.endTransaction();
                    ContactDao_Impl.this.__preparedStmtOfDeleteAllContacts.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<ContactWithMailsAndCardsRelation> observeContact(ContactId contactId) {
        String _sql = "SELECT * FROM ContactEntity WHERE contactId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContactEntity WHERE contactId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__contactConverters.fromContactIdToString(contactId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"ContactCardEntity", "ContactEmailLabelEntity", "ContactEmailEntity", "ContactEntity"}, (Callable)new Callable<ContactWithMailsAndCardsRelation>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ContactWithMailsAndCardsRelation call() throws Exception {
                ContactDao_Impl.this.__db.beginTransaction();
                try {
                    ContactWithMailsAndCardsRelation contactWithMailsAndCardsRelation;
                    Cursor _cursor = DBUtil.query((RoomDatabase)ContactDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        ContactWithMailsAndCardsRelation _result;
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactId");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                        ArrayMap _collectionCards = new ArrayMap();
                        ArrayMap _collectionEmails = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey_1;
                            ArrayList _tmpEmailsCollection;
                            String _tmpKey = _cursor.getString(_cursorIndexOfContactId);
                            ArrayList _tmpCardsCollection = (ArrayList)_collectionCards.get((Object)_tmpKey);
                            if (_tmpCardsCollection == null) {
                                _tmpCardsCollection = new ArrayList();
                                _collectionCards.put((Object)_tmpKey, _tmpCardsCollection);
                            }
                            if ((_tmpEmailsCollection = (ArrayList)_collectionEmails.get((Object)(_tmpKey_1 = _cursor.getString(_cursorIndexOfContactId)))) != null) continue;
                            _tmpEmailsCollection = new ArrayList();
                            _collectionEmails.put((Object)_tmpKey_1, _tmpEmailsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        ContactDao_Impl.this.__fetchRelationshipContactCardEntityAsmeProtonCoreContactDataLocalDbEntityContactCardEntity((ArrayMap<String, ArrayList<ContactCardEntity>>)_collectionCards);
                        ContactDao_Impl.this.__fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation((ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>>)_collectionEmails);
                        if (_cursor.moveToFirst()) {
                            ContactEntity _tmpContact;
                            if (!(_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfName))) {
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                UserId _tmpUserId = ContactDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfContactId) ? null : _cursor.getString(_cursorIndexOfContactId);
                                ContactId _tmpContactId = ContactDao_Impl.this.__contactConverters.fromStringToContactId(_tmp_2);
                                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                _tmpContact = new ContactEntity(_tmpUserId, _tmpContactId, _tmpName);
                            } else {
                                _tmpContact = null;
                            }
                            ArrayList _tmpCardsCollection_1 = null;
                            String _tmpKey_2 = _cursor.getString(_cursorIndexOfContactId);
                            _tmpCardsCollection_1 = (ArrayList)_collectionCards.get((Object)_tmpKey_2);
                            if (_tmpCardsCollection_1 == null) {
                                _tmpCardsCollection_1 = new ArrayList();
                            }
                            ArrayList _tmpEmailsCollection_1 = null;
                            String _tmpKey_3 = _cursor.getString(_cursorIndexOfContactId);
                            _tmpEmailsCollection_1 = (ArrayList)_collectionEmails.get((Object)_tmpKey_3);
                            if (_tmpEmailsCollection_1 == null) {
                                _tmpEmailsCollection_1 = new ArrayList();
                            }
                            _result = new ContactWithMailsAndCardsRelation(_tmpContact, _tmpCardsCollection_1, _tmpEmailsCollection_1);
                        } else {
                            _result = null;
                        }
                        ContactDao_Impl.this.__db.setTransactionSuccessful();
                        contactWithMailsAndCardsRelation = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return contactWithMailsAndCardsRelation;
                }
                finally {
                    ContactDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Flow<List<ContactWithMailsRelation>> observeAllContacts(UserId userId) {
        String _sql = "SELECT * FROM ContactEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContactEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"ContactEmailLabelEntity", "ContactEmailEntity", "ContactEntity"}, (Callable)new Callable<List<ContactWithMailsRelation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ContactWithMailsRelation> call() throws Exception {
                ContactDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<ContactWithMailsRelation> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)ContactDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactId");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                        ArrayMap _collectionEmails = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfContactId);
                            ArrayList _tmpEmailsCollection = (ArrayList)_collectionEmails.get((Object)_tmpKey);
                            if (_tmpEmailsCollection != null) continue;
                            _tmpEmailsCollection = new ArrayList();
                            _collectionEmails.put((Object)_tmpKey, _tmpEmailsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        ContactDao_Impl.this.__fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation((ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>>)_collectionEmails);
                        ArrayList<ContactWithMailsRelation> _result = new ArrayList<ContactWithMailsRelation>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            ContactEntity _tmpContact;
                            if (!(_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfName))) {
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                UserId _tmpUserId = ContactDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfContactId) ? null : _cursor.getString(_cursorIndexOfContactId);
                                ContactId _tmpContactId = ContactDao_Impl.this.__contactConverters.fromStringToContactId(_tmp_2);
                                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                _tmpContact = new ContactEntity(_tmpUserId, _tmpContactId, _tmpName);
                            } else {
                                _tmpContact = null;
                            }
                            ArrayList _tmpEmailsCollection_1 = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfContactId);
                            _tmpEmailsCollection_1 = (ArrayList)_collectionEmails.get((Object)_tmpKey_1);
                            if (_tmpEmailsCollection_1 == null) {
                                _tmpEmailsCollection_1 = new ArrayList();
                            }
                            ContactWithMailsRelation _item = new ContactWithMailsRelation(_tmpContact, _tmpEmailsCollection_1);
                            _result.add(_item);
                        }
                        ContactDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    ContactDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    protected Object deleteContactsSingleBatch(final ContactId[] contactIds, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM ContactEntity WHERE contactId IN (");
                int _inputSize = contactIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ContactDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (ContactId _item : contactIds) {
                    String _tmp = ContactDao_Impl.this.__contactConverters.fromContactIdToString(_item);
                    if (_tmp == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp);
                    }
                    ++_argIndex;
                }
                ContactDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    protected Object deleteAllContactsSingleBatch(final UserId[] userIds, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM ContactEntity WHERE userId IN (");
                int _inputSize = userIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ContactDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (UserId _item : userIds) {
                    String _tmp = ContactDao_Impl.this.__commonConverters.fromUserIdToString(_item);
                    if (_tmp == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp);
                    }
                    ++_argIndex;
                }
                ContactDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipContactCardEntityAsmeProtonCoreContactDataLocalDbEntityContactCardEntity(ArrayMap<String, ArrayList<ContactCardEntity>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put((Object)((String)_map.keyAt(_mapIndex)), (Object)((ArrayList)_map.valueAt(_mapIndex)));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipContactCardEntityAsmeProtonCoreContactDataLocalDbEntityContactCardEntity((ArrayMap<String, ArrayList<ContactCardEntity>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipContactCardEntityAsmeProtonCoreContactDataLocalDbEntityContactCardEntity((ArrayMap<String, ArrayList<ContactCardEntity>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `contactId`,`type`,`data`,`signature`,`cardId` FROM `ContactCardEntity` WHERE `contactId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"contactId");
            if (_itemKeyIndex == -1) {
                return;
            }
            boolean _cursorIndexOfContactId = false;
            boolean _cursorIndexOfType = true;
            int _cursorIndexOfData = 2;
            int _cursorIndexOfSignature = 3;
            int _cursorIndexOfCardId = 4;
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList _tmpRelation = (ArrayList)_map.get((Object)_tmpKey);
                if (_tmpRelation == null) continue;
                String _tmp = _cursor.isNull(0) ? null : _cursor.getString(0);
                ContactId _tmpContactId = this.__contactConverters.fromStringToContactId(_tmp);
                int _tmpType = _cursor.getInt(1);
                String _tmpData = _cursor.isNull(2) ? null : _cursor.getString(2);
                String _tmpSignature = _cursor.isNull(3) ? null : _cursor.getString(3);
                ContactCardEntity _item_1 = new ContactCardEntity(_tmpContactId, _tmpType, _tmpData, _tmpSignature);
                long _tmpCardId = _cursor.getLong(4);
                _item_1.setCardId(_tmpCardId);
                _tmpRelation.add(_item_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipContactEmailLabelEntityAsjavaLangString(ArrayMap<String, ArrayList<String>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put((Object)((String)_map.keyAt(_mapIndex)), (Object)((ArrayList)_map.valueAt(_mapIndex)));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipContactEmailLabelEntityAsjavaLangString((ArrayMap<String, ArrayList<String>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipContactEmailLabelEntityAsjavaLangString((ArrayMap<String, ArrayList<String>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `labelId`,`contactEmailId` FROM `ContactEmailLabelEntity` WHERE `contactEmailId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"contactEmailId");
            if (_itemKeyIndex == -1) {
                return;
            }
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList _tmpRelation = (ArrayList)_map.get((Object)_tmpKey);
                if (_tmpRelation == null) continue;
                String _item_1 = _cursor.isNull(0) ? null : _cursor.getString(0);
                _tmpRelation.add(_item_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation(ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put((Object)((String)_map.keyAt(_mapIndex)), (Object)((ArrayList)_map.valueAt(_mapIndex)));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation((ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation((ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `userId`,`contactEmailId`,`name`,`email`,`defaults`,`order`,`contactId`,`canonicalEmail` FROM `ContactEmailEntity` WHERE `contactId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)true, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"contactId");
            if (_itemKeyIndex == -1) {
                return;
            }
            boolean _cursorIndexOfUserId = false;
            boolean _cursorIndexOfContactEmailId = true;
            int _cursorIndexOfName = 2;
            int _cursorIndexOfEmail = 3;
            int _cursorIndexOfDefaults = 4;
            int _cursorIndexOfOrder = 5;
            int _cursorIndexOfContactId = 6;
            int _cursorIndexOfCanonicalEmail = 7;
            ArrayMap _collectionLabelIds = new ArrayMap();
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(1);
                ArrayList _tmpLabelIdsCollection = (ArrayList)_collectionLabelIds.get((Object)_tmpKey);
                if (_tmpLabelIdsCollection != null) continue;
                _tmpLabelIdsCollection = new ArrayList();
                _collectionLabelIds.put((Object)_tmpKey, _tmpLabelIdsCollection);
            }
            _cursor.moveToPosition(-1);
            this.__fetchRelationshipContactEmailLabelEntityAsjavaLangString((ArrayMap<String, ArrayList<String>>)_collectionLabelIds);
            while (_cursor.moveToNext()) {
                ContactEmailEntity _tmpContactEmail;
                String _tmpKey_1 = _cursor.getString(_itemKeyIndex);
                ArrayList _tmpRelation = (ArrayList)_map.get((Object)_tmpKey_1);
                if (_tmpRelation == null) continue;
                if (!(_cursor.isNull(0) && _cursor.isNull(1) && _cursor.isNull(2) && _cursor.isNull(3) && _cursor.isNull(4) && _cursor.isNull(5) && _cursor.isNull(6) && _cursor.isNull(7))) {
                    String _tmp = _cursor.isNull(0) ? null : _cursor.getString(0);
                    UserId _tmpUserId = this.__commonConverters.fromStringToUserId(_tmp);
                    String _tmp_1 = _cursor.isNull(1) ? null : _cursor.getString(1);
                    ContactEmailId _tmpContactEmailId = this.__contactConverters.fromStringToContactEmailId(_tmp_1);
                    String _tmpName = _cursor.isNull(2) ? null : _cursor.getString(2);
                    String _tmpEmail = _cursor.isNull(3) ? null : _cursor.getString(3);
                    int _tmpDefaults = _cursor.getInt(4);
                    int _tmpOrder = _cursor.getInt(5);
                    String _tmp_2 = _cursor.isNull(6) ? null : _cursor.getString(6);
                    ContactId _tmpContactId = this.__contactConverters.fromStringToContactId(_tmp_2);
                    String _tmpCanonicalEmail = _cursor.isNull(7) ? null : _cursor.getString(7);
                    _tmpContactEmail = new ContactEmailEntity(_tmpUserId, _tmpContactEmailId, _tmpName, _tmpEmail, _tmpDefaults, _tmpOrder, _tmpContactId, _tmpCanonicalEmail);
                } else {
                    _tmpContactEmail = null;
                }
                ArrayList _tmpLabelIdsCollection_1 = null;
                String _tmpKey_2 = _cursor.getString(1);
                _tmpLabelIdsCollection_1 = (ArrayList)_collectionLabelIds.get((Object)_tmpKey_2);
                if (_tmpLabelIdsCollection_1 == null) {
                    _tmpLabelIdsCollection_1 = new ArrayList();
                }
                ContactEmailWithLabelsRelation _item_1 = new ContactEmailWithLabelsRelation(_tmpContactEmail, _tmpLabelIdsCollection_1);
                _tmpRelation.add(_item_1);
            }
        }
    }
}

