/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.push.data.local.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.push.data.local.db.PushConverters;
import me.proton.core.push.data.local.db.PushDao;
import me.proton.core.push.data.local.db.PushEntity;
import me.proton.core.push.domain.entity.PushId;

public final class PushDao_Impl
extends PushDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PushEntity> __insertionAdapterOfPushEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final PushConverters __pushConverters = new PushConverters();
    private final EntityDeletionOrUpdateAdapter<PushEntity> __deletionAdapterOfPushEntity;
    private final EntityDeletionOrUpdateAdapter<PushEntity> __updateAdapterOfPushEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllPushes;
    private final SharedSQLiteStatement __preparedStmtOfDeletePushes;

    public PushDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPushEntity = new EntityInsertionAdapter<PushEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `PushEntity` (`userId`,`pushId`,`objectId`,`type`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PushEntity value) {
                String _tmp = PushDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = PushDao_Impl.this.__pushConverters.fromPushIdToString(value.getPushId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getObjectId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getObjectId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getType());
                }
            }
        };
        this.__deletionAdapterOfPushEntity = new EntityDeletionOrUpdateAdapter<PushEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `PushEntity` WHERE `userId` = ? AND `pushId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PushEntity value) {
                String _tmp = PushDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = PushDao_Impl.this.__pushConverters.fromPushIdToString(value.getPushId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
            }
        };
        this.__updateAdapterOfPushEntity = new EntityDeletionOrUpdateAdapter<PushEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `PushEntity` SET `userId` = ?,`pushId` = ?,`objectId` = ?,`type` = ? WHERE `userId` = ? AND `pushId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PushEntity value) {
                String _tmp = PushDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = PushDao_Impl.this.__pushConverters.fromPushIdToString(value.getPushId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getObjectId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getObjectId());
                }
                if (value.getType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getType());
                }
                String _tmp_2 = PushDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = PushDao_Impl.this.__pushConverters.fromPushIdToString(value.getPushId());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
            }
        };
        this.__preparedStmtOfDeleteAllPushes = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM PushEntity";
                return "DELETE FROM PushEntity";
            }
        };
        this.__preparedStmtOfDeletePushes = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM PushEntity WHERE userId = ? AND type = ?";
                return "DELETE FROM PushEntity WHERE userId = ? AND type = ?";
            }
        };
    }

    public Object insertOrIgnore(final PushEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                PushDao_Impl.this.__db.beginTransaction();
                try {
                    PushDao_Impl.this.__insertionAdapterOfPushEntity.insert((Object[])entities);
                    PushDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PushDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final PushEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                PushDao_Impl.this.__db.beginTransaction();
                try {
                    PushDao_Impl.this.__deletionAdapterOfPushEntity.handleMultiple((Object[])entities);
                    PushDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PushDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final PushEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                PushDao_Impl.this.__db.beginTransaction();
                try {
                    PushDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += PushDao_Impl.this.__updateAdapterOfPushEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    PushDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final PushEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return PushDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteAllPushes(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PushDao_Impl.this.__preparedStmtOfDeleteAllPushes.acquire();
                PushDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PushDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PushDao_Impl.this.__db.endTransaction();
                    PushDao_Impl.this.__preparedStmtOfDeleteAllPushes.release(_stmt);
                }
            }
        }, arg0);
    }

    public Object deletePushes(final UserId userId, final String pushType, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PushDao_Impl.this.__preparedStmtOfDeletePushes.acquire();
                int _argIndex = 1;
                String _tmp = PushDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (pushType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, pushType);
                }
                PushDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PushDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PushDao_Impl.this.__db.endTransaction();
                    PushDao_Impl.this.__preparedStmtOfDeletePushes.release(_stmt);
                }
            }
        }, arg2);
    }

    public Flow<List<PushEntity>> observeAllPushes(UserId userId, String type) {
        String _sql = "SELECT * FROM PushEntity WHERE userId = ? AND type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PushEntity WHERE userId = ? AND type = ?", (int)2);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"PushEntity"}, (Callable)new Callable<List<PushEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PushEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PushDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfPushId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pushId");
                    int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"objectId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    ArrayList<PushEntity> _result = new ArrayList<PushEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = PushDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfPushId) ? null : _cursor.getString(_cursorIndexOfPushId);
                        PushId _tmpPushId = PushDao_Impl.this.__pushConverters.fromStringToPushId(_tmp_2);
                        String _tmpObjectId = _cursor.isNull(_cursorIndexOfObjectId) ? null : _cursor.getString(_cursorIndexOfObjectId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        PushEntity _item = new PushEntity(_tmpUserId, _tmpPushId, _tmpObjectId, _tmpType);
                        _result.add(_item);
                    }
                    ArrayList<PushEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getAllPushes(UserId userId, String type, Continuation<? super List<PushEntity>> arg2) {
        String _sql = "SELECT * FROM PushEntity WHERE userId = ? AND type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PushEntity WHERE userId = ? AND type = ?", (int)2);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (type == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, type);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PushEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PushEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PushDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfPushId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pushId");
                    int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"objectId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    ArrayList<PushEntity> _result = new ArrayList<PushEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = PushDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfPushId) ? null : _cursor.getString(_cursorIndexOfPushId);
                        PushId _tmpPushId = PushDao_Impl.this.__pushConverters.fromStringToPushId(_tmp_2);
                        String _tmpObjectId = _cursor.isNull(_cursorIndexOfObjectId) ? null : _cursor.getString(_cursorIndexOfObjectId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        PushEntity _item = new PushEntity(_tmpUserId, _tmpPushId, _tmpObjectId, _tmpType);
                        _result.add(_item);
                    }
                    ArrayList<PushEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg2);
    }

    public Object getPush(UserId userId, PushId pushId, Continuation<? super PushEntity> arg2) {
        String _sql = "SELECT * FROM PushEntity WHERE userId = ? AND pushId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PushEntity WHERE userId = ? AND pushId = ?", (int)2);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        String _tmp_1 = this.__pushConverters.fromPushIdToString(pushId);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_1);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PushEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PushEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PushDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PushEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfPushId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pushId");
                    int _cursorIndexOfObjectId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"objectId");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    if (_cursor.moveToFirst()) {
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = PushDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfPushId) ? null : _cursor.getString(_cursorIndexOfPushId);
                        PushId _tmpPushId = PushDao_Impl.this.__pushConverters.fromStringToPushId(_tmp_3);
                        String _tmpObjectId = _cursor.isNull(_cursorIndexOfObjectId) ? null : _cursor.getString(_cursorIndexOfObjectId);
                        String _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        _result = new PushEntity(_tmpUserId, _tmpPushId, _tmpObjectId, _tmpType);
                    } else {
                        _result = null;
                    }
                    PushEntity pushEntity = _result;
                    return pushEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg2);
    }

    public Object deletePushes(final UserId[] userIds, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM PushEntity WHERE userId IN (");
                int _inputSize = userIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = PushDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (UserId _item : userIds) {
                    String _tmp = PushDao_Impl.this.__commonConverters.fromUserIdToString(_item);
                    if (_tmp == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp);
                    }
                    ++_argIndex;
                }
                PushDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PushDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PushDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object deletePushes(final UserId userId, final PushId[] pushIds, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM PushEntity WHERE userId = ");
                _stringBuilder.append("?");
                _stringBuilder.append(" AND pushId IN (");
                int _inputSize = pushIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = PushDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                String _tmp = PushDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                for (PushId _item : pushIds) {
                    String _tmp_1 = PushDao_Impl.this.__pushConverters.fromPushIdToString(_item);
                    if (_tmp_1 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp_1);
                    }
                    ++_argIndex;
                }
                PushDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PushDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PushDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg2);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

