/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.contact.data.local.db.dao;

import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.dao.ContactCardDao;
import me.proton.core.contact.data.local.db.entity.ContactCardEntity;
import me.proton.core.contact.domain.entity.ContactId;

public final class ContactCardDao_Impl
extends ContactCardDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContactCardEntity> __insertionAdapterOfContactCardEntity;
    private final ContactConverters __contactConverters = new ContactConverters();
    private final EntityDeletionOrUpdateAdapter<ContactCardEntity> __deletionAdapterOfContactCardEntity;
    private final EntityDeletionOrUpdateAdapter<ContactCardEntity> __updateAdapterOfContactCardEntity;

    public ContactCardDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContactCardEntity = new EntityInsertionAdapter<ContactCardEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ContactCardEntity` (`contactId`,`type`,`data`,`signature`,`cardId`) VALUES (?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, ContactCardEntity value) {
                String _tmp = ContactCardDao_Impl.this.__contactConverters.fromContactIdToString(value.getContactId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                stmt.bindLong(2, (long)value.getType());
                if (value.getData() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getData());
                }
                if (value.getSignature() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSignature());
                }
                stmt.bindLong(5, value.getCardId());
            }
        };
        this.__deletionAdapterOfContactCardEntity = new EntityDeletionOrUpdateAdapter<ContactCardEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `ContactCardEntity` WHERE `cardId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ContactCardEntity value) {
                stmt.bindLong(1, value.getCardId());
            }
        };
        this.__updateAdapterOfContactCardEntity = new EntityDeletionOrUpdateAdapter<ContactCardEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `ContactCardEntity` SET `contactId` = ?,`type` = ?,`data` = ?,`signature` = ?,`cardId` = ? WHERE `cardId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ContactCardEntity value) {
                String _tmp = ContactCardDao_Impl.this.__contactConverters.fromContactIdToString(value.getContactId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                stmt.bindLong(2, (long)value.getType());
                if (value.getData() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getData());
                }
                if (value.getSignature() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSignature());
                }
                stmt.bindLong(5, value.getCardId());
                stmt.bindLong(6, value.getCardId());
            }
        };
    }

    public Object insertOrIgnore(final ContactCardEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ContactCardDao_Impl.this.__db.beginTransaction();
                try {
                    ContactCardDao_Impl.this.__insertionAdapterOfContactCardEntity.insert((Object[])entities);
                    ContactCardDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactCardDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final ContactCardEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ContactCardDao_Impl.this.__db.beginTransaction();
                try {
                    ContactCardDao_Impl.this.__deletionAdapterOfContactCardEntity.handleMultiple((Object[])entities);
                    ContactCardDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactCardDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final ContactCardEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                ContactCardDao_Impl.this.__db.beginTransaction();
                try {
                    ContactCardDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += ContactCardDao_Impl.this.__updateAdapterOfContactCardEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    ContactCardDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final ContactCardEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactCardDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteAllContactCards(final ContactId[] contactIds, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactCardDao_Impl.super.deleteAllContactCards(contactIds, __cont);
            }
        }, $completion);
    }

    protected Object deleteAllContactCardsSingleBatch(final ContactId[] contactIds, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM ContactCardEntity WHERE contactId IN (");
                int _inputSize = contactIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ContactCardDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (ContactId _item : contactIds) {
                    String _tmp = ContactCardDao_Impl.this.__contactConverters.fromContactIdToString(_item);
                    if (_tmp == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp);
                    }
                    ++_argIndex;
                }
                ContactCardDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactCardDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactCardDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

