/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.featureflag.data.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.featureflag.data.db.FeatureFlagDao;
import me.proton.core.featureflag.data.entity.FeatureFlagEntity;
import me.proton.core.featureflag.domain.entity.Scope;

public final class FeatureFlagDao_Impl
extends FeatureFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<FeatureFlagEntity> __insertionAdapterOfFeatureFlagEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EntityDeletionOrUpdateAdapter<FeatureFlagEntity> __deletionAdapterOfFeatureFlagEntity;
    private final EntityDeletionOrUpdateAdapter<FeatureFlagEntity> __updateAdapterOfFeatureFlagEntity;

    public FeatureFlagDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfFeatureFlagEntity = new EntityInsertionAdapter<FeatureFlagEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `FeatureFlagEntity` (`userId`,`featureId`,`scope`,`defaultValue`,`value`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, FeatureFlagEntity value) {
                String _tmp = FeatureFlagDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getFeatureId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFeatureId());
                }
                if (value.getScope() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, FeatureFlagDao_Impl.this.__Scope_enumToString(value.getScope()));
                }
                int _tmp_1 = value.getDefaultValue() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_1);
                int _tmp_2 = value.getValue() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
            }
        };
        this.__deletionAdapterOfFeatureFlagEntity = new EntityDeletionOrUpdateAdapter<FeatureFlagEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `FeatureFlagEntity` WHERE `userId` = ? AND `featureId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FeatureFlagEntity value) {
                String _tmp = FeatureFlagDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getFeatureId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFeatureId());
                }
            }
        };
        this.__updateAdapterOfFeatureFlagEntity = new EntityDeletionOrUpdateAdapter<FeatureFlagEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `FeatureFlagEntity` SET `userId` = ?,`featureId` = ?,`scope` = ?,`defaultValue` = ?,`value` = ? WHERE `userId` = ? AND `featureId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FeatureFlagEntity value) {
                String _tmp = FeatureFlagDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getFeatureId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFeatureId());
                }
                if (value.getScope() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, FeatureFlagDao_Impl.this.__Scope_enumToString(value.getScope()));
                }
                int _tmp_1 = value.getDefaultValue() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_1);
                int _tmp_2 = value.getValue() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                String _tmp_3 = FeatureFlagDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                if (value.getFeatureId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getFeatureId());
                }
            }
        };
    }

    public Object insertOrIgnore(final FeatureFlagEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                FeatureFlagDao_Impl.this.__db.beginTransaction();
                try {
                    FeatureFlagDao_Impl.this.__insertionAdapterOfFeatureFlagEntity.insert((Object[])entities);
                    FeatureFlagDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    FeatureFlagDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final FeatureFlagEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                FeatureFlagDao_Impl.this.__db.beginTransaction();
                try {
                    FeatureFlagDao_Impl.this.__deletionAdapterOfFeatureFlagEntity.handleMultiple((Object[])entities);
                    FeatureFlagDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    FeatureFlagDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final FeatureFlagEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                FeatureFlagDao_Impl.this.__db.beginTransaction();
                try {
                    FeatureFlagDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += FeatureFlagDao_Impl.this.__updateAdapterOfFeatureFlagEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    FeatureFlagDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final FeatureFlagEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return FeatureFlagDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Flow<List<FeatureFlagEntity>> observe$feature_flag_data_release(List<UserId> userIds, List<String> featureIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM FeatureFlagEntity WHERE featureId IN (");
        int _inputSize = featureIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AND userId IN (");
        int _inputSize_1 = userIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : featureIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        for (UserId _item_1 : userIds) {
            String _tmp = this.__commonConverters.fromUserIdToString(_item_1);
            if (_tmp == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _tmp);
            }
            ++_argIndex;
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"FeatureFlagEntity"}, (Callable)new Callable<List<FeatureFlagEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FeatureFlagEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)FeatureFlagDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFeatureId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"featureId");
                    int _cursorIndexOfScope = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scope");
                    int _cursorIndexOfDefaultValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"defaultValue");
                    int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"value");
                    ArrayList<FeatureFlagEntity> _result = new ArrayList<FeatureFlagEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = FeatureFlagDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmpFeatureId = _cursor.isNull(_cursorIndexOfFeatureId) ? null : _cursor.getString(_cursorIndexOfFeatureId);
                        Scope _tmpScope = FeatureFlagDao_Impl.this.__Scope_stringToEnum(_cursor.getString(_cursorIndexOfScope));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfDefaultValue);
                        boolean _tmpDefaultValue = _tmp_2 != 0;
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfValue);
                        boolean _tmpValue = _tmp_3 != 0;
                        FeatureFlagEntity _item_2 = new FeatureFlagEntity(_tmpUserId, _tmpFeatureId, _tmpScope, _tmpDefaultValue, _tmpValue);
                        _result.add(_item_2);
                    }
                    ArrayList<FeatureFlagEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object deleteAll$feature_flag_data_release(final List<UserId> userIds, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM FeatureFlagEntity WHERE userId IN (");
                int _inputSize = userIds.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = FeatureFlagDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (UserId _item : userIds) {
                    String _tmp = FeatureFlagDao_Impl.this.__commonConverters.fromUserIdToString(_item);
                    if (_tmp == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp);
                    }
                    ++_argIndex;
                }
                FeatureFlagDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    FeatureFlagDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    FeatureFlagDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private String __Scope_enumToString(Scope _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case Unknown: {
                return "Unknown";
            }
            case Local: {
                return "Local";
            }
            case User: {
                return "User";
            }
            case Global: {
                return "Global";
            }
        }
        throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + _value);
    }

    private Scope __Scope_stringToEnum(String _value) {
        if (_value == null) {
            return null;
        }
        switch (_value) {
            case "Unknown": {
                return Scope.Unknown;
            }
            case "Local": {
                return Scope.Local;
            }
            case "User": {
                return Scope.User;
            }
            case "Global": {
                return Scope.Global;
            }
        }
        throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
}

