/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.humanverification.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.humanverification.data.db.HumanVerificationConverters;
import me.proton.core.humanverification.data.db.HumanVerificationDetailsDao;
import me.proton.core.humanverification.data.entity.HumanVerificationEntity;
import me.proton.core.network.domain.client.ClientIdType;
import me.proton.core.network.domain.humanverification.HumanVerificationState;

public final class HumanVerificationDetailsDao_Impl
extends HumanVerificationDetailsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<HumanVerificationEntity> __insertionAdapterOfHumanVerificationEntity;
    private final HumanVerificationConverters __humanVerificationConverters = new HumanVerificationConverters();
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EntityDeletionOrUpdateAdapter<HumanVerificationEntity> __deletionAdapterOfHumanVerificationEntity;
    private final EntityDeletionOrUpdateAdapter<HumanVerificationEntity> __updateAdapterOfHumanVerificationEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByClientId;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStateAndToken;

    public HumanVerificationDetailsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHumanVerificationEntity = new EntityInsertionAdapter<HumanVerificationEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `HumanVerificationEntity` (`clientId`,`clientIdType`,`verificationMethods`,`verificationToken`,`state`,`humanHeaderTokenType`,`humanHeaderTokenCode`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, HumanVerificationEntity value) {
                if (value.getClientId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getClientId());
                }
                String _tmp = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromClientIdTypeToString(value.getClientIdType());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = HumanVerificationDetailsDao_Impl.this.__commonConverters.fromListOfStringToString(value.getVerificationMethods());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getVerificationToken() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getVerificationToken());
                }
                String _tmp_2 = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromHumanVerificationStateToString(value.getState());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                if (value.getHumanHeaderTokenType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getHumanHeaderTokenType());
                }
                if (value.getHumanHeaderTokenCode() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getHumanHeaderTokenCode());
                }
            }
        };
        this.__deletionAdapterOfHumanVerificationEntity = new EntityDeletionOrUpdateAdapter<HumanVerificationEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `HumanVerificationEntity` WHERE `clientId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, HumanVerificationEntity value) {
                if (value.getClientId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getClientId());
                }
            }
        };
        this.__updateAdapterOfHumanVerificationEntity = new EntityDeletionOrUpdateAdapter<HumanVerificationEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `HumanVerificationEntity` SET `clientId` = ?,`clientIdType` = ?,`verificationMethods` = ?,`verificationToken` = ?,`state` = ?,`humanHeaderTokenType` = ?,`humanHeaderTokenCode` = ? WHERE `clientId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, HumanVerificationEntity value) {
                if (value.getClientId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getClientId());
                }
                String _tmp = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromClientIdTypeToString(value.getClientIdType());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = HumanVerificationDetailsDao_Impl.this.__commonConverters.fromListOfStringToString(value.getVerificationMethods());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getVerificationToken() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getVerificationToken());
                }
                String _tmp_2 = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromHumanVerificationStateToString(value.getState());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                if (value.getHumanHeaderTokenType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getHumanHeaderTokenType());
                }
                if (value.getHumanHeaderTokenCode() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getHumanHeaderTokenCode());
                }
                if (value.getClientId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getClientId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM HumanVerificationEntity";
                return "DELETE FROM HumanVerificationEntity";
            }
        };
        this.__preparedStmtOfDeleteByClientId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM HumanVerificationEntity WHERE clientId = ?";
                return "DELETE FROM HumanVerificationEntity WHERE clientId = ?";
            }
        };
        this.__preparedStmtOfUpdateStateAndToken = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE HumanVerificationEntity SET state = ?, humanHeaderTokenType = ?, humanHeaderTokenCode = ? WHERE clientId = ?";
                return "UPDATE HumanVerificationEntity SET state = ?, humanHeaderTokenType = ?, humanHeaderTokenCode = ? WHERE clientId = ?";
            }
        };
    }

    public Object insertOrIgnore(final HumanVerificationEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                HumanVerificationDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    HumanVerificationDetailsDao_Impl.this.__insertionAdapterOfHumanVerificationEntity.insert((Object[])entities);
                    HumanVerificationDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HumanVerificationDetailsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final HumanVerificationEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                HumanVerificationDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    HumanVerificationDetailsDao_Impl.this.__deletionAdapterOfHumanVerificationEntity.handleMultiple((Object[])entities);
                    HumanVerificationDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HumanVerificationDetailsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final HumanVerificationEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                HumanVerificationDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    HumanVerificationDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += HumanVerificationDetailsDao_Impl.this.__updateAdapterOfHumanVerificationEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    HumanVerificationDetailsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final HumanVerificationEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return HumanVerificationDetailsDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteAll(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = HumanVerificationDetailsDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                HumanVerificationDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    HumanVerificationDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HumanVerificationDetailsDao_Impl.this.__db.endTransaction();
                    HumanVerificationDetailsDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg0);
    }

    public Object deleteByClientId(final String clientId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = HumanVerificationDetailsDao_Impl.this.__preparedStmtOfDeleteByClientId.acquire();
                int _argIndex = 1;
                if (clientId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, clientId);
                }
                HumanVerificationDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    HumanVerificationDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HumanVerificationDetailsDao_Impl.this.__db.endTransaction();
                    HumanVerificationDetailsDao_Impl.this.__preparedStmtOfDeleteByClientId.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object updateStateAndToken(final String clientId, final HumanVerificationState humanVerificationState, final String tokenType, final String tokenCode, Continuation<? super Unit> arg4) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = HumanVerificationDetailsDao_Impl.this.__preparedStmtOfUpdateStateAndToken.acquire();
                int _argIndex = 1;
                String _tmp = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromHumanVerificationStateToString(humanVerificationState);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (tokenType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, tokenType);
                }
                _argIndex = 3;
                if (tokenCode == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, tokenCode);
                }
                _argIndex = 4;
                if (clientId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, clientId);
                }
                HumanVerificationDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    HumanVerificationDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HumanVerificationDetailsDao_Impl.this.__db.endTransaction();
                    HumanVerificationDetailsDao_Impl.this.__preparedStmtOfUpdateStateAndToken.release(_stmt);
                }
            }
        }, arg4);
    }

    public Flow<List<HumanVerificationEntity>> getAll() {
        String _sql = "SELECT * FROM HumanVerificationEntity";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM HumanVerificationEntity", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"HumanVerificationEntity"}, (Callable)new Callable<List<HumanVerificationEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<HumanVerificationEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HumanVerificationDetailsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfClientId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clientId");
                    int _cursorIndexOfClientIdType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clientIdType");
                    int _cursorIndexOfVerificationMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verificationMethods");
                    int _cursorIndexOfVerificationToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verificationToken");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfHumanHeaderTokenType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"humanHeaderTokenType");
                    int _cursorIndexOfHumanHeaderTokenCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"humanHeaderTokenCode");
                    ArrayList<HumanVerificationEntity> _result = new ArrayList<HumanVerificationEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpClientId = _cursor.isNull(_cursorIndexOfClientId) ? null : _cursor.getString(_cursorIndexOfClientId);
                        String _tmp = _cursor.isNull(_cursorIndexOfClientIdType) ? null : _cursor.getString(_cursorIndexOfClientIdType);
                        ClientIdType _tmpClientIdType = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromStringToClientIdType(_tmp);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfVerificationMethods) ? null : _cursor.getString(_cursorIndexOfVerificationMethods);
                        List _tmpVerificationMethods = HumanVerificationDetailsDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_1);
                        String _tmpVerificationToken = _cursor.isNull(_cursorIndexOfVerificationToken) ? null : _cursor.getString(_cursorIndexOfVerificationToken);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                        HumanVerificationState _tmpState = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromStringToHumanVerificationState(_tmp_2);
                        String _tmpHumanHeaderTokenType = _cursor.isNull(_cursorIndexOfHumanHeaderTokenType) ? null : _cursor.getString(_cursorIndexOfHumanHeaderTokenType);
                        String _tmpHumanHeaderTokenCode = _cursor.isNull(_cursorIndexOfHumanHeaderTokenCode) ? null : _cursor.getString(_cursorIndexOfHumanHeaderTokenCode);
                        HumanVerificationEntity _item = new HumanVerificationEntity(_tmpClientId, _tmpClientIdType, _tmpVerificationMethods, _tmpVerificationToken, _tmpState, _tmpHumanHeaderTokenType, _tmpHumanHeaderTokenCode);
                        _result.add(_item);
                    }
                    ArrayList<HumanVerificationEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getByClientId(String clientId, Continuation<? super HumanVerificationEntity> arg1) {
        String _sql = "SELECT * FROM HumanVerificationEntity WHERE clientId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM HumanVerificationEntity WHERE clientId = ?", (int)1);
        int _argIndex = 1;
        if (clientId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, clientId);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<HumanVerificationEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HumanVerificationEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)HumanVerificationDetailsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    HumanVerificationEntity _result;
                    int _cursorIndexOfClientId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clientId");
                    int _cursorIndexOfClientIdType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clientIdType");
                    int _cursorIndexOfVerificationMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verificationMethods");
                    int _cursorIndexOfVerificationToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verificationToken");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfHumanHeaderTokenType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"humanHeaderTokenType");
                    int _cursorIndexOfHumanHeaderTokenCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"humanHeaderTokenCode");
                    if (_cursor.moveToFirst()) {
                        String _tmpClientId = _cursor.isNull(_cursorIndexOfClientId) ? null : _cursor.getString(_cursorIndexOfClientId);
                        String _tmp = _cursor.isNull(_cursorIndexOfClientIdType) ? null : _cursor.getString(_cursorIndexOfClientIdType);
                        ClientIdType _tmpClientIdType = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromStringToClientIdType(_tmp);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfVerificationMethods) ? null : _cursor.getString(_cursorIndexOfVerificationMethods);
                        List _tmpVerificationMethods = HumanVerificationDetailsDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_1);
                        String _tmpVerificationToken = _cursor.isNull(_cursorIndexOfVerificationToken) ? null : _cursor.getString(_cursorIndexOfVerificationToken);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                        HumanVerificationState _tmpState = HumanVerificationDetailsDao_Impl.this.__humanVerificationConverters.fromStringToHumanVerificationState(_tmp_2);
                        String _tmpHumanHeaderTokenType = _cursor.isNull(_cursorIndexOfHumanHeaderTokenType) ? null : _cursor.getString(_cursorIndexOfHumanHeaderTokenType);
                        String _tmpHumanHeaderTokenCode = _cursor.isNull(_cursorIndexOfHumanHeaderTokenCode) ? null : _cursor.getString(_cursorIndexOfHumanHeaderTokenCode);
                        _result = new HumanVerificationEntity(_tmpClientId, _tmpClientIdType, _tmpVerificationMethods, _tmpVerificationToken, _tmpState, _tmpHumanHeaderTokenType, _tmpHumanHeaderTokenCode);
                    } else {
                        _result = null;
                    }
                    HumanVerificationEntity humanVerificationEntity = _result;
                    return humanVerificationEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

