/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.crypto.android.keystore.CryptoConverters;
import me.proton.core.crypto.common.keystore.EncryptedByteArray;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.db.dao.AddressKeyDao;
import me.proton.core.user.data.entity.AddressKeyEntity;
import me.proton.core.user.domain.entity.AddressId;

public final class AddressKeyDao_Impl
extends AddressKeyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AddressKeyEntity> __insertionAdapterOfAddressKeyEntity;
    private final UserConverters __userConverters = new UserConverters();
    private final CryptoConverters __cryptoConverters = new CryptoConverters();
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EntityDeletionOrUpdateAdapter<AddressKeyEntity> __deletionAdapterOfAddressKeyEntity;
    private final EntityDeletionOrUpdateAdapter<AddressKeyEntity> __updateAdapterOfAddressKeyEntity;

    public AddressKeyDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAddressKeyEntity = new EntityInsertionAdapter<AddressKeyEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `AddressKeyEntity` (`addressId`,`keyId`,`version`,`privateKey`,`isPrimary`,`isUnlockable`,`flags`,`passphrase`,`token`,`signature`,`fingerprint`,`fingerprints`,`activation`,`active`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AddressKeyEntity value) {
                String _tmp = AddressKeyDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AddressKeyDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                stmt.bindLong(3, (long)value.getVersion());
                if (value.getPrivateKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPrivateKey());
                }
                int _tmp_2 = value.isPrimary() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                int _tmp_3 = value.isUnlockable() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_3);
                stmt.bindLong(7, (long)value.getFlags());
                byte[] _tmp_4 = AddressKeyDao_Impl.this.__cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindBlob(8, _tmp_4);
                }
                if (value.getToken() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getToken());
                }
                if (value.getSignature() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getSignature());
                }
                if (value.getFingerprint() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getFingerprint());
                }
                String _tmp_5 = AddressKeyDao_Impl.this.__commonConverters.fromListOfStringToString(value.getFingerprints());
                if (_tmp_5 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_5);
                }
                if (value.getActivation() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getActivation());
                }
                int _tmp_6 = value.getActive() ? 1 : 0;
                stmt.bindLong(14, (long)_tmp_6);
            }
        };
        this.__deletionAdapterOfAddressKeyEntity = new EntityDeletionOrUpdateAdapter<AddressKeyEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `AddressKeyEntity` WHERE `keyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AddressKeyEntity value) {
                String _tmp = AddressKeyDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfAddressKeyEntity = new EntityDeletionOrUpdateAdapter<AddressKeyEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `AddressKeyEntity` SET `addressId` = ?,`keyId` = ?,`version` = ?,`privateKey` = ?,`isPrimary` = ?,`isUnlockable` = ?,`flags` = ?,`passphrase` = ?,`token` = ?,`signature` = ?,`fingerprint` = ?,`fingerprints` = ?,`activation` = ?,`active` = ? WHERE `keyId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AddressKeyEntity value) {
                String _tmp = AddressKeyDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AddressKeyDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                stmt.bindLong(3, (long)value.getVersion());
                if (value.getPrivateKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPrivateKey());
                }
                int _tmp_2 = value.isPrimary() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                int _tmp_3 = value.isUnlockable() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_3);
                stmt.bindLong(7, (long)value.getFlags());
                byte[] _tmp_4 = AddressKeyDao_Impl.this.__cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindBlob(8, _tmp_4);
                }
                if (value.getToken() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getToken());
                }
                if (value.getSignature() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getSignature());
                }
                if (value.getFingerprint() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getFingerprint());
                }
                String _tmp_5 = AddressKeyDao_Impl.this.__commonConverters.fromListOfStringToString(value.getFingerprints());
                if (_tmp_5 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_5);
                }
                if (value.getActivation() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getActivation());
                }
                int _tmp_6 = value.getActive() ? 1 : 0;
                stmt.bindLong(14, (long)_tmp_6);
                String _tmp_7 = AddressKeyDao_Impl.this.__userConverters.fromKeyIdToString(value.getKeyId());
                if (_tmp_7 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_7);
                }
            }
        };
    }

    public Object insertOrIgnore(final AddressKeyEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AddressKeyDao_Impl.this.__db.beginTransaction();
                try {
                    AddressKeyDao_Impl.this.__insertionAdapterOfAddressKeyEntity.insert((Object[])entities);
                    AddressKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final AddressKeyEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AddressKeyDao_Impl.this.__db.beginTransaction();
                try {
                    AddressKeyDao_Impl.this.__deletionAdapterOfAddressKeyEntity.handleMultiple((Object[])entities);
                    AddressKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final AddressKeyEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                AddressKeyDao_Impl.this.__db.beginTransaction();
                try {
                    AddressKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += AddressKeyDao_Impl.this.__updateAdapterOfAddressKeyEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    AddressKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final AddressKeyEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return AddressKeyDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Flow<List<AddressKeyEntity>> observeAllByAddressId(AddressId addressId) {
        String _sql = "SELECT * FROM AddressKeyEntity WHERE addressId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AddressKeyEntity WHERE addressId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__userConverters.fromAddressIdToString(addressId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"AddressKeyEntity"}, (Callable)new Callable<List<AddressKeyEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AddressKeyEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AddressKeyDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
                    int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"keyId");
                    int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"version");
                    int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privateKey");
                    int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPrimary");
                    int _cursorIndexOfIsUnlockable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isUnlockable");
                    int _cursorIndexOfFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flags");
                    int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"passphrase");
                    int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"token");
                    int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
                    int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprint");
                    int _cursorIndexOfFingerprints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprints");
                    int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activation");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    ArrayList<AddressKeyEntity> _result = new ArrayList<AddressKeyEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                        AddressId _tmpAddressId = AddressKeyDao_Impl.this.__userConverters.fromStringToAddressId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfKeyId) ? null : _cursor.getString(_cursorIndexOfKeyId);
                        KeyId _tmpKeyId = AddressKeyDao_Impl.this.__userConverters.fromStringToKeyId(_tmp_2);
                        int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                        String _tmpPrivateKey = _cursor.isNull(_cursorIndexOfPrivateKey) ? null : _cursor.getString(_cursorIndexOfPrivateKey);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsPrimary);
                        boolean _tmpIsPrimary = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsUnlockable);
                        boolean _tmpIsUnlockable = _tmp_4 != 0;
                        int _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
                        byte[] _tmp_5 = _cursor.isNull(_cursorIndexOfPassphrase) ? null : _cursor.getBlob(_cursorIndexOfPassphrase);
                        EncryptedByteArray _tmpPassphrase = AddressKeyDao_Impl.this.__cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_5);
                        String _tmpToken = _cursor.isNull(_cursorIndexOfToken) ? null : _cursor.getString(_cursorIndexOfToken);
                        String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                        String _tmpFingerprint = _cursor.isNull(_cursorIndexOfFingerprint) ? null : _cursor.getString(_cursorIndexOfFingerprint);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfFingerprints) ? null : _cursor.getString(_cursorIndexOfFingerprints);
                        List _tmpFingerprints = AddressKeyDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_6);
                        String _tmpActivation = _cursor.isNull(_cursorIndexOfActivation) ? null : _cursor.getString(_cursorIndexOfActivation);
                        int _tmp_7 = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp_7 != 0;
                        AddressKeyEntity _item = new AddressKeyEntity(_tmpAddressId, _tmpKeyId, _tmpVersion, _tmpPrivateKey, _tmpIsPrimary, _tmpIsUnlockable, _tmpFlags, _tmpPassphrase, _tmpToken, _tmpSignature, _tmpFingerprint, _tmpFingerprints, _tmpActivation, _tmpActive);
                        _result.add(_item);
                    }
                    ArrayList<AddressKeyEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getAllByAddressId(AddressId addressId, Continuation<? super List<AddressKeyEntity>> arg1) {
        String _sql = "SELECT * FROM AddressKeyEntity WHERE addressId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AddressKeyEntity WHERE addressId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__userConverters.fromAddressIdToString(addressId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AddressKeyEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AddressKeyEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AddressKeyDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
                    int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"keyId");
                    int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"version");
                    int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privateKey");
                    int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPrimary");
                    int _cursorIndexOfIsUnlockable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isUnlockable");
                    int _cursorIndexOfFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flags");
                    int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"passphrase");
                    int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"token");
                    int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
                    int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprint");
                    int _cursorIndexOfFingerprints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprints");
                    int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activation");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    ArrayList<AddressKeyEntity> _result = new ArrayList<AddressKeyEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                        AddressId _tmpAddressId = AddressKeyDao_Impl.this.__userConverters.fromStringToAddressId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfKeyId) ? null : _cursor.getString(_cursorIndexOfKeyId);
                        KeyId _tmpKeyId = AddressKeyDao_Impl.this.__userConverters.fromStringToKeyId(_tmp_2);
                        int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                        String _tmpPrivateKey = _cursor.isNull(_cursorIndexOfPrivateKey) ? null : _cursor.getString(_cursorIndexOfPrivateKey);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsPrimary);
                        boolean _tmpIsPrimary = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsUnlockable);
                        boolean _tmpIsUnlockable = _tmp_4 != 0;
                        int _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
                        byte[] _tmp_5 = _cursor.isNull(_cursorIndexOfPassphrase) ? null : _cursor.getBlob(_cursorIndexOfPassphrase);
                        EncryptedByteArray _tmpPassphrase = AddressKeyDao_Impl.this.__cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_5);
                        String _tmpToken = _cursor.isNull(_cursorIndexOfToken) ? null : _cursor.getString(_cursorIndexOfToken);
                        String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                        String _tmpFingerprint = _cursor.isNull(_cursorIndexOfFingerprint) ? null : _cursor.getString(_cursorIndexOfFingerprint);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfFingerprints) ? null : _cursor.getString(_cursorIndexOfFingerprints);
                        List _tmpFingerprints = AddressKeyDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_6);
                        String _tmpActivation = _cursor.isNull(_cursorIndexOfActivation) ? null : _cursor.getString(_cursorIndexOfActivation);
                        int _tmp_7 = _cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp_7 != 0;
                        AddressKeyEntity _item = new AddressKeyEntity(_tmpAddressId, _tmpKeyId, _tmpVersion, _tmpPrivateKey, _tmpIsPrimary, _tmpIsUnlockable, _tmpFlags, _tmpPassphrase, _tmpToken, _tmpSignature, _tmpFingerprint, _tmpFingerprints, _tmpActivation, _tmpActive);
                        _result.add(_item);
                    }
                    ArrayList<AddressKeyEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

