/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.payment.data.local.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import me.proton.core.payment.data.local.db.dao.GooglePurchaseDao;
import me.proton.core.payment.data.local.entity.GooglePurchaseEntity;

public final class GooglePurchaseDao_Impl
extends GooglePurchaseDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<GooglePurchaseEntity> __insertionAdapterOfGooglePurchaseEntity;
    private final EntityDeletionOrUpdateAdapter<GooglePurchaseEntity> __deletionAdapterOfGooglePurchaseEntity;
    private final EntityDeletionOrUpdateAdapter<GooglePurchaseEntity> __updateAdapterOfGooglePurchaseEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByGooglePurchaseToken;

    public GooglePurchaseDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGooglePurchaseEntity = new EntityInsertionAdapter<GooglePurchaseEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `GooglePurchaseEntity` (`googlePurchaseToken`,`paymentToken`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, GooglePurchaseEntity value) {
                if (value.getGooglePurchaseToken() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getGooglePurchaseToken());
                }
                if (value.getPaymentToken() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPaymentToken());
                }
            }
        };
        this.__deletionAdapterOfGooglePurchaseEntity = new EntityDeletionOrUpdateAdapter<GooglePurchaseEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `GooglePurchaseEntity` WHERE `googlePurchaseToken` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, GooglePurchaseEntity value) {
                if (value.getGooglePurchaseToken() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getGooglePurchaseToken());
                }
            }
        };
        this.__updateAdapterOfGooglePurchaseEntity = new EntityDeletionOrUpdateAdapter<GooglePurchaseEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `GooglePurchaseEntity` SET `googlePurchaseToken` = ?,`paymentToken` = ? WHERE `googlePurchaseToken` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, GooglePurchaseEntity value) {
                if (value.getGooglePurchaseToken() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getGooglePurchaseToken());
                }
                if (value.getPaymentToken() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPaymentToken());
                }
                if (value.getGooglePurchaseToken() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getGooglePurchaseToken());
                }
            }
        };
        this.__preparedStmtOfDeleteByGooglePurchaseToken = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM GooglePurchaseEntity WHERE googlePurchaseToken = ?";
                return "DELETE FROM GooglePurchaseEntity WHERE googlePurchaseToken = ?";
            }
        };
    }

    public Object insertOrIgnore(final GooglePurchaseEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                GooglePurchaseDao_Impl.this.__db.beginTransaction();
                try {
                    GooglePurchaseDao_Impl.this.__insertionAdapterOfGooglePurchaseEntity.insert((Object[])entities);
                    GooglePurchaseDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    GooglePurchaseDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final GooglePurchaseEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                GooglePurchaseDao_Impl.this.__db.beginTransaction();
                try {
                    GooglePurchaseDao_Impl.this.__deletionAdapterOfGooglePurchaseEntity.handleMultiple((Object[])entities);
                    GooglePurchaseDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    GooglePurchaseDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final GooglePurchaseEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                GooglePurchaseDao_Impl.this.__db.beginTransaction();
                try {
                    GooglePurchaseDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += GooglePurchaseDao_Impl.this.__updateAdapterOfGooglePurchaseEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    GooglePurchaseDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final GooglePurchaseEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return GooglePurchaseDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteByGooglePurchaseToken(final String googlePurchaseToken, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = GooglePurchaseDao_Impl.this.__preparedStmtOfDeleteByGooglePurchaseToken.acquire();
                int _argIndex = 1;
                if (googlePurchaseToken == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, googlePurchaseToken);
                }
                GooglePurchaseDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    GooglePurchaseDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    GooglePurchaseDao_Impl.this.__db.endTransaction();
                    GooglePurchaseDao_Impl.this.__preparedStmtOfDeleteByGooglePurchaseToken.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object findByPaymentToken(String paymentToken, Continuation<? super GooglePurchaseEntity> arg1) {
        String _sql = "SELECT * FROM GooglePurchaseEntity WHERE paymentToken = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM GooglePurchaseEntity WHERE paymentToken = ?", (int)1);
        int _argIndex = 1;
        if (paymentToken == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, paymentToken);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<GooglePurchaseEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GooglePurchaseEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)GooglePurchaseDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    GooglePurchaseEntity _result;
                    int _cursorIndexOfGooglePurchaseToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"googlePurchaseToken");
                    int _cursorIndexOfPaymentToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paymentToken");
                    if (_cursor.moveToFirst()) {
                        String _tmpGooglePurchaseToken = _cursor.isNull(_cursorIndexOfGooglePurchaseToken) ? null : _cursor.getString(_cursorIndexOfGooglePurchaseToken);
                        String _tmpPaymentToken = _cursor.isNull(_cursorIndexOfPaymentToken) ? null : _cursor.getString(_cursorIndexOfPaymentToken);
                        _result = new GooglePurchaseEntity(_tmpGooglePurchaseToken, _tmpPaymentToken);
                    } else {
                        _result = null;
                    }
                    GooglePurchaseEntity googlePurchaseEntity = _result;
                    return googlePurchaseEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

