/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.qoomon.gitversioning.GitConstants;

public class GitRepoSituation {
    private boolean clean;
    private String headCommit;
    private String headBranch;
    private long headCommitTimestamp;
    private List<String> headTags;

    public GitRepoSituation() {
        this(true, GitConstants.NO_COMMIT, 0L, Collections.emptyList(), null);
    }

    public GitRepoSituation(boolean clean, String headCommit, long headCommitTimestamp, List<String> headTags, String headBranch) {
        this.setClean(clean);
        this.setHeadCommit(headCommit);
        this.setHeadCommitTimestamp(headCommitTimestamp);
        this.setHeadBranch(headBranch);
        this.setHeadTags(headTags);
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public String getHeadCommit() {
        return this.headCommit;
    }

    public void setHeadCommit(String headCommit) {
        this.headCommit = Objects.requireNonNull(headCommit);
        if (headCommit.length() != 40) {
            throw new IllegalArgumentException("headCommit sha-1 hash must contains of 40 hex characters");
        }
    }

    public long getHeadCommitTimestamp() {
        return this.headCommitTimestamp;
    }

    public void setHeadCommitTimestamp(long headCommitTimestamp) {
        this.headCommitTimestamp = headCommitTimestamp;
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public void setHeadBranch(String headBranch) {
        this.headBranch = headBranch;
    }

    public List<String> getHeadTags() {
        return this.headTags;
    }

    public void setHeadTags(List<String> headTags) {
        this.headTags = Objects.requireNonNull(headTags);
    }
}

