/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning;

import java.util.Map;
import java.util.Objects;

public class GitVersionDetails {
    private boolean clean;
    private final String commit;
    private final String commitRefType;
    private final String commitRefName;
    private final long commitTimestamp;
    private final VersionTransformer versionTransformer;
    private final PropertiesTransformer propertiesTransformer;

    public GitVersionDetails(boolean clean, String commit, String commitRefType, String commitRefName, long commitTimestamp, VersionTransformer versionTransformer, PropertiesTransformer propertiesTransformer) {
        this.clean = clean;
        this.commitTimestamp = commitTimestamp;
        this.versionTransformer = Objects.requireNonNull(versionTransformer);
        this.propertiesTransformer = Objects.requireNonNull(propertiesTransformer);
        this.commit = Objects.requireNonNull(commit);
        this.commitRefType = Objects.requireNonNull(commitRefType);
        this.commitRefName = Objects.requireNonNull(commitRefName);
    }

    public boolean isClean() {
        return this.clean;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getCommitRefType() {
        return this.commitRefType;
    }

    public String getCommitRefName() {
        return this.commitRefName;
    }

    public long getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public VersionTransformer getVersionTransformer() {
        return this.versionTransformer;
    }

    public PropertiesTransformer getPropertiesTransformer() {
        return this.propertiesTransformer;
    }

    @FunctionalInterface
    public static interface VersionTransformer {
        public String apply(String var1);
    }

    @FunctionalInterface
    public static interface PropertiesTransformer {
        public Map<String, String> apply(Map<String, String> var1, String var2);
    }
}

