/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.qoomon.gitversioning.commons.GitRefType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JacksonXmlRootElement(localName="configuration")
public class Configuration {
    private static final String MATCH_ALL = ".*";
    public Boolean disable = false;
    @JsonDeserialize(using=IgnoreWhitespaceDeserializer.class)
    public String describeTagPattern = ".*";
    public Boolean updatePom = false;
    public RefPatchDescriptionList refs = new RefPatchDescriptionList();
    public PatchDescription rev;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JacksonXmlElementWrapper
    @JsonProperty(required=true)
    public List<RelatedProject> relatedProjects = new ArrayList<RelatedProject>();

    public Pattern describeTagPattern() {
        if (this.describeTagPattern == null) {
            return null;
        }
        return Pattern.compile(this.describeTagPattern);
    }

    public static class RefPatchDescriptionList {
        @JacksonXmlProperty(isAttribute=true)
        public Boolean considerTagsOnBranches = false;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="ref")
        public List<RefPatchDescription> list = new ArrayList<RefPatchDescription>();
    }

    public static class IgnoreWhitespaceDeserializer
    extends JsonDeserializer<Object> {
        public Object deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            return jp.getText().replaceAll("\\s+", "");
        }
    }

    public static class RelatedProject {
        @JsonDeserialize(using=IgnoreWhitespaceDeserializer.class)
        public String groupId;
        @JsonDeserialize(using=IgnoreWhitespaceDeserializer.class)
        public String artifactId;

        @JsonCreator
        public RelatedProject(@JsonProperty(required=true, value="groupId") String groupId, @JsonProperty(required=true, value="artifactId") String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class RefPatchDescription
    extends PatchDescription {
        @JacksonXmlProperty(isAttribute=true)
        public GitRefType type = GitRefType.COMMIT;
        @JsonDeserialize(using=IgnoreWhitespaceDeserializer.class)
        public String pattern;

        public Pattern pattern() {
            if (this.pattern == null) {
                return null;
            }
            return Pattern.compile(this.pattern);
        }

        public RefPatchDescription() {
        }

        public RefPatchDescription(GitRefType type, Pattern pattern, PatchDescription description) {
            this.type = type;
            this.pattern = pattern != null ? pattern.pattern() : null;
            this.describeTagPattern = description.describeTagPattern;
            this.updatePom = description.updatePom;
            this.version = description.version;
            this.properties = new HashMap<String, String>(description.properties);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class PatchDescription {
        @JsonDeserialize(using=IgnoreWhitespaceDeserializer.class)
        public String describeTagPattern;
        @JsonDeserialize(using=IgnoreWhitespaceDeserializer.class)
        public String version;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JacksonXmlElementWrapper(useWrapping=false)
        public Map<String, String> properties = new HashMap<String, String>();
        public Boolean updatePom;

        public Pattern describeTagPattern() {
            if (this.describeTagPattern == null) {
                return null;
            }
            return Pattern.compile(this.describeTagPattern);
        }
    }
}

