/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import java.io.File;
import me.qoomon.maven.gitversioning.BuildProperties;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="git-versioning", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class GitVersioningMojo
extends AbstractMojo {
    static final String GOAL = "git-versioning";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public synchronized void execute() {
        File gitVersionedPomFile = new File(this.project.getBasedir(), ".git-versioned-pom.xml");
        this.project.setPomFile(gitVersionedPomFile);
        this.getLog().debug((CharSequence)"remove version build plugin");
        this.project.getModel().getBuild().getPlugins().remove(GitVersioningMojo.asPlugin());
        this.project.getOriginalModel().getBuild().getPlugins().remove(GitVersioningMojo.asPlugin());
    }

    static Plugin asPlugin() {
        Plugin plugin = new Plugin();
        plugin.setGroupId(BuildProperties.projectGroupId());
        plugin.setArtifactId(BuildProperties.projectArtifactId());
        plugin.setVersion(BuildProperties.projectVersion());
        return plugin;
    }
}

