/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.annotator;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;
import me.snowdrop.istio.api.internal.IstioSpecRegistry;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;

public class IstioTypeAnnotator
extends Jackson2Annotator {
    private static final String BUILDER_PACKAGE = "io.fabric8.kubernetes.api.builder";
    private static final String DONEABLE_CLASS_NAME = "io.fabric8.kubernetes.api.model.Doneable";
    private static final String OBJECT_META_CLASS_NAME = "io.fabric8.kubernetes.api.model.ObjectMeta";
    private static final String IS_INTERFACE_FIELD = "isInterface";
    private static final String EXISTING_JAVA_TYPE_FIELD = "existingJavaType";
    private final JDefinedClass doneableClass;
    private final JDefinedClass objectMetaClass;
    private Set<JDefinedClass> annotated = new HashSet<JDefinedClass>();

    public IstioTypeAnnotator(GenerationConfig generationConfig) {
        super(generationConfig);
        String className = DONEABLE_CLASS_NAME;
        try {
            this.doneableClass = new JCodeModel()._class(className);
            className = OBJECT_META_CLASS_NAME;
            this.objectMetaClass = new JCodeModel()._class(className);
        }
        catch (JClassAlreadyExistsException e) {
            throw new IllegalStateException("Couldn't load " + className);
        }
    }

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        Optional version;
        JAnnotationArrayMember annotationValue = clazz.annotate(JsonPropertyOrder.class).paramArray("value");
        annotationValue.param("apiVersion");
        annotationValue.param("kind");
        annotationValue.param("metadata");
        Iterator fields = propertiesNode.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if ("apiVersion".equals(key) || "kind".equals(key) || "metadata".equals(key)) continue;
            annotationValue.param(key);
        }
        Optional kind = IstioSpecRegistry.getIstioKind((String)clazz.name());
        if (kind.isPresent()) {
            clazz._implements(IstioSpec.class);
            String plural = IstioSpecRegistry.getIstioKindPlural((String)clazz.name()).orElse(kind + "s");
            clazz.annotate(IstioKind.class).param("name", (String)kind.get()).param("plural", plural);
        }
        if ((version = IstioSpecRegistry.getIstioApiVersion((String)clazz.name())).isPresent()) {
            clazz.annotate(IstioApiVersion.class).param("value", (String)version.get());
        }
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        JAnnotationUse buildable = clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", true).param("generateBuilderPackage", true).param("builderPackage", BUILDER_PACKAGE);
        buildable.paramArray("inline").annotate(Inline.class).param("type", (JType)this.doneableClass).param("prefix", "Doneable").param("value", "done");
        buildable.paramArray("refs").annotate(BuildableReference.class).param("value", (JType)this.objectMetaClass);
        if (clazz.name().endsWith("Spec")) {
            JAnnotationArrayMember arrayMember = clazz.annotate(VelocityTransformations.class).paramArray("value");
            arrayMember.annotate(VelocityTransformation.class).param("value", "/istio-resource.vm");
            arrayMember.annotate(VelocityTransformation.class).param("value", "/istio-resource-list.vm");
            arrayMember.annotate(VelocityTransformation.class).param("value", "/istio-manifest.vm").param("outputPath", "crd.properties").param("gather", true);
            arrayMember.annotate(VelocityTransformation.class).param("value", "/istio-mappings-provider.vm").param("outputPath", Paths.get("me", "snowdrop", "istio", "api", "model", "IstioResourceMappingsProvider.java").toString()).param("gather", true);
        }
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.hasNonNull(IS_INTERFACE_FIELD)) {
            field.annotate(JsonUnwrapped.class);
            String interfaceFQN = propertyNode.get(EXISTING_JAVA_TYPE_FIELD).asText();
            try {
                JDefinedClass fieldInterface = clazz._interface(interfaceFQN.substring(interfaceFQN.lastIndexOf(46) + 1));
                fieldInterface._extends(Serializable.class);
            }
            catch (JClassAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
            this.annotateIfNotDone(clazz, ClassWithInterfaceFieldsDeserializer.class);
        }
    }

    private void annotateIfNotDone(JDefinedClass clazz, Class<? extends JsonDeserializer> deserializerClass) {
        if (!this.annotated.contains(clazz)) {
            clazz.annotate(JsonDeserialize.class).param("using", deserializerClass);
            this.annotated.add(clazz);
        }
    }

    static {
        String strict = System.getenv("ISTIO_STRICT");
        if ("true".equals(strict)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                String unvisitedCRDs = IstioSpecRegistry.unvisitedCRDNames();
                if (!unvisitedCRDs.isEmpty()) {
                    throw new IllegalStateException("The following CRDs were not visited:\n" + unvisitedCRDs);
                }
            }));
        }
    }
}

