/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.annotator;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;
import me.snowdrop.istio.api.internal.IstioSpecRegistry;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.internal.MixerTemplate;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;

public class IstioTypeAnnotator
extends Jackson2Annotator {
    private static final String BUILDER_PACKAGE = "io.fabric8.kubernetes.api.builder";
    private static final String DONEABLE_CLASS_NAME = "io.fabric8.kubernetes.api.model.Doneable";
    private static final String OBJECT_META_CLASS_NAME = "io.fabric8.kubernetes.api.model.ObjectMeta";
    private static final String IS_INTERFACE_FIELD = "isInterface";
    private static final String EXISTING_JAVA_TYPE_FIELD = "existingJavaType";
    public static final String INSTANCE_PARAMS_FQN = "me.snowdrop.istio.api.policy.v1beta1.InstanceParams";
    public static final String HANDLER_PARAMS_FQN = "me.snowdrop.istio.api.policy.v1beta1.HandlerParams";
    public static final String INSTANCE_SPEC_DESERIALIZER_FQN = "me.snowdrop.istio.api.policy.v1beta1.InstanceSpecDeserializer";
    public static final String HANDLER_SPEC_DESERIALIZER_FQN = "me.snowdrop.istio.api.policy.v1beta1.HandlerSpecDeserializer";
    public static final String SUPPORTED_TEMPLATES_FQN = "me.snowdrop.istio.api.policy.v1beta1.SupportedTemplates";
    public static final String SUPPORTED_ADAPTERS_FQN = "me.snowdrop.istio.api.policy.v1beta1.SupportedAdapters";
    private final JDefinedClass doneableClass;
    private final JDefinedClass objectMetaClass;
    private Set<JDefinedClass> annotated = new HashSet<JDefinedClass>();

    public IstioTypeAnnotator(GenerationConfig generationConfig) {
        super(generationConfig);
        String className = DONEABLE_CLASS_NAME;
        try {
            this.doneableClass = new JCodeModel()._class(className);
            className = OBJECT_META_CLASS_NAME;
            this.objectMetaClass = new JCodeModel()._class(className);
        }
        catch (JClassAlreadyExistsException e) {
            throw new IllegalStateException("Couldn't load " + className);
        }
    }

    public void typeInfo(JDefinedClass clazz, JsonNode node) {
        JsonNode adapter;
        super.typeInfo(clazz, node);
        JsonNode template = node.get("template");
        if (template != null) {
            clazz.annotate(MixerTemplate.class).param("compiledTemplate", template.textValue());
        }
        if ((adapter = node.get("adapter")) != null) {
            clazz.annotate(MixerAdapter.class).param("compiledAdapter", adapter.textValue());
        }
    }

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        int i;
        JAnnotationArrayMember annotationValue = clazz.annotate(JsonPropertyOrder.class).paramArray("value");
        annotationValue.param("apiVersion");
        annotationValue.param("kind");
        annotationValue.param("metadata");
        Iterator fields = propertiesNode.fields();
        block10: while (fields.hasNext()) {
            String key;
            Map.Entry entry = (Map.Entry)fields.next();
            switch (key = (String)entry.getKey()) {
                case "kind": 
                case "metadata": 
                case "apiVersion": {
                    continue block10;
                }
                case "deprecatedAllowOrigin": {
                    key = "allowOrigin";
                }
            }
            annotationValue.param(key);
        }
        JPackage pkg = clazz.getPackage();
        String pkgName = pkg.name();
        String version = pkgName.substring((i = pkgName.lastIndexOf(46)) + 1);
        if (version.startsWith("v")) {
            Optional kind = IstioSpecRegistry.getCRDInfo((String)clazz.name(), (String)version);
            kind.ifPresent(k -> {
                clazz._implements(IstioSpec.class);
                clazz.annotate(IstioKind.class).param("name", k.getKind()).param("plural", k.getPlural());
                clazz.annotate(IstioApiVersion.class).param("value", k.getAPIVersion());
            });
        }
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        JAnnotationUse buildable = clazz.annotate(Buildable.class).param("editableEnabled", false).param("generateBuilderPackage", true).param("builderPackage", BUILDER_PACKAGE);
        buildable.paramArray("inline").annotate(Inline.class).param("type", (JType)this.doneableClass).param("prefix", "Doneable").param("value", "done");
        buildable.paramArray("refs").annotate(BuildableReference.class).param("value", (JType)this.objectMetaClass);
        JClass instanceParamsClass = clazz.owner().directClass(INSTANCE_PARAMS_FQN);
        JClass instanceParamsDeserializer = clazz.owner().directClass(INSTANCE_SPEC_DESERIALIZER_FQN);
        this.handleMixerResourceSpec(clazz, instanceParamsClass, instanceParamsDeserializer, "InstanceSpec", SUPPORTED_TEMPLATES_FQN, "compiledTemplate");
        JClass handlerParamsClass = clazz.owner().directClass(HANDLER_PARAMS_FQN);
        JClass handlerParamsDeserializer = clazz.owner().directClass(HANDLER_SPEC_DESERIALIZER_FQN);
        this.handleMixerResourceSpec(clazz, handlerParamsClass, handlerParamsDeserializer, "HandlerSpec", SUPPORTED_ADAPTERS_FQN, "compiledAdapter");
        boolean isAdapter = this.isMixerRelated(clazz, pkgName, "mixer.adapter", "MixerAdapter");
        boolean isTemplate = this.isMixerRelated(clazz, pkgName, "mixer.template", "MixerTemplate");
        if (isAdapter || isTemplate) {
            if (isTemplate) {
                clazz._implements(instanceParamsClass);
            }
            if (isAdapter) {
                clazz._implements(handlerParamsClass);
            }
        } else if (clazz.name().endsWith("Spec")) {
            JAnnotationArrayMember arrayMember = clazz.annotate(VelocityTransformations.class).paramArray("value");
            arrayMember.annotate(VelocityTransformation.class).param("value", "/istio-resource.vm");
            arrayMember.annotate(VelocityTransformation.class).param("value", "/istio-resource-list.vm");
            arrayMember.annotate(VelocityTransformation.class).param("value", "/istio-manifest.vm").param("outputPath", "crd.properties").param("gather", true);
            arrayMember.annotate(VelocityTransformation.class).param("value", "/istio-mappings-provider.vm").param("outputPath", Paths.get("me", "snowdrop", "istio", "api", "model", "IstioResourceMappingsProvider.java").toString()).param("gather", true);
        }
    }

    public void handleMixerResourceSpec(JDefinedClass clazz, JClass paramsClass, JClass specDeserializerClass, String specClassName, String supportedResourcesEnumClass, String polymorphicTypeField) {
        if (clazz.name().contains(specClassName)) {
            this.changeFieldType(clazz, "params", paramsClass);
            clazz.annotate(JsonDeserialize.class).param("using", (JType)specDeserializerClass);
            JClass supported = clazz.owner().directClass(supportedResourcesEnumClass);
            this.changeFieldType(clazz, polymorphicTypeField, supported);
        }
    }

    private JFieldVar changeFieldType(JDefinedClass clazz, String field, JClass newType) {
        JFieldVar params = (JFieldVar)clazz.fields().get(field);
        clazz.removeField(params);
        JFieldVar newField = clazz.field(params.mods().getValue(), (JType)newType, params.name());
        String capitalizedField = field.substring(0, 1).toUpperCase() + field.substring(1);
        String getter = "get" + capitalizedField;
        String setter = "set" + capitalizedField;
        clazz.methods().removeIf(m -> m.name().equals(getter) || m.name().equals(setter));
        clazz.method(1, (JType)newType, getter).body()._return((JExpression)JExpr.refthis((String)field));
        JMethod setParams = clazz.method(1, (JType)clazz.owner().VOID, setter);
        setParams.param((JType)newType, field);
        setParams.body().assign((JAssignmentTarget)JExpr.refthis((String)field), JExpr.direct((String)field));
        return newField;
    }

    private boolean isMixerRelated(JDefinedClass clazz, String pkgName, String relevantPkgSubPath, String markerAnnotationName) {
        return pkgName.contains(relevantPkgSubPath) && clazz.annotations().stream().anyMatch(a -> a.getAnnotationClass().name().contains(markerAnnotationName));
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        propertyName = propertyName.equals("deprecatedAllowOrigin") ? "allowOrigin" : propertyName;
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.hasNonNull(IS_INTERFACE_FIELD)) {
            field.annotate(JsonUnwrapped.class);
            String interfaceFQN = propertyNode.get(EXISTING_JAVA_TYPE_FIELD).asText();
            try {
                JDefinedClass fieldInterface = clazz._interface(interfaceFQN.substring(interfaceFQN.lastIndexOf(46) + 1));
                fieldInterface._extends(Serializable.class);
            }
            catch (JClassAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
            this.annotateIfNotDone(clazz, ClassWithInterfaceFieldsDeserializer.class);
        }
    }

    public void propertyGetter(JMethod getter, JDefinedClass clazz, String propertyName) {
    }

    public void propertySetter(JMethod setter, JDefinedClass clazz, String propertyName) {
    }

    private void annotateIfNotDone(JDefinedClass clazz, Class<? extends JsonDeserializer> deserializerClass) {
        if (!this.annotated.contains(clazz)) {
            clazz.annotate(JsonDeserialize.class).param("using", deserializerClass);
            this.annotated.add(clazz);
        }
    }

    static {
        String strict = System.getenv("ISTIO_STRICT");
        if ("true".equals(strict)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                String unvisitedCRDs = IstioSpecRegistry.unvisitedCRDNames();
                if (!unvisitedCRDs.isEmpty()) {
                    throw new IllegalStateException("The following CRDs were not visited:\n" + unvisitedCRDs);
                }
            }));
        }
    }
}

