/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.toolbox.mongodb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import me.tfeng.toolbox.mongodb.MongoDbTypeConverter;
import me.tfeng.toolbox.mongodb.RecordConverter;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.Utf8;
import org.bson.types.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentDecoder
extends Decoder {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentDecoder.class);
    private static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    private final SpecificData data;
    private final Stack<Iterator<Object>> iteratorStack = new Stack();
    private final Stack<Schema> schemaStack = new Stack();

    public DocumentDecoder(Class<?> clazz, Object object) {
        try {
            this.data = new SpecificData(clazz.getClassLoader());
            this.pushToStacks(this.data.getSchema(clazz), object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to initialize decoder", iOException);
        }
    }

    public DocumentDecoder(Schema schema, Object object, ClassLoader classLoader) {
        try {
            this.data = new SpecificData(classLoader);
            this.pushToStacks(schema, object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to initialize decoder", iOException);
        }
    }

    public long arrayNext() throws IOException {
        try {
            if (this.iteratorStack.peek().hasNext()) {
                long l = 1L;
                return l;
            }
            this.popFromStacks();
            long l = 0L;
            return l;
        }
        finally {
            this.finishRead();
        }
    }

    public long mapNext() throws IOException {
        return this.arrayNext();
    }

    public long readArrayStart() throws IOException {
        this.jumpToNextField();
        return this.arrayNext();
    }

    public boolean readBoolean() throws IOException {
        this.jumpToNextField();
        try {
            boolean bl = (Boolean)this.iteratorStack.peek().next();
            return bl;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer readBytes(ByteBuffer byteBuffer) throws IOException {
        this.jumpToNextField();
        try {
            Object object = this.iteratorStack.peek().next();
            if (object == null) {
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            if (object instanceof Binary) {
                ByteBuffer byteBuffer3 = ByteBuffer.wrap(((Binary)object).getData());
                return byteBuffer3;
            }
            ByteBuffer byteBuffer4 = ByteBuffer.wrap((byte[])object);
            return byteBuffer4;
        }
        finally {
            this.finishRead();
        }
    }

    public double readDouble() throws IOException {
        this.jumpToNextField();
        try {
            double d = ((Number)this.iteratorStack.peek().next()).doubleValue();
            return d;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readEnum() throws IOException {
        this.jumpToNextField();
        try {
            String string = (String)this.iteratorStack.peek().next();
            Schema schema = this.schemaStack.peek();
            if (schema.getType() != Schema.Type.ENUM) {
                throw new IOException("Enum type is expected, but the current type is " + schema.getType());
            }
            int n = schema.getEnumSymbols().indexOf(string);
            if (n < 0) {
                throw new IOException(string + " is not a valid value in enum " + schema);
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.finishRead();
        }
    }

    public void readFixed(byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = this.readBytes(null);
        byte[] byArray2 = byteBuffer.array();
        if (byArray2.length != n2) {
            throw new IOException("Binary data of length " + n2 + " is expected; actual length is " + byArray2.length);
        }
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    public float readFloat() throws IOException {
        this.jumpToNextField();
        try {
            float f = ((Number)this.iteratorStack.peek().next()).floatValue();
            return f;
        }
        finally {
            this.finishRead();
        }
    }

    public int readIndex() throws IOException {
        this.jumpToNextField();
        Object object = this.iteratorStack.peek().next();
        Schema schema2 = this.schemaStack.peek();
        List list = schema2.getTypes();
        if (list.size() != 2 || !list.stream().anyMatch(schema -> schema.getType() == Schema.Type.NULL)) {
            throw new IOException("MongoDb module can only handle union of null and one other type; schema " + schema2 + " is not supported");
        }
        Schema schema3 = object == null ? (((Schema)list.get(0)).getType() == Schema.Type.NULL ? (Schema)list.get(0) : (Schema)list.get(1)) : (((Schema)list.get(0)).getType() != Schema.Type.NULL ? (Schema)list.get(0) : (Schema)list.get(1));
        this.pushToStacks(schema3, object);
        return schema3 == list.get(0) ? 0 : 1;
    }

    public int readInt() throws IOException {
        this.jumpToNextField();
        try {
            int n = ((Number)this.iteratorStack.peek().next()).intValue();
            return n;
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws IOException {
        this.jumpToNextField();
        try {
            Object object = this.iteratorStack.peek().next();
            if (object instanceof Number) {
                long l = ((Number)object).longValue();
                return l;
            }
            long l = MongoDbTypeConverter.convertFromMongoDbType(Long.class, object);
            return l;
        }
        finally {
            this.finishRead();
        }
    }

    public long readMapStart() throws IOException {
        this.jumpToNextField();
        return this.mapNext();
    }

    public void readNull() throws IOException {
        this.jumpToNextField();
        try {
            if (this.iteratorStack.peek().next() != null) {
                throw new IOException("Null value is expected");
            }
        }
        finally {
            this.finishRead();
        }
    }

    public String readString() throws IOException {
        this.jumpToNextField();
        try {
            String string = MongoDbTypeConverter.convertFromMongoDbType(String.class, this.iteratorStack.peek().next());
            return string;
        }
        finally {
            this.finishRead();
        }
    }

    public Utf8 readString(Utf8 utf8) throws IOException {
        String string = this.readString();
        return string == null ? null : (utf8 == null ? new Utf8(string) : utf8.set(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skipArray() throws IOException {
        long l = this.readArrayStart();
        try {
            Iterator<Object> iterator = this.iteratorStack.peek();
            while (l > 0L) {
                iterator.next();
                l = this.arrayNext();
            }
        }
        finally {
            this.finishRead();
        }
        return 0L;
    }

    public void skipBytes() throws IOException {
        this.jumpToNextField();
        try {
            this.iteratorStack.peek().next();
        }
        finally {
            this.finishRead();
        }
    }

    public void skipFixed(int n) throws IOException {
        this.jumpToNextField();
        try {
            this.iteratorStack.peek().next();
        }
        finally {
            this.finishRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skipMap() throws IOException {
        long l = this.readMapStart();
        try {
            Iterator<Object> iterator = this.iteratorStack.peek();
            while (l > 0L) {
                iterator.next();
                iterator.next();
                l = this.mapNext();
            }
        }
        finally {
            this.finishRead();
        }
        return 0L;
    }

    public void skipString() throws IOException {
        this.jumpToNextField();
        try {
            this.iteratorStack.peek().next();
        }
        finally {
            this.finishRead();
        }
    }

    private void finishRead() {
        Schema.Type type;
        while (!this.iteratorStack.isEmpty() && !this.iteratorStack.peek().hasNext() && (type = this.schemaStack.peek().getType()) != Schema.Type.ARRAY && type != Schema.Type.MAP) {
            this.popFromStacks();
        }
    }

    private void jumpToNextField() throws IOException {
        Schema schema = this.schemaStack.peek();
        switch (schema.getType()) {
            case ARRAY: {
                Iterator<Object> iterator = this.iteratorStack.peek();
                Schema schema2 = this.schemaStack.peek().getElementType();
                Schema.Type type = schema2.getType();
                if (iterator.hasNext()) {
                    this.pushToStacks(schema2, iterator.next());
                    if (type != Schema.Type.RECORD) break;
                    this.jumpToNextField();
                    break;
                }
                this.popFromStacks();
                this.jumpToNextField();
                break;
            }
            case MAP: {
                MapIterator mapIterator = (MapIterator)this.iteratorStack.peek();
                if (mapIterator.isNextKey()) {
                    this.pushToStacks(STRING_SCHEMA, this.iteratorStack.peek().next());
                    break;
                }
                Schema schema3 = this.schemaStack.peek().getValueType();
                Schema.Type type = schema3.getType();
                this.pushToStacks(schema3, this.iteratorStack.peek().next());
                if (type != Schema.Type.RECORD) break;
                this.jumpToNextField();
                break;
            }
            case RECORD: {
                RecordIterator recordIterator = (RecordIterator)this.iteratorStack.peek();
                if (recordIterator.hasNext()) {
                    Object object = recordIterator.next();
                    Schema.Field field = recordIterator.getCurrentField();
                    Schema.Type type = field.schema().getType();
                    this.pushToStacks(field.schema(), object);
                    if (type != Schema.Type.RECORD) break;
                    this.jumpToNextField();
                    break;
                }
                this.popFromStacks();
                this.jumpToNextField();
                break;
            }
        }
    }

    private void popFromStacks() {
        this.schemaStack.pop();
        this.iteratorStack.pop();
    }

    private void pushToStacks(Schema schema, Object object) throws IOException {
        switch (schema.getType()) {
            case ARRAY: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(((List)object).iterator());
                break;
            }
            case MAP: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(new MapIterator(object));
                break;
            }
            case RECORD: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(new RecordIterator(schema, object));
                break;
            }
            case UNION: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(Collections.singletonList(object).iterator());
                break;
            }
            default: {
                this.schemaStack.push(schema);
                this.iteratorStack.push(Collections.singletonList(object).iterator());
            }
        }
    }

    private class RecordIterator
    implements Iterator<Object> {
        private Schema.Field currentField;
        private final Iterator<Schema.Field> fieldIterator;
        private Map<String, String> fieldNameMap;
        private final Map<String, Object> map;

        public RecordIterator(Schema schema, Object object) {
            this.fieldIterator = schema.getFields().iterator();
            this.map = MongoDbTypeConverter.convertFromMongoDbType(Map.class, object);
            this.initializeFieldNameMap(schema);
        }

        public Schema.Field getCurrentField() {
            return this.currentField;
        }

        @Override
        public boolean hasNext() {
            return this.fieldIterator.hasNext();
        }

        @Override
        public Object next() {
            this.currentField = this.fieldIterator.next();
            String string = this.currentField.name();
            String string2 = this.fieldNameMap.get(string);
            return this.map.get(string2 == null ? string : string2);
        }

        private void initializeFieldNameMap(Schema schema) {
            Class clazz = DocumentDecoder.this.data.getClass(schema);
            if (clazz == null) {
                LOG.warn("Unable to load class " + SpecificData.getClassName((Schema)schema) + "; skipping java annotation processing");
                this.fieldNameMap = Collections.emptyMap();
            } else {
                List list = schema.getFields();
                this.fieldNameMap = new HashMap<String, String>(list.size());
                for (Schema.Field field : list) {
                    String string;
                    String string2 = field.name();
                    if (string2.equals(string = RecordConverter.getFieldName(field))) continue;
                    this.fieldNameMap.put(string2, string);
                }
            }
        }
    }

    private class MapIterator
    implements Iterator<Object> {
        private Map.Entry<String, Object> currentEntry;
        private final Iterator<Map.Entry<String, Object>> iterator;

        public MapIterator(Object object) {
            this.iterator = ((Map)object).entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentEntry != null || this.iterator.hasNext();
        }

        public boolean isNextKey() {
            return this.currentEntry == null;
        }

        @Override
        public Object next() {
            if (this.currentEntry == null) {
                this.currentEntry = this.iterator.next();
                return this.currentEntry.getKey();
            }
            Object object = this.currentEntry.getValue();
            this.currentEntry = null;
            return object;
        }
    }
}

