/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.toolbox.mongodb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.tfeng.toolbox.mongodb.DocumentDecoder;
import me.tfeng.toolbox.mongodb.MongoDbTypeConverter;
import me.tfeng.toolbox.mongodb.MongoType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.bson.BSONObject;
import org.bson.Document;
import org.bson.types.Binary;
import org.mortbay.util.ajax.JSON;

public class RecordConverter {
    public static final String MONGO_CLASS_PROPERTY = "mongo-class";
    public static final String MONGO_NAME_PROPERTY = "mongo-name";
    public static final String MONGO_TYPE_PROPERTY = "mongo-type";

    public static Document toDocument(IndexedRecord indexedRecord) {
        Document document = new Document();
        Schema schema = indexedRecord.getSchema();
        for (Schema.Field field : schema.getFields()) {
            Object object = indexedRecord.get(field.pos());
            if (object == null) continue;
            document.put(RecordConverter.getFieldName(field), RecordConverter.getDocument(field.schema(), object));
        }
        return document;
    }

    public static <T extends IndexedRecord> T toRecord(Class<T> clazz, BSONObject bSONObject) {
        SpecificDatumReader specificDatumReader = new SpecificDatumReader(clazz);
        try {
            DocumentDecoder documentDecoder = new DocumentDecoder(clazz, bSONObject);
            return (T)((IndexedRecord)specificDatumReader.read(null, (Decoder)documentDecoder));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to convert MongoDB object " + bSONObject + " into Avro record", iOException);
        }
    }

    public static <T extends IndexedRecord> T toRecord(Class<T> clazz, Document document) {
        SpecificDatumReader specificDatumReader = new SpecificDatumReader(clazz);
        try {
            DocumentDecoder documentDecoder = new DocumentDecoder(clazz, document);
            return (T)((IndexedRecord)specificDatumReader.read(null, (Decoder)documentDecoder));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to convert MongoDB document " + document + " into Avro record", iOException);
        }
    }

    public static GenericData.Record toRecord(Schema schema, BSONObject bSONObject, ClassLoader classLoader) throws IOException {
        GenericDatumReader genericDatumReader = new GenericDatumReader(schema);
        return (GenericData.Record)genericDatumReader.read(null, (Decoder)new DocumentDecoder(schema, bSONObject, classLoader));
    }

    public static GenericData.Record toRecord(Schema schema, Document document, ClassLoader classLoader) throws IOException {
        GenericDatumReader genericDatumReader = new GenericDatumReader(schema);
        return (GenericData.Record)genericDatumReader.read(null, (Decoder)new DocumentDecoder(schema, document, classLoader));
    }

    protected static String getFieldName(Schema.Field field) {
        String string = field.getProp(MONGO_NAME_PROPERTY);
        if (string != null) {
            return string;
        }
        return field.name();
    }

    private static Object getDocument(Schema schema, Object object) {
        if (schema.getType() == Schema.Type.UNION) {
            List list = schema.getTypes();
            if (list.size() != 2 && ((Schema)list.get(0)).getType() != Schema.Type.NULL && ((Schema)list.get(1)).getType() != Schema.Type.NULL) {
                throw new RuntimeException("In a union type, only null unioned with exactly one other type is supported: " + schema);
            }
            if (((Schema)list.get(0)).getType() == Schema.Type.NULL) {
                return RecordConverter.getDocument((Schema)list.get(1), object);
            }
            return RecordConverter.getDocument((Schema)list.get(0), object);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof IndexedRecord) {
            return RecordConverter.toDocument((IndexedRecord)object);
        }
        if (object instanceof Collection) {
            return RecordConverter.getDocuments(schema, (Collection)object);
        }
        if (object instanceof Map) {
            return RecordConverter.getDocuments(schema, (Map)object);
        }
        if (object instanceof ByteBuffer) {
            return new Binary(((ByteBuffer)object).array());
        }
        if (object.getClass().isEnum()) {
            return ((Enum)object).name();
        }
        String string = schema.getProp(MONGO_CLASS_PROPERTY);
        String string2 = schema.getProp(MONGO_TYPE_PROPERTY);
        if (object instanceof CharSequence) {
            object = object.toString();
        }
        if (string == null && string2 == null) {
            return object;
        }
        if (string != null && string2 != null) {
            throw new RuntimeException("mongo-class and mongo-type should not be both specified: " + schema);
        }
        try {
            Class<Object> clazz = string != null ? schema.getClass().getClassLoader().loadClass(string) : MongoType.valueOf(string2).getMongoClass();
            if (object instanceof String && clazz.isAssignableFrom(Object.class)) {
                return JSON.parse((String)((String)object));
            }
            return MongoDbTypeConverter.convertToMongoDbType(clazz, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unable to load mongo-class " + string, classNotFoundException);
        }
    }

    private static List<Object> getDocuments(Schema schema, Collection<Object> collection) {
        return collection.stream().map(object -> RecordConverter.getDocument(schema.getElementType(), object)).collect(Collectors.toList());
    }

    private static Map<String, Object> getDocuments(Schema schema, Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size());
        map.entrySet().forEach(entry -> hashMap.put((String)entry.getKey(), RecordConverter.getDocument(schema.getValueType(), entry.getValue())));
        return hashMap;
    }
}

