/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.Statement;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFacade;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;

public class SourceFileInfoExtractor {
    private TypeSolver typeSolver;
    private int ok = 0;
    private int ko = 0;
    private int unsupported = 0;
    private boolean printFileName = true;
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public void setPrintFileName(boolean printFileName) {
        this.printFileName = printFileName;
    }

    public void clear() {
        this.ok = 0;
        this.ko = 0;
        this.unsupported = 0;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public int getOk() {
        return this.ok;
    }

    public int getUnsupported() {
        return this.unsupported;
    }

    public int getKo() {
        return this.ko;
    }

    private void solveTypeDecl(ClassOrInterfaceDeclaration node) {
        TypeDeclaration typeDeclaration = JavaParserFacade.get(this.typeSolver).getTypeDeclaration(node);
        if (typeDeclaration.isClass()) {
            this.out.println("\n[ Class " + typeDeclaration.getQualifiedName() + " ]");
            for (ReferenceTypeUsage sc : typeDeclaration.asClass().getAllSuperClasses()) {
                this.out.println("  superclass: " + sc.getQualifiedName());
            }
            for (ReferenceTypeUsage sc : typeDeclaration.asClass().getAllInterfaces()) {
                this.out.println("  interface: " + sc.getQualifiedName());
            }
        }
    }

    private void solve(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            this.solveTypeDecl((ClassOrInterfaceDeclaration)node);
        } else if (!(!(node instanceof Expression) || node.getParentNode() instanceof ImportDeclaration || node.getParentNode() instanceof Expression || node.getParentNode() instanceof MethodDeclaration || node.getParentNode() instanceof PackageDeclaration || !(node.getParentNode() instanceof Statement) && !(node.getParentNode() instanceof VariableDeclarator))) {
            try {
                TypeUsage ref = JavaParserFacade.get(this.typeSolver).getType(node);
                this.out.println("  Line " + node.getBeginLine() + ") " + node + " ==> " + ref.describe());
                ++this.ok;
            }
            catch (UnsupportedOperationException upe) {
                ++this.unsupported;
                this.err.println(upe.getMessage());
                throw upe;
            }
            catch (RuntimeException re) {
                ++this.ko;
                this.err.println(re.getMessage());
                throw re;
            }
        }
        for (Node child : node.getChildrenNodes()) {
            this.solve(child);
        }
    }

    public void solve(File file) throws IOException, ParseException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.solve(f);
            }
        } else if (file.getName().endsWith(".java")) {
            if (this.printFileName) {
                this.out.println("- parsing " + file.getAbsolutePath());
            }
            CompilationUnit cu = JavaParser.parse((File)file);
            this.solve((Node)cu);
        }
    }

    public void setTypeSolver(TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
    }
}

