/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import java.util.Optional;

public final class Navigator {
    private Navigator() {
    }

    public static Optional<TypeDeclaration> findType(CompilationUnit cu, String name) {
        if (cu.getTypes() == null) {
            return Optional.empty();
        }
        return cu.getTypes().stream().filter(t -> t.getName().equals(name)).findFirst();
    }

    public static ClassOrInterfaceDeclaration demandClass(CompilationUnit cu, String name) {
        ClassOrInterfaceDeclaration cd = Navigator.demandClassOrInterface(cu, name);
        if (cd.isInterface()) {
            throw new IllegalStateException("Type is not a class");
        }
        return cd;
    }

    public static EnumDeclaration demandEnum(CompilationUnit cu, String name) {
        Optional<TypeDeclaration> res = Navigator.findType(cu, name);
        if (!res.isPresent()) {
            throw new IllegalStateException("No type found");
        }
        if (!(res.get() instanceof EnumDeclaration)) {
            throw new IllegalStateException("Type is not an enum");
        }
        return (EnumDeclaration)res.get();
    }

    public static MethodDeclaration demandMethod(ClassOrInterfaceDeclaration cd, String name) {
        MethodDeclaration found = null;
        for (BodyDeclaration bd : cd.getMembers()) {
            MethodDeclaration md;
            if (!(bd instanceof MethodDeclaration) || !(md = (MethodDeclaration)bd).getName().equals(name)) continue;
            if (found != null) {
                throw new IllegalStateException("Ambiguous getName");
            }
            found = md;
        }
        if (found == null) {
            throw new IllegalStateException("No method with given name");
        }
        return found;
    }

    public static VariableDeclarator demandField(ClassOrInterfaceDeclaration cd, String name) {
        for (BodyDeclaration bd : cd.getMembers()) {
            if (!(bd instanceof FieldDeclaration)) continue;
            FieldDeclaration fd = (FieldDeclaration)bd;
            for (VariableDeclarator vd : fd.getVariables()) {
                if (!vd.getId().getName().equals(name)) continue;
                return vd;
            }
        }
        throw new IllegalStateException("No field with given name");
    }

    public static NameExpr findNameExpression(Node node, String name) {
        NameExpr nameExpr;
        if (node instanceof NameExpr && (nameExpr = (NameExpr)node).getName().equals(name)) {
            return nameExpr;
        }
        for (Node child : node.getChildrenNodes()) {
            NameExpr res = Navigator.findNameExpression(child, name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static MethodCallExpr findMethodCall(Node node, String methodName) {
        MethodCallExpr methodCallExpr;
        if (node instanceof MethodCallExpr && (methodCallExpr = (MethodCallExpr)node).getName().equals(methodName)) {
            return methodCallExpr;
        }
        for (Node child : node.getChildrenNodes()) {
            MethodCallExpr res = Navigator.findMethodCall(child, methodName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static VariableDeclarator demandVariableDeclaration(Node node, String name) {
        VariableDeclarator variableDeclarator;
        if (node instanceof VariableDeclarator && (variableDeclarator = (VariableDeclarator)node).getId().getName().equals(name)) {
            return variableDeclarator;
        }
        for (Node child : node.getChildrenNodes()) {
            VariableDeclarator res = Navigator.demandVariableDeclaration(child, name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static ClassOrInterfaceDeclaration demandClassOrInterface(CompilationUnit compilationUnit, String name) {
        Optional<TypeDeclaration> res = Navigator.findType(compilationUnit, name);
        if (!res.isPresent()) {
            throw new IllegalStateException("No type named '" + name + "'found");
        }
        if (!(res.get() instanceof ClassOrInterfaceDeclaration)) {
            throw new IllegalStateException("Type is not a class or an interface, it is " + res.get().getClass().getCanonicalName());
        }
        ClassOrInterfaceDeclaration cd = (ClassOrInterfaceDeclaration)res.get();
        return cd;
    }

    public static SwitchStmt findSwitch(Node node) {
        SwitchStmt res = Navigator.findSwitchHelper(node);
        if (res == null) {
            throw new IllegalArgumentException();
        }
        return res;
    }

    private static SwitchStmt findSwitchHelper(Node node) {
        if (node instanceof SwitchStmt) {
            return (SwitchStmt)node;
        }
        for (Node child : node.getChildrenNodes()) {
            SwitchStmt resChild = Navigator.findSwitchHelper(child);
            if (resChild == null) continue;
            return resChild;
        }
        return null;
    }

    private static <N> N findNodeOfGivenClasshHelper(Node node, Class<N> clazz) {
        if (clazz.isInstance(node)) {
            return clazz.cast(node);
        }
        for (Node child : node.getChildrenNodes()) {
            N resChild = Navigator.findNodeOfGivenClasshHelper(child, clazz);
            if (resChild == null) continue;
            return resChild;
        }
        return null;
    }

    public static <N> N findNodeOfGivenClass(Node node, Class<N> clazz) {
        N res = Navigator.findNodeOfGivenClasshHelper(node, clazz);
        if (res == null) {
            throw new IllegalArgumentException();
        }
        return res;
    }

    public static ReturnStmt findReturnStmt(MethodDeclaration method) {
        return Navigator.findNodeOfGivenClass((Node)method, ReturnStmt.class);
    }
}

