/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javaparsermodel;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javaslang.Tuple2;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFactory;
import me.tomassetti.symbolsolver.javaparsermodel.LambdaArgumentTypeUsagePlaceholder;
import me.tomassetti.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserSymbolDeclaration;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserTypeVariableDeclaration;
import me.tomassetti.symbolsolver.logic.FunctionalInterfaceLogic;
import me.tomassetti.symbolsolver.logic.GenericTypeInferenceLogic;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.resolution.Value;
import me.tomassetti.symbolsolver.model.typesystem.ArrayTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.NullTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.PrimitiveTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeParameterUsage;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.VoidTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.WildcardUsage;
import me.tomassetti.symbolsolver.resolution.SymbolSolver;
import me.tomassetti.symbolsolver.resolution.typesolvers.JreTypeSolver;

public class JavaParserFacade {
    private static Logger logger = Logger.getLogger(JavaParserFacade.class.getCanonicalName());
    private static Map<TypeSolver, JavaParserFacade> instances;
    private TypeSolver typeSolver;
    private SymbolSolver symbolSolver;
    private Map<Node, TypeUsage> cacheWithLambdasSolved = new IdentityHashMap<Node, TypeUsage>();
    private Map<Node, TypeUsage> cacheWithoutLambadsSolved = new IdentityHashMap<Node, TypeUsage>();

    private JavaParserFacade(TypeSolver typeSolver) {
        this.typeSolver = typeSolver.getRoot();
        this.symbolSolver = new SymbolSolver(typeSolver);
    }

    public static JavaParserFacade get(TypeSolver typeSolver) {
        if (!instances.containsKey(typeSolver)) {
            instances.put(typeSolver, new JavaParserFacade(typeSolver));
        }
        return instances.get(typeSolver);
    }

    private static TypeUsage solveGenericTypes(TypeUsage typeUsage, Context context, TypeSolver typeSolver) {
        if (typeUsage.isTypeVariable()) {
            Optional solved = context.solveGenericType(typeUsage.describe(), typeSolver);
            if (solved.isPresent()) {
                return (TypeUsage)solved.get();
            }
            throw new UnsolvedSymbolException(context, typeUsage.describe());
        }
        if (typeUsage.isWildcard()) {
            if (typeUsage.asWildcard().isExtends() || typeUsage.asWildcard().isSuper()) {
                WildcardUsage wildcardUsage = typeUsage.asWildcard();
                TypeUsage boundResolved = JavaParserFacade.solveGenericTypes(wildcardUsage.getBoundedType(), context, typeSolver);
                if (wildcardUsage.isExtends()) {
                    return WildcardUsage.extendsBound((TypeUsage)boundResolved);
                }
                return WildcardUsage.superBound((TypeUsage)boundResolved);
            }
            return typeUsage;
        }
        TypeUsage result = typeUsage;
        int i = 0;
        if (result.isReferenceType()) {
            for (TypeUsage tp : typeUsage.asReferenceTypeUsage().parameters()) {
                result = result.asReferenceTypeUsage().replaceParam(i, JavaParserFacade.solveGenericTypes(tp, context, typeSolver));
                ++i;
            }
        }
        return result;
    }

    public SymbolReference<? extends ValueDeclaration> solve(NameExpr nameExpr) {
        return this.symbolSolver.solveSymbol(nameExpr.getName(), (Node)nameExpr);
    }

    public SymbolReference solve(Expression expr) {
        if (expr instanceof NameExpr) {
            return this.solve((NameExpr)expr);
        }
        throw new IllegalArgumentException(expr.getClass().getCanonicalName());
    }

    public SymbolReference<MethodDeclaration> solve(MethodCallExpr methodCallExpr) {
        LinkedList<TypeUsage> params = new LinkedList<TypeUsage>();
        LinkedList<LambdaArgumentTypeUsagePlaceholder> placeholders = new LinkedList<LambdaArgumentTypeUsagePlaceholder>();
        int i = 0;
        for (Expression expression : methodCallExpr.getArgs()) {
            if (expression instanceof LambdaExpr) {
                LambdaArgumentTypeUsagePlaceholder placeholder = new LambdaArgumentTypeUsagePlaceholder(i);
                params.add(placeholder);
                placeholders.add(placeholder);
            } else {
                params.add(JavaParserFacade.get(this.typeSolver).getType((Node)expression));
            }
            ++i;
        }
        SymbolReference res = JavaParserFactory.getContext((Node)methodCallExpr, this.typeSolver).solveMethod(methodCallExpr.getName(), params, this.typeSolver);
        for (LambdaArgumentTypeUsagePlaceholder placeholder : placeholders) {
            placeholder.setMethod((SymbolReference<MethodDeclaration>)res);
        }
        return res;
    }

    public TypeUsage getType(Node node) {
        return this.getType(node, true);
    }

    public TypeUsage getType(Node node, boolean solveLambdas) {
        if (solveLambdas) {
            if (!this.cacheWithLambdasSolved.containsKey(node)) {
                TypeUsage res = this.getTypeConcrete(node, solveLambdas);
                this.cacheWithLambdasSolved.put(node, res);
                boolean secondPassNecessary = false;
                if (node instanceof MethodCallExpr) {
                    MethodCallExpr methodCallExpr = (MethodCallExpr)node;
                    for (Node arg : methodCallExpr.getArgs()) {
                        if (this.cacheWithLambdasSolved.containsKey(arg)) continue;
                        this.getType(arg, true);
                        secondPassNecessary = true;
                    }
                }
                if (secondPassNecessary) {
                    this.cacheWithLambdasSolved.remove(node);
                    this.cacheWithLambdasSolved.put(node, this.getType(node, true));
                }
                logger.finer("getType on " + node + " -> " + res);
            }
            return this.cacheWithLambdasSolved.get(node);
        }
        Optional<TypeUsage> res = this.find(this.cacheWithLambdasSolved, node);
        if (res.isPresent()) {
            return res.get();
        }
        res = this.find(this.cacheWithoutLambadsSolved, node);
        if (!res.isPresent()) {
            TypeUsage resType = this.getTypeConcrete(node, solveLambdas);
            this.cacheWithoutLambadsSolved.put(node, resType);
            logger.finer("getType on " + node + " (no solveLambdas) -> " + res);
            return resType;
        }
        return res.get();
    }

    private Optional<TypeUsage> find(Map<Node, TypeUsage> map, Node node) {
        if (map.containsKey(node)) {
            return Optional.of(map.get(node));
        }
        if (node instanceof LambdaExpr) {
            return this.find(map, (LambdaExpr)node);
        }
        return Optional.empty();
    }

    private Optional<TypeUsage> find(Map<Node, TypeUsage> map, LambdaExpr lambdaExpr) {
        for (Node key : map.keySet()) {
            LambdaExpr keyLambdaExpr;
            if (!(key instanceof LambdaExpr) || !(keyLambdaExpr = (LambdaExpr)key).toString().equals(lambdaExpr.toString()) || keyLambdaExpr.getParentNode() != lambdaExpr.getParentNode()) continue;
            return Optional.of(map.get(keyLambdaExpr));
        }
        return Optional.empty();
    }

    private TypeUsage getTypeConcrete(Node node, boolean solveLambdas) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (node instanceof NameExpr) {
            NameExpr nameExpr = (NameExpr)node;
            logger.finest("getType on name expr " + node);
            Optional<Value> value = new SymbolSolver(this.typeSolver).solveSymbolAsValue(nameExpr.getName(), (Node)nameExpr);
            if (!value.isPresent()) {
                throw new UnsolvedSymbolException("FOO Solving " + node, nameExpr.getName());
            }
            return value.get().getUsage();
        }
        if (node instanceof MethodCallExpr) {
            logger.finest("getType on method call " + node);
            MethodUsage ref = this.solveMethodAsUsage((MethodCallExpr)node);
            logger.finest("getType on method call " + node + " resolved to " + ref);
            logger.finest("getType on method call " + node + " return type is " + ref.returnType());
            return ref.returnType();
        }
        if (node instanceof LambdaExpr) {
            if (node.getParentNode() instanceof MethodCallExpr) {
                MethodCallExpr callExpr = (MethodCallExpr)node.getParentNode();
                int pos = JavaParserSymbolDeclaration.getParamPos(node);
                SymbolReference<MethodDeclaration> refMethod = JavaParserFacade.get(this.typeSolver).solve(callExpr);
                if (!refMethod.isSolved()) {
                    throw new UnsolvedSymbolException(callExpr.getName());
                }
                logger.finest("getType on lambda expr " + ((MethodDeclaration)refMethod.getCorrespondingDeclaration()).getName());
                if (solveLambdas) {
                    TypeUsage result = ((MethodDeclaration)refMethod.getCorrespondingDeclaration()).getParam(pos).getType();
                    Context ctx = JavaParserFactory.getContext(node, this.typeSolver);
                    Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((TypeUsage)(result = JavaParserFacade.solveGenericTypes(result, ctx, this.typeSolver)));
                    if (functionalMethod.isPresent()) {
                        LambdaExpr lambdaExpr = (LambdaExpr)node;
                        ArrayList<Tuple2> formalActualTypePairs = new ArrayList<Tuple2>();
                        if (lambdaExpr.getBody() instanceof ExpressionStmt) {
                            ExpressionStmt expressionStmt = (ExpressionStmt)lambdaExpr.getBody();
                            TypeUsage actualType = this.getType((Node)expressionStmt.getExpression());
                            TypeUsage formalType = ((MethodUsage)functionalMethod.get()).returnType();
                            formalActualTypePairs.add(new Tuple2((Object)formalType, (Object)actualType));
                            Map inferredTypes = GenericTypeInferenceLogic.inferGenericTypes(formalActualTypePairs);
                            for (String typeName : inferredTypes.keySet()) {
                                result = result.replaceParam(typeName, (TypeUsage)inferredTypes.get(typeName));
                            }
                        } else {
                            throw new UnsupportedOperationException();
                        }
                    }
                    return result;
                }
                return ((MethodDeclaration)refMethod.getCorrespondingDeclaration()).getParam(pos).getType();
            }
            throw new UnsupportedOperationException("The type of a lambda expr depends on the position and its return value");
        }
        if (node instanceof VariableDeclarator) {
            if (node.getParentNode() instanceof FieldDeclaration) {
                FieldDeclaration parent = (FieldDeclaration)node.getParentNode();
                return JavaParserFacade.get(this.typeSolver).convertToUsage(parent.getType(), (Node)parent);
            }
            if (node.getParentNode() instanceof VariableDeclarationExpr) {
                VariableDeclarationExpr parent = (VariableDeclarationExpr)node.getParentNode();
                return JavaParserFacade.get(this.typeSolver).convertToUsage(parent.getType(), (Node)parent);
            }
            throw new UnsupportedOperationException(node.getParentNode().getClass().getCanonicalName());
        }
        if (node instanceof Parameter) {
            Parameter parameter = (Parameter)node;
            if (parameter.getType() instanceof UnknownType) {
                throw new IllegalStateException("Parameter has unknown type: " + parameter);
            }
            return JavaParserFacade.get(this.typeSolver).convertToUsage(parameter.getType(), (Node)parameter);
        }
        if (node instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)node;
            try {
                Optional<Value> value = new SymbolSolver(this.typeSolver).solveSymbolAsValue(fieldAccessExpr.getField(), (Node)fieldAccessExpr);
                if (value.isPresent()) {
                    return value.get().getUsage();
                }
                throw new UnsolvedSymbolException(fieldAccessExpr.getField());
            }
            catch (UnsolvedSymbolException e) {
                if (fieldAccessExpr.getScope() instanceof NameExpr) {
                    NameExpr staticValue = (NameExpr)fieldAccessExpr.getScope();
                    SymbolReference typeAccessedStatically = JavaParserFactory.getContext((Node)fieldAccessExpr, this.typeSolver).solveType(staticValue.toString(), this.typeSolver);
                    if (!typeAccessedStatically.isSolved()) {
                        throw e;
                    }
                    return ((TypeDeclaration)typeAccessedStatically.getCorrespondingDeclaration()).getField(fieldAccessExpr.getField()).getType();
                }
                throw e;
            }
        }
        if (node instanceof ObjectCreationExpr) {
            ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)node;
            TypeUsage typeUsage = JavaParserFacade.get(this.typeSolver).convertToUsage((Type)objectCreationExpr.getType(), node);
            return typeUsage;
        }
        if (node instanceof NullLiteralExpr) {
            return NullTypeUsage.INSTANCE;
        }
        if (node instanceof BooleanLiteralExpr) {
            return PrimitiveTypeUsage.BOOLEAN;
        }
        if (node instanceof IntegerLiteralExpr) {
            return PrimitiveTypeUsage.INT;
        }
        if (node instanceof LongLiteralExpr) {
            return PrimitiveTypeUsage.LONG;
        }
        if (node instanceof CharLiteralExpr) {
            return PrimitiveTypeUsage.CHAR;
        }
        if (node instanceof DoubleLiteralExpr) {
            return PrimitiveTypeUsage.DOUBLE;
        }
        if (node instanceof StringLiteralExpr) {
            return new ReferenceTypeUsageImpl(new JreTypeSolver().solveType("java.lang.String"), this.typeSolver);
        }
        if (node instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)node;
            switch (unaryExpr.getOperator()) {
                case negative: 
                case positive: {
                    return this.getTypeConcrete((Node)unaryExpr.getExpr(), solveLambdas);
                }
                case not: {
                    return PrimitiveTypeUsage.BOOLEAN;
                }
                case posIncrement: 
                case preIncrement: 
                case preDecrement: 
                case posDecrement: {
                    return this.getTypeConcrete((Node)unaryExpr.getExpr(), solveLambdas);
                }
            }
            throw new UnsupportedOperationException(unaryExpr.getOperator().name());
        }
        if (node instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)node;
            switch (binaryExpr.getOperator()) {
                case plus: 
                case minus: {
                    return this.getTypeConcrete((Node)binaryExpr.getLeft(), solveLambdas);
                }
                case lessEquals: 
                case less: 
                case greater: 
                case greaterEquals: 
                case equals: 
                case notEquals: 
                case or: 
                case and: {
                    return PrimitiveTypeUsage.BOOLEAN;
                }
                case binAnd: 
                case binOr: {
                    return this.getTypeConcrete((Node)binaryExpr.getLeft(), solveLambdas);
                }
            }
            throw new UnsupportedOperationException("FOO " + binaryExpr.getOperator().name());
        }
        if (node instanceof VariableDeclarationExpr) {
            VariableDeclarationExpr expr = (VariableDeclarationExpr)node;
            return this.convertToUsage(expr.getType(), JavaParserFactory.getContext(node, this.typeSolver));
        }
        if (node instanceof InstanceOfExpr) {
            return PrimitiveTypeUsage.BOOLEAN;
        }
        if (node instanceof EnclosedExpr) {
            EnclosedExpr enclosedExpr = (EnclosedExpr)node;
            return this.getTypeConcrete((Node)enclosedExpr.getInner(), solveLambdas);
        }
        if (node instanceof CastExpr) {
            CastExpr enclosedExpr = (CastExpr)node;
            return this.convertToUsage(enclosedExpr.getType(), JavaParserFactory.getContext(node, this.typeSolver));
        }
        if (node instanceof AssignExpr) {
            AssignExpr assignExpr = (AssignExpr)node;
            return this.getTypeConcrete((Node)assignExpr.getTarget(), solveLambdas);
        }
        if (node instanceof ThisExpr) {
            return new ReferenceTypeUsageImpl(this.getTypeDeclaration(this.findContainingTypeDecl(node)), this.typeSolver);
        }
        if (node instanceof ConditionalExpr) {
            ConditionalExpr conditionalExpr = (ConditionalExpr)node;
            return this.getTypeConcrete((Node)conditionalExpr.getThenExpr(), solveLambdas);
        }
        if (node instanceof ArrayCreationExpr) {
            ArrayCreationExpr arrayCreationExpr = (ArrayCreationExpr)node;
            TypeUsage res = this.convertToUsage(arrayCreationExpr.getType(), JavaParserFactory.getContext(node, this.typeSolver));
            for (int i = 0; i < arrayCreationExpr.getArrayCount(); ++i) {
                res = new ArrayTypeUsage(res);
            }
            return res;
        }
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    private com.github.javaparser.ast.body.TypeDeclaration findContainingTypeDecl(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            return (ClassOrInterfaceDeclaration)node;
        }
        if (node instanceof EnumDeclaration) {
            return (EnumDeclaration)node;
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException();
        }
        return this.findContainingTypeDecl(node.getParentNode());
    }

    public TypeUsage convertToUsage(Type type, Node context) {
        if (type instanceof UnknownType) {
            throw new IllegalArgumentException("Unknown type");
        }
        return this.convertToUsage(type, JavaParserFactory.getContext(context, this.typeSolver));
    }

    private String qName(ClassOrInterfaceType classOrInterfaceType) {
        String name = classOrInterfaceType.getName();
        if (classOrInterfaceType.getScope() != null) {
            return this.qName(classOrInterfaceType.getScope()) + "." + name;
        }
        return name;
    }

    public TypeUsage convertToUsage(Type type, Context context) {
        if (type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)type;
            TypeUsage typeUsage = this.convertToUsage(referenceType.getType(), context);
            for (int i = 0; i < referenceType.getArrayCount(); ++i) {
                typeUsage = new ArrayTypeUsage(typeUsage);
            }
            return typeUsage;
        }
        if (type instanceof ClassOrInterfaceType) {
            ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)type;
            String name = this.qName(classOrInterfaceType);
            SymbolReference ref = context.solveType(name, this.typeSolver);
            if (!ref.isSolved()) {
                throw new UnsolvedSymbolException(name);
            }
            TypeDeclaration typeDeclaration = (TypeDeclaration)ref.getCorrespondingDeclaration();
            List<Object> typeParameters = Collections.emptyList();
            if (classOrInterfaceType.getTypeArgs() != null) {
                typeParameters = classOrInterfaceType.getTypeArgs().stream().map(pt -> this.convertToUsage((Type)pt, context)).collect(Collectors.toList());
            }
            if (typeDeclaration.isTypeVariable()) {
                if (typeDeclaration instanceof TypeParameter) {
                    return new TypeParameterUsage((TypeParameter)typeDeclaration);
                }
                JavaParserTypeVariableDeclaration javaParserTypeVariableDeclaration = (JavaParserTypeVariableDeclaration)typeDeclaration;
                return new TypeParameterUsage(javaParserTypeVariableDeclaration.asTypeParameter());
            }
            return new ReferenceTypeUsageImpl(typeDeclaration, typeParameters, this.typeSolver);
        }
        if (type instanceof PrimitiveType) {
            return PrimitiveTypeUsage.byName((String)((PrimitiveType)type).getType().name());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getExtends() != null && wildcardType.getSuper() == null) {
                return WildcardUsage.extendsBound((TypeUsage)((ReferenceTypeUsageImpl)this.convertToUsage((Type)wildcardType.getExtends(), context)));
            }
            if (wildcardType.getExtends() == null && wildcardType.getSuper() != null) {
                return WildcardUsage.extendsBound((TypeUsage)((ReferenceTypeUsageImpl)this.convertToUsage((Type)wildcardType.getSuper(), context)));
            }
            if (wildcardType.getExtends() == null && wildcardType.getSuper() == null) {
                return WildcardUsage.UNBOUNDED;
            }
            throw new UnsupportedOperationException();
        }
        if (type instanceof VoidType) {
            return VoidTypeUsage.INSTANCE;
        }
        throw new UnsupportedOperationException(type.getClass().getCanonicalName());
    }

    public TypeUsage convert(Type type, Node node) {
        return this.convert(type, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public TypeUsage convert(Type type, Context context) {
        return this.convertToUsage(type, context);
    }

    public MethodUsage solveMethodAsUsage(MethodCallExpr call) {
        Context context;
        Optional methodUsage;
        ArrayList<TypeUsage> params = new ArrayList<TypeUsage>();
        if (call.getArgs() != null) {
            for (Expression param : call.getArgs()) {
                params.add(this.getType((Node)param, false));
            }
        }
        if (!(methodUsage = (context = JavaParserFactory.getContext((Node)call, this.typeSolver)).solveMethodAsUsage(call.getName(), params, this.typeSolver)).isPresent()) {
            throw new RuntimeException("Method '" + call.getName() + "' cannot be resolved in context " + call + " (line: " + call.getBeginLine() + ") " + context);
        }
        return (MethodUsage)methodUsage.get();
    }

    public TypeDeclaration getTypeDeclaration(ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        if (classOrInterfaceDeclaration.isInterface()) {
            return new JavaParserInterfaceDeclaration(classOrInterfaceDeclaration, this.typeSolver);
        }
        return new JavaParserClassDeclaration(classOrInterfaceDeclaration, this.typeSolver);
    }

    public TypeUsage getTypeOfThisIn(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            JavaParserClassDeclaration classDeclaration = new JavaParserClassDeclaration((ClassOrInterfaceDeclaration)node, this.typeSolver);
            return new ReferenceTypeUsageImpl((TypeDeclaration)classDeclaration, this.typeSolver);
        }
        return this.getTypeOfThisIn(node.getParentNode());
    }

    public TypeDeclaration getTypeDeclaration(com.github.javaparser.ast.body.TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof ClassOrInterfaceDeclaration) {
            return this.getTypeDeclaration((ClassOrInterfaceDeclaration)typeDeclaration);
        }
        if (typeDeclaration instanceof EnumDeclaration) {
            return new JavaParserEnumDeclaration((EnumDeclaration)typeDeclaration, this.typeSolver);
        }
        throw new UnsupportedOperationException(typeDeclaration.getClass().getCanonicalName());
    }

    static {
        logger.setLevel(Level.INFO);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.INFO);
        logger.addHandler(consoleHandler);
        instances = new HashMap<TypeSolver, JavaParserFacade>();
    }
}

