/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.util.Optional;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFactory;
import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.resolution.Value;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.resolution.SymbolDeclarator;

public abstract class AbstractJavaParserContext<N extends Node>
implements Context {
    protected N wrappedNode;
    protected TypeSolver typeSolver;

    public AbstractJavaParserContext(N wrappedNode, TypeSolver typeSolver) {
        if (wrappedNode == null) {
            throw new NullPointerException();
        }
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    protected static final SymbolReference<ValueDeclaration> solveWith(SymbolDeclarator symbolDeclarator, String name) {
        for (ValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            return SymbolReference.solved((Declaration)decl);
        }
        return SymbolReference.unsolved(ValueDeclaration.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJavaParserContext that = (AbstractJavaParserContext)o;
        return !(this.wrappedNode != null ? !this.wrappedNode.equals(that.wrappedNode) : that.wrappedNode != null);
    }

    public int hashCode() {
        return this.wrappedNode != null ? this.wrappedNode.hashCode() : 0;
    }

    public Optional<TypeUsage> solveGenericType(String name, TypeSolver typeSolver) {
        Context parent = this.getParent();
        if (parent == null) {
            return Optional.empty();
        }
        return parent.solveGenericType(name, typeSolver);
    }

    protected Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name, TypeSolver typeSolver) {
        for (ValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            return Optional.of(Value.from((ValueDeclaration)decl, (TypeSolver)typeSolver));
        }
        return Optional.empty();
    }

    public final Context getParent() {
        if (this.wrappedNode.getParentNode() instanceof MethodCallExpr) {
            MethodCallExpr parentCall = (MethodCallExpr)this.wrappedNode.getParentNode();
            boolean found = false;
            if (parentCall.getArgs() != null) {
                for (Expression expression : parentCall.getArgs()) {
                    if (expression != this.wrappedNode) continue;
                    found = true;
                }
            }
            if (found) {
                return JavaParserFactory.getContext(this.wrappedNode.getParentNode().getParentNode(), this.typeSolver);
            }
        }
        return JavaParserFactory.getContext(this.wrappedNode.getParentNode(), this.typeSolver);
    }
}

