/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javaslang.Tuple2;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFacade;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFactory;
import me.tomassetti.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import me.tomassetti.symbolsolver.logic.GenericTypeInferenceLogic;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.resolution.Value;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.resolution.SymbolDeclarator;

public class LambdaExprContext
extends AbstractJavaParserContext<LambdaExpr> {
    public LambdaExprContext(LambdaExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    public Optional<Value> solveSymbolAsValue(String name, TypeSolver typeSolver) {
        Iterator iterator = ((LambdaExpr)this.wrappedNode).getParameters().iterator();
        if (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator((Node)parameter, typeSolver);
            if (((LambdaExpr)this.wrappedNode).getParentNode() instanceof MethodCallExpr) {
                MethodCallExpr methodCallExpr = (MethodCallExpr)((LambdaExpr)this.wrappedNode).getParentNode();
                MethodUsage methodUsage = JavaParserFacade.get(typeSolver).solveMethodAsUsage(methodCallExpr);
                int i = this.pos(methodCallExpr, (Expression)this.wrappedNode);
                TypeUsage lambdaType = (TypeUsage)methodUsage.getParamTypes().get(i);
                Value value = new Value((TypeUsage)lambdaType.asReferenceTypeUsage().parameters().get(0), name, false);
                return Optional.of(value);
            }
            throw new UnsupportedOperationException();
        }
        return this.getParent().solveSymbolAsValue(name, typeSolver);
    }

    @Override
    public Optional<TypeUsage> solveGenericType(String name, TypeSolver typeSolver) {
        MethodCallExpr parentNode = (MethodCallExpr)((LambdaExpr)this.wrappedNode).getParentNode();
        int pos = this.pos(parentNode, (Expression)this.wrappedNode);
        MethodUsage methodUsage = JavaParserFacade.get(typeSolver).solveMethodAsUsage(parentNode);
        TypeUsage lambda = (TypeUsage)methodUsage.getParamTypes().get(pos);
        ArrayList<Tuple2> formalActualTypePairs = new ArrayList<Tuple2>();
        for (int i = 0; i < methodUsage.getDeclaration().getNoParams(); ++i) {
            formalActualTypePairs.add(new Tuple2((Object)methodUsage.getDeclaration().getParam(i).getType(), (Object)methodUsage.getParamType(i, typeSolver)));
        }
        Map map = GenericTypeInferenceLogic.inferGenericTypes(formalActualTypePairs);
        if (map.containsKey(name)) {
            return Optional.of(map.get(name));
        }
        return Optional.empty();
    }

    private int pos(MethodCallExpr callExpr, Expression param) {
        int i = 0;
        for (Expression p : callExpr.getArgs()) {
            if (p == param) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected final Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name, TypeSolver typeSolver) {
        for (ValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            throw new UnsupportedOperationException();
        }
        return Optional.empty();
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator((Node)parameter, typeSolver);
            SymbolReference<ValueDeclaration> symbolReference = LambdaExprContext.solveWith(sb, name);
            if (!symbolReference.isSolved()) continue;
            return symbolReference;
        }
        return this.getParent().solveSymbol(name, typeSolver);
    }

    public SymbolReference<TypeDeclaration> solveType(String name, TypeSolver typeSolver) {
        return this.getParent().solveType(name, typeSolver);
    }

    public SymbolReference<MethodDeclaration> solveMethod(String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver) {
        return this.getParent().solveMethod(name, parameterTypes, typeSolver);
    }
}

