/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFacade;
import me.tomassetti.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import me.tomassetti.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.resolution.Value;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeParameterUsage;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.WildcardUsage;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import me.tomassetti.symbolsolver.resolution.MethodResolutionLogic;

public class MethodCallExprContext
extends AbstractJavaParserContext<MethodCallExpr> {
    public MethodCallExprContext(MethodCallExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    @Override
    public Optional<TypeUsage> solveGenericType(String name, TypeSolver typeSolver) {
        if (!((MethodCallExpr)this.wrappedNode).getTypeArgs().isEmpty()) {
            throw new UnsupportedOperationException(name);
        }
        TypeUsage typeOfScope = JavaParserFacade.get(typeSolver).getType((Node)((MethodCallExpr)this.wrappedNode).getScope());
        return typeOfScope.asReferenceTypeUsage().getGenericParameterByName(name);
    }

    private Optional<MethodUsage> solveMethodAsUsage(ReferenceTypeUsage refType, String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver, Context invokationContext) {
        Optional ref = refType.getTypeDeclaration().solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, refType.parameters());
        if (ref.isPresent()) {
            MethodUsage methodUsage = (MethodUsage)ref.get();
            TypeUsage returnType = refType.replaceTypeParams(methodUsage.returnType());
            if (returnType != methodUsage.returnType()) {
                methodUsage = methodUsage.replaceReturnType(returnType);
            }
            for (int i = 0; i < methodUsage.getParamTypes().size(); ++i) {
                TypeUsage replaced = refType.replaceTypeParams((TypeUsage)methodUsage.getParamTypes().get(i));
                methodUsage = methodUsage.replaceParamType(i, replaced);
            }
            return Optional.of(methodUsage);
        }
        return ref;
    }

    private MethodUsage resolveMethodTypeParameters(MethodUsage methodUsage, List<TypeUsage> actualParamTypes) {
        if (methodUsage.getDeclaration().hasVariadicParameter()) {
            if (actualParamTypes.size() == methodUsage.getDeclaration().getNoParams()) {
                TypeUsage actualType;
                TypeUsage expectedType = methodUsage.getDeclaration().getLastParam().getType();
                if (!expectedType.isAssignableBy(actualType = actualParamTypes.get(actualParamTypes.size() - 1))) {
                    for (TypeParameter tp : methodUsage.getDeclaration().getTypeParameters()) {
                        expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, this.typeSolver);
                    }
                }
                if (!expectedType.isAssignableBy(actualType)) {
                    throw new UnsupportedOperationException();
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
        HashMap<String, TypeUsage> matchedTypeParameters = new HashMap<String, TypeUsage>();
        for (int i = 0; i < actualParamTypes.size(); ++i) {
            TypeUsage expectedType = methodUsage.getParamType(i, this.typeSolver);
            TypeUsage actualType = actualParamTypes.get(i);
            this.matchTypeParameters(expectedType, actualType, matchedTypeParameters);
        }
        for (String tp : matchedTypeParameters.keySet()) {
            methodUsage = methodUsage.replaceNameParam(tp, (TypeUsage)matchedTypeParameters.get(tp));
        }
        return methodUsage;
    }

    private void matchTypeParameters(TypeUsage expectedType, TypeUsage actualType, Map<String, TypeUsage> matchedTypeParameters) {
        if (expectedType.isTypeVariable()) {
            if (!expectedType.isTypeVariable()) {
                throw new UnsupportedOperationException(actualType.getClass().getCanonicalName());
            }
            matchedTypeParameters.put(expectedType.asTypeParameter().getName(), actualType);
        } else if (expectedType.isArray()) {
            if (!actualType.isArray()) {
                throw new UnsupportedOperationException(actualType.getClass().getCanonicalName());
            }
            this.matchTypeParameters(expectedType.asArrayTypeUsage().getComponentType(), actualType.asArrayTypeUsage().getComponentType(), matchedTypeParameters);
        } else if (expectedType.isReferenceType()) {
            int i = 0;
            for (TypeUsage tp : expectedType.asReferenceTypeUsage().parameters()) {
                this.matchTypeParameters(tp, (TypeUsage)actualType.asReferenceTypeUsage().parameters().get(i), matchedTypeParameters);
                ++i;
            }
        } else if (!expectedType.isPrimitive() && !expectedType.isWildcard()) {
            throw new UnsupportedOperationException(expectedType.getClass().getCanonicalName());
        }
    }

    public String toString() {
        return "MethodCallExprContext{}";
    }

    private Optional<MethodUsage> solveMethodAsUsage(TypeParameterUsage tp, String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver, Context invokationContext) {
        for (TypeParameter.Bound bound : tp.asTypeParameter().getBounds(typeSolver)) {
            Optional<MethodUsage> methodUsage = this.solveMethodAsUsage(bound.getType(), name, parameterTypes, typeSolver, invokationContext);
            if (!methodUsage.isPresent()) continue;
            return methodUsage;
        }
        return Optional.empty();
    }

    private Optional<MethodUsage> solveMethodAsUsage(TypeUsage typeUsage, String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver, Context invokationContext) {
        if (typeUsage instanceof ReferenceTypeUsage) {
            return this.solveMethodAsUsage((ReferenceTypeUsage)typeUsage, name, parameterTypes, typeSolver, invokationContext);
        }
        if (typeUsage instanceof TypeParameterUsage) {
            return this.solveMethodAsUsage((TypeParameterUsage)typeUsage, name, parameterTypes, typeSolver, invokationContext);
        }
        if (typeUsage instanceof WildcardUsage) {
            WildcardUsage wildcardUsage = (WildcardUsage)typeUsage;
            if (wildcardUsage.isSuper()) {
                return this.solveMethodAsUsage(wildcardUsage.getBoundedType(), name, parameterTypes, typeSolver, invokationContext);
            }
            if (wildcardUsage.isExtends()) {
                throw new UnsupportedOperationException("extends wildcard");
            }
            throw new UnsupportedOperationException("unbounded wildcard");
        }
        throw new UnsupportedOperationException("type usage: " + typeUsage.getClass().getCanonicalName());
    }

    public Optional<MethodUsage> solveMethodAsUsage(String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver) {
        MethodCallExpr parent;
        if (((MethodCallExpr)this.wrappedNode).getScope() != null) {
            try {
                TypeUsage typeOfScope = JavaParserFacade.get(typeSolver).getType((Node)((MethodCallExpr)this.wrappedNode).getScope());
                return this.solveMethodAsUsage(typeOfScope, name, parameterTypes, typeSolver, (Context)this);
            }
            catch (UnsolvedSymbolException e) {
                if (((MethodCallExpr)this.wrappedNode).getScope() instanceof NameExpr) {
                    String className = ((NameExpr)((MethodCallExpr)this.wrappedNode).getScope()).getName();
                    SymbolReference ref = this.solveType(className, typeSolver);
                    if (ref.isSolved()) {
                        SymbolReference m = ((TypeDeclaration)ref.getCorrespondingDeclaration()).solveMethod(name, parameterTypes);
                        if (m.isSolved()) {
                            MethodUsage methodUsage = new MethodUsage((MethodDeclaration)m.getCorrespondingDeclaration(), typeSolver);
                            methodUsage = this.resolveMethodTypeParameters(methodUsage, parameterTypes);
                            return Optional.of(methodUsage);
                        }
                        throw new UnsolvedSymbolException(((TypeDeclaration)ref.getCorrespondingDeclaration()).toString(), "Method '" + name + "' with parameterTypes " + parameterTypes);
                    }
                    throw e;
                }
                throw e;
            }
        }
        if (((MethodCallExpr)this.wrappedNode).getParentNode() instanceof MethodCallExpr && (parent = (MethodCallExpr)((MethodCallExpr)this.wrappedNode).getParentNode()).getScope() == this.wrappedNode) {
            return this.getParent().getParent().solveMethodAsUsage(name, parameterTypes, typeSolver);
        }
        Context parentContext = this.getParent();
        return parentContext.solveMethodAsUsage(name, parameterTypes, typeSolver);
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        return this.getParent().solveSymbol(name, typeSolver);
    }

    public Optional<Value> solveSymbolAsValue(String name, TypeSolver typeSolver) {
        Context parentContext = this.getParent();
        return parentContext.solveSymbolAsValue(name, typeSolver);
    }

    public SymbolReference<MethodDeclaration> solveMethod(String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver) {
        if (((MethodCallExpr)this.wrappedNode).getScope() != null) {
            TypeUsage typeOfScope = JavaParserFacade.get(typeSolver).getType((Node)((MethodCallExpr)this.wrappedNode).getScope());
            if (typeOfScope.isWildcard()) {
                if (typeOfScope.asWildcard().isExtends() || typeOfScope.asWildcard().isSuper()) {
                    return typeOfScope.asWildcard().getBoundedType().asReferenceTypeUsage().solveMethod(name, parameterTypes);
                }
                return new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionClassDeclaration(Object.class, typeSolver), typeSolver).solveMethod(name, parameterTypes);
            }
            return typeOfScope.asReferenceTypeUsage().solveMethod(name, parameterTypes);
        }
        TypeUsage typeOfScope = JavaParserFacade.get(typeSolver).getTypeOfThisIn(this.wrappedNode);
        return typeOfScope.asReferenceTypeUsage().solveMethod(name, parameterTypes);
    }
}

