/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFactory;
import me.tomassetti.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserTypeVariableDeclaration;
import me.tomassetti.symbolsolver.logic.AbstractTypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.declarations.FieldDeclaration;
import me.tomassetti.symbolsolver.model.declarations.InterfaceDeclaration;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.resolution.SymbolSolver;

public class JavaParserInterfaceDeclaration
extends AbstractTypeDeclaration
implements InterfaceDeclaration {
    private TypeSolver typeSolver;
    private ClassOrInterfaceDeclaration wrappedNode;

    public JavaParserInterfaceDeclaration(ClassOrInterfaceDeclaration wrappedNode, TypeSolver typeSolver) {
        if (!wrappedNode.isInterface()) {
            throw new IllegalArgumentException();
        }
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    public SymbolReference<MethodDeclaration> solveMethod(String name, List<TypeUsage> parameterTypes) {
        return this.getContext().solveMethod(name, parameterTypes, this.typeSolver());
    }

    public Set<MethodDeclaration> getDeclaredMethods() {
        throw new UnsupportedOperationException();
    }

    public Context getContext() {
        return JavaParserFactory.getContext((Node)this.wrappedNode, this.typeSolver);
    }

    public TypeUsage getUsage(Node node) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaParserInterfaceDeclaration that = (JavaParserInterfaceDeclaration)((Object)o);
        return this.wrappedNode.equals((Object)that.wrappedNode);
    }

    public int hashCode() {
        return this.wrappedNode.hashCode();
    }

    public String getName() {
        return this.wrappedNode.getName();
    }

    public InterfaceDeclaration asInterface() {
        return this;
    }

    public boolean isInterface() {
        return true;
    }

    public List<InterfaceDeclaration> getInterfacesExtended() {
        ArrayList<InterfaceDeclaration> interfaces = new ArrayList<InterfaceDeclaration>();
        if (this.wrappedNode.getImplements() != null) {
            for (ClassOrInterfaceType t : this.wrappedNode.getImplements()) {
                interfaces.add(((me.tomassetti.symbolsolver.model.declarations.TypeDeclaration)this.solveType(t.getName(), this.typeSolver).getCorrespondingDeclaration()).asInterface());
            }
        }
        return interfaces;
    }

    public String getQualifiedName() {
        String containerName = this.containerName("", this.wrappedNode.getParentNode());
        if (containerName.isEmpty()) {
            return this.wrappedNode.getName();
        }
        return containerName + "." + this.wrappedNode.getName();
    }

    public boolean isAssignableBy(me.tomassetti.symbolsolver.model.declarations.TypeDeclaration other) {
        List ancestorsOfOther = other.getAllAncestors();
        ancestorsOfOther.add(new ReferenceTypeUsageImpl(other, this.typeSolver));
        for (ReferenceTypeUsage ancestorOfOther : ancestorsOfOther) {
            if (!ancestorOfOther.getQualifiedName().equals(this.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private String containerName(String base, Node container) {
        if (container instanceof ClassOrInterfaceDeclaration) {
            String b = this.containerName(base, container.getParentNode());
            String cn = ((ClassOrInterfaceDeclaration)container).getName();
            if (b.isEmpty()) {
                return cn;
            }
            return b + "." + cn;
        }
        if (container instanceof CompilationUnit) {
            PackageDeclaration p = ((CompilationUnit)container).getPackage();
            if (p != null) {
                String b = p.getName().toString();
                if (base.isEmpty()) {
                    return b;
                }
                return b + "." + base;
            }
            return base;
        }
        if (container != null) {
            return this.containerName(base, container.getParentNode());
        }
        return base;
    }

    public boolean isAssignableBy(TypeUsage typeUsage) {
        if (typeUsage.isNull()) {
            return true;
        }
        if (typeUsage.isReferenceType()) {
            me.tomassetti.symbolsolver.model.declarations.TypeDeclaration other = this.typeSolver.solveType(typeUsage.describe());
            return this.isAssignableBy(other);
        }
        throw new UnsupportedOperationException();
    }

    public boolean canBeAssignedTo(me.tomassetti.symbolsolver.model.declarations.TypeDeclaration other) {
        me.tomassetti.symbolsolver.model.declarations.TypeDeclaration ancestor;
        if (this.getQualifiedName().equals(other.getQualifiedName())) {
            return true;
        }
        if (this.wrappedNode.getExtends() != null) {
            for (ClassOrInterfaceType type : this.wrappedNode.getExtends()) {
                ancestor = new SymbolSolver(this.typeSolver).solveType((Type)type);
                if (!ancestor.canBeAssignedTo(other)) continue;
                return true;
            }
        }
        if (this.wrappedNode.getImplements() != null) {
            for (ClassOrInterfaceType type : this.wrappedNode.getImplements()) {
                ancestor = new SymbolSolver(this.typeSolver).solveType((Type)type);
                if (!ancestor.canBeAssignedTo(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public FieldDeclaration getField(String name) {
        for (BodyDeclaration member : this.wrappedNode.getMembers()) {
            if (!(member instanceof com.github.javaparser.ast.body.FieldDeclaration)) continue;
            com.github.javaparser.ast.body.FieldDeclaration field = (com.github.javaparser.ast.body.FieldDeclaration)member;
            for (VariableDeclarator vd : field.getVariables()) {
                if (!vd.getId().getName().equals(name)) continue;
                return new JavaParserFieldDeclaration(vd, this.typeSolver);
            }
        }
        throw new UnsupportedOperationException("Derived fields");
    }

    public List<FieldDeclaration> getAllFields() {
        ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
        for (BodyDeclaration member : this.wrappedNode.getMembers()) {
            if (!(member instanceof com.github.javaparser.ast.body.FieldDeclaration)) continue;
            com.github.javaparser.ast.body.FieldDeclaration field = (com.github.javaparser.ast.body.FieldDeclaration)member;
            for (VariableDeclarator vd : field.getVariables()) {
                fields.add(new JavaParserFieldDeclaration(vd, this.typeSolver));
            }
        }
        return fields;
    }

    public String toString() {
        return "JavaParserInterfaceDeclaration{wrappedNode=" + this.wrappedNode + '}';
    }

    public boolean hasField(String name) {
        for (BodyDeclaration member : this.wrappedNode.getMembers()) {
            if (!(member instanceof com.github.javaparser.ast.body.FieldDeclaration)) continue;
            com.github.javaparser.ast.body.FieldDeclaration field = (com.github.javaparser.ast.body.FieldDeclaration)member;
            for (VariableDeclarator vd : field.getVariables()) {
                if (!vd.getId().getName().equals(name)) continue;
                return true;
            }
        }
        throw new UnsupportedOperationException("Derived fields");
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String substring, TypeSolver typeSolver) {
        throw new UnsupportedOperationException();
    }

    public SymbolReference<me.tomassetti.symbolsolver.model.declarations.TypeDeclaration> solveType(String name, TypeSolver typeSolver) {
        if (this.wrappedNode.getName().equals(name)) {
            return SymbolReference.solved((Declaration)this);
        }
        if (this.wrappedNode.getTypeParameters() != null) {
            for (TypeParameter typeParameter : this.wrappedNode.getTypeParameters()) {
                if (!typeParameter.getName().equals(name)) continue;
                return SymbolReference.solved((Declaration)new JavaParserTypeVariableDeclaration(typeParameter, typeSolver));
            }
        }
        for (BodyDeclaration member : this.wrappedNode.getMembers()) {
            if (!(member instanceof TypeDeclaration)) continue;
            TypeDeclaration internalType = (TypeDeclaration)member;
            String prefix = internalType.getName() + ".";
            if (internalType.getName().equals(name)) {
                if (internalType instanceof ClassOrInterfaceDeclaration) {
                    return SymbolReference.solved((Declaration)new JavaParserInterfaceDeclaration((ClassOrInterfaceDeclaration)internalType, typeSolver));
                }
                if (internalType instanceof EnumDeclaration) {
                    return SymbolReference.solved((Declaration)new JavaParserEnumDeclaration((EnumDeclaration)internalType, typeSolver));
                }
                throw new UnsupportedOperationException();
            }
            if (!name.startsWith(prefix) || name.length() <= prefix.length()) continue;
            if (internalType instanceof ClassOrInterfaceDeclaration) {
                return new JavaParserInterfaceDeclaration((ClassOrInterfaceDeclaration)internalType, typeSolver).solveType(name.substring(prefix.length()), typeSolver);
            }
            if (internalType instanceof EnumDeclaration) {
                return new JavaParserEnumDeclaration((EnumDeclaration)internalType, typeSolver).solveType(name.substring(prefix.length()), typeSolver);
            }
            throw new UnsupportedOperationException();
        }
        String prefix = this.wrappedNode.getName() + ".";
        if (name.startsWith(prefix) && name.length() > prefix.length()) {
            return new JavaParserInterfaceDeclaration(this.wrappedNode, typeSolver).solveType(name.substring(prefix.length()), typeSolver);
        }
        return SymbolReference.unsolved(me.tomassetti.symbolsolver.model.declarations.TypeDeclaration.class);
    }

    public List<ReferenceTypeUsage> getAllAncestors() {
        SymbolReference<me.tomassetti.symbolsolver.model.declarations.TypeDeclaration> superclass;
        ArrayList<ReferenceTypeUsage> ancestors = new ArrayList<ReferenceTypeUsage>();
        if (this.wrappedNode.getExtends() != null) {
            for (ClassOrInterfaceType extended : this.wrappedNode.getExtends()) {
                superclass = this.solveType(extended.getName(), this.typeSolver);
                if (!superclass.isSolved()) {
                    throw new UnsolvedSymbolException(extended.getName());
                }
                ancestors.add(new ReferenceTypeUsageImpl((me.tomassetti.symbolsolver.model.declarations.TypeDeclaration)superclass.getCorrespondingDeclaration(), this.typeSolver));
                ancestors.addAll(((me.tomassetti.symbolsolver.model.declarations.TypeDeclaration)superclass.getCorrespondingDeclaration()).getAllAncestors());
            }
        }
        if (this.wrappedNode.getImplements() != null) {
            for (ClassOrInterfaceType implemented : this.wrappedNode.getImplements()) {
                superclass = this.solveType(implemented.getName(), this.typeSolver);
                if (!superclass.isSolved()) {
                    throw new UnsolvedSymbolException(implemented.getName());
                }
                ancestors.add(new ReferenceTypeUsageImpl((me.tomassetti.symbolsolver.model.declarations.TypeDeclaration)superclass.getCorrespondingDeclaration(), this.typeSolver));
                ancestors.addAll(((me.tomassetti.symbolsolver.model.declarations.TypeDeclaration)superclass.getCorrespondingDeclaration()).getAllAncestors());
            }
        }
        return ancestors;
    }

    public List<me.tomassetti.symbolsolver.model.resolution.TypeParameter> getTypeParameters() {
        if (this.wrappedNode.getTypeParameters() == null) {
            return Collections.emptyList();
        }
        return this.wrappedNode.getTypeParameters().stream().map(tp -> new JavaParserTypeParameter((TypeParameter)tp, this.typeSolver)).collect(Collectors.toList());
    }

    protected TypeSolver typeSolver() {
        return this.typeSolver;
    }

    public ClassOrInterfaceDeclaration getWrappedNode() {
        return this.wrappedNode;
    }
}

