/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFacade;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFactory;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserParameterDeclaration;
import me.tomassetti.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import me.tomassetti.symbolsolver.model.declarations.ParameterDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.WildcardUsage;

public class JavaParserMethodDeclaration
implements me.tomassetti.symbolsolver.model.declarations.MethodDeclaration {
    private MethodDeclaration wrappedNode;
    private TypeSolver typeSolver;

    public JavaParserMethodDeclaration(MethodDeclaration wrappedNode, TypeSolver typeSolver) {
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    public String toString() {
        return "JavaParserMethodDeclaration{wrappedNode=" + this.wrappedNode + ", typeSolver=" + this.typeSolver + '}';
    }

    public TypeDeclaration declaringType() {
        if (this.wrappedNode.getParentNode() instanceof ClassOrInterfaceDeclaration) {
            return new JavaParserClassDeclaration((ClassOrInterfaceDeclaration)this.wrappedNode.getParentNode(), this.typeSolver);
        }
        throw new UnsupportedOperationException();
    }

    public TypeUsage getReturnType() {
        return JavaParserFacade.get(this.typeSolver).convert(this.wrappedNode.getType(), this.getContext());
    }

    public int getNoParams() {
        if (this.wrappedNode.getParameters() == null) {
            return 0;
        }
        return this.wrappedNode.getParameters().size();
    }

    public ParameterDeclaration getParam(int i) {
        return new JavaParserParameterDeclaration((Parameter)this.wrappedNode.getParameters().get(i), this.typeSolver);
    }

    public MethodUsage getUsage(Node node) {
        throw new UnsupportedOperationException();
    }

    public MethodUsage resolveTypeVariables(Context context, List<TypeUsage> parameterTypes) {
        TypeUsage returnType = this.replaceTypeParams(new JavaParserMethodDeclaration(this.wrappedNode, this.typeSolver).getReturnType(), this.typeSolver, context);
        ArrayList<TypeUsage> params = new ArrayList<TypeUsage>();
        for (int i = 0; i < this.wrappedNode.getParameters().size(); ++i) {
            TypeUsage replaced = this.replaceTypeParams(new JavaParserMethodDeclaration(this.wrappedNode, this.typeSolver).getParam(i).getType(), this.typeSolver, context);
            params.add(replaced);
        }
        HashMap<String, TypeUsage> determinedTypeParameters = new HashMap<String, TypeUsage>();
        for (int i = 0; i < this.getNoParams(); ++i) {
            TypeUsage formalParamType = this.getParam(i).getType();
            TypeUsage actualParamType = parameterTypes.get(i);
            this.determineTypeParameters(determinedTypeParameters, formalParamType, actualParamType, this.typeSolver);
        }
        for (String determinedParam : determinedTypeParameters.keySet()) {
            returnType = returnType.replaceParam(determinedParam, (TypeUsage)determinedTypeParameters.get(determinedParam));
        }
        return new MethodUsage((me.tomassetti.symbolsolver.model.declarations.MethodDeclaration)new JavaParserMethodDeclaration(this.wrappedNode, this.typeSolver), params, returnType);
    }

    private void determineTypeParameters(Map<String, TypeUsage> determinedTypeParameters, TypeUsage formalParamType, TypeUsage actualParamType, TypeSolver typeSolver) {
        if (actualParamType.isNull()) {
            return;
        }
        if (actualParamType.isTypeVariable()) {
            return;
        }
        if (formalParamType.isTypeVariable()) {
            determinedTypeParameters.put(formalParamType.describe(), actualParamType);
            return;
        }
        if (formalParamType instanceof WildcardUsage) {
            return;
        }
        if (formalParamType.isReferenceType() && actualParamType.isReferenceType() && !formalParamType.asReferenceTypeUsage().getQualifiedName().equals(actualParamType.asReferenceTypeUsage().getQualifiedName())) {
            List ancestors = actualParamType.asReferenceTypeUsage().getAllAncestors();
            String formalParamTypeQName = formalParamType.asReferenceTypeUsage().getQualifiedName();
            List correspondingFormalType = ancestors.stream().filter(a -> a.getQualifiedName().equals(formalParamTypeQName)).collect(Collectors.toList());
            if (correspondingFormalType.isEmpty()) {
                throw new IllegalArgumentException();
            }
            actualParamType = (TypeUsage)correspondingFormalType.get(0);
        }
        if (formalParamType.isReferenceType() && actualParamType.isReferenceType()) {
            List formalTypeParams = formalParamType.asReferenceTypeUsage().parameters();
            List actualTypeParams = actualParamType.asReferenceTypeUsage().parameters();
            if (formalTypeParams.size() != actualTypeParams.size()) {
                throw new UnsupportedOperationException();
            }
            for (int i = 0; i < formalTypeParams.size(); ++i) {
                this.determineTypeParameters(determinedTypeParameters, (TypeUsage)formalTypeParams.get(i), (TypeUsage)actualTypeParams.get(i), typeSolver);
            }
        }
    }

    private Context getContext() {
        return JavaParserFactory.getContext((Node)this.wrappedNode, this.typeSolver);
    }

    public boolean isAbstract() {
        throw new UnsupportedOperationException();
    }

    public boolean isPrivate() {
        throw new UnsupportedOperationException();
    }

    private Optional<TypeUsage> typeParamByName(String name, TypeSolver typeSolver, Context context) {
        int i = 0;
        if (this.wrappedNode.getTypeParameters() != null) {
            for (TypeParameter tp : this.wrappedNode.getTypeParameters()) {
                if (tp.getName().equals(name)) {
                    TypeUsage typeUsage = JavaParserFacade.get(typeSolver).convertToUsage(((Parameter)this.wrappedNode.getParameters().get(i)).getType(), context);
                    return Optional.of(typeUsage);
                }
                ++i;
            }
        }
        return Optional.empty();
    }

    private TypeUsage replaceTypeParams(TypeUsage typeUsage, TypeSolver typeSolver, Context context) {
        Optional<TypeUsage> typeParam;
        me.tomassetti.symbolsolver.model.resolution.TypeParameter typeParameter;
        if (typeUsage.isTypeVariable() && (typeParameter = typeUsage.asTypeParameter()).declaredOnClass() && (typeParam = this.typeParamByName(typeParameter.getName(), typeSolver, context)).isPresent()) {
            typeUsage = typeParam.get();
        }
        if (typeUsage.isReferenceType()) {
            for (int i = 0; i < typeUsage.asReferenceTypeUsage().parameters().size(); ++i) {
                TypeUsage replaced = this.replaceTypeParams((TypeUsage)typeUsage.asReferenceTypeUsage().parameters().get(i), typeSolver, context);
                if (replaced == typeUsage.asReferenceTypeUsage().parameters().get(i)) continue;
                typeUsage = typeUsage.asReferenceTypeUsage().replaceParam(i, replaced);
            }
        }
        return typeUsage;
    }

    public String getName() {
        return this.wrappedNode.getName();
    }

    public boolean isField() {
        throw new UnsupportedOperationException();
    }

    public boolean isParameter() {
        throw new UnsupportedOperationException();
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isType() {
        throw new UnsupportedOperationException();
    }

    public List<me.tomassetti.symbolsolver.model.resolution.TypeParameter> getTypeParameters() {
        if (this.wrappedNode.getTypeParameters() == null) {
            return Collections.emptyList();
        }
        return this.wrappedNode.getTypeParameters().stream().map(astTp -> new JavaParserTypeParameter((TypeParameter)astTp, this.typeSolver)).collect(Collectors.toList());
    }

    public boolean isPackageProtected() {
        throw new UnsupportedOperationException();
    }

    public MethodDeclaration getWrappedNode() {
        return this.wrappedNode;
    }
}

