/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.type.PrimitiveType;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFacade;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFactory;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.PrimitiveTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;

public class JavaParserSymbolDeclaration
implements ValueDeclaration {
    private String name;
    private Node wrappedNode;
    private boolean field;
    private boolean parameter;
    private boolean variable;
    private TypeSolver typeSolver;

    private JavaParserSymbolDeclaration(Node wrappedNode, String name, TypeSolver typeSolver, boolean field, boolean parameter, boolean variable) {
        this.name = name;
        this.wrappedNode = wrappedNode;
        this.field = field;
        this.variable = variable;
        this.parameter = parameter;
        this.typeSolver = typeSolver;
    }

    public static JavaParserSymbolDeclaration field(VariableDeclarator wrappedNode, TypeSolver typeSolver) {
        return new JavaParserSymbolDeclaration((Node)wrappedNode, wrappedNode.getId().getName(), typeSolver, true, false, false);
    }

    public static JavaParserSymbolDeclaration parameter(Parameter parameter, TypeSolver typeSolver) {
        return new JavaParserSymbolDeclaration((Node)parameter, parameter.getId().getName(), typeSolver, false, true, false);
    }

    public static JavaParserSymbolDeclaration localVar(VariableDeclarator variableDeclarator, TypeSolver typeSolver) {
        return new JavaParserSymbolDeclaration((Node)variableDeclarator, variableDeclarator.getId().getName(), typeSolver, false, false, true);
    }

    public static int getParamPos(Parameter parameter) {
        int pos = 0;
        for (Node node : parameter.getParentNode().getChildrenNodes()) {
            if (node == parameter) {
                return pos;
            }
            if (!(node instanceof Parameter)) continue;
            ++pos;
        }
        return pos;
    }

    public static int getParamPos(Node node) {
        if (node.getParentNode() instanceof MethodCallExpr) {
            MethodCallExpr call = (MethodCallExpr)node.getParentNode();
            for (int i = 0; i < call.getArgs().size(); ++i) {
                if (call.getArgs().get(i) != node) continue;
                return i;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "JavaParserSymbolDeclaration{name='" + this.name + '\'' + ", wrappedNode=" + this.wrappedNode + '}';
    }

    public String getName() {
        return this.name;
    }

    public boolean isField() {
        return this.field;
    }

    public boolean isParameter() {
        return this.parameter;
    }

    public boolean isVariable() {
        return this.variable;
    }

    public boolean isType() {
        return false;
    }

    public TypeUsage getType() {
        if (this.wrappedNode instanceof Parameter) {
            Parameter parameter = (Parameter)this.wrappedNode;
            if (this.wrappedNode.getParentNode() instanceof LambdaExpr) {
                int pos = JavaParserSymbolDeclaration.getParamPos(parameter);
                TypeUsage lambdaType = JavaParserFacade.get(this.typeSolver).getType(this.wrappedNode.getParentNode());
                throw new UnsupportedOperationException(this.wrappedNode.getClass().getCanonicalName());
            }
            if (parameter.getType() instanceof PrimitiveType) {
                return PrimitiveTypeUsage.byName((String)((PrimitiveType)parameter.getType()).getType().name());
            }
            return JavaParserFacade.get(this.typeSolver).convertToUsage(parameter.getType(), this.wrappedNode);
        }
        if (this.wrappedNode instanceof VariableDeclarator) {
            VariableDeclarator variableDeclarator = (VariableDeclarator)this.wrappedNode;
            if (this.wrappedNode.getParentNode() instanceof VariableDeclarationExpr) {
                VariableDeclarationExpr variableDeclarationExpr = (VariableDeclarationExpr)variableDeclarator.getParentNode();
                return JavaParserFacade.get(this.typeSolver).convert(variableDeclarationExpr.getType(), JavaParserFactory.getContext(this.wrappedNode, this.typeSolver));
            }
            if (this.wrappedNode.getParentNode() instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)variableDeclarator.getParentNode();
                return JavaParserFacade.get(this.typeSolver).convert(fieldDeclaration.getType(), JavaParserFactory.getContext(this.wrappedNode, this.typeSolver));
            }
            throw new UnsupportedOperationException(this.wrappedNode.getParentNode().getClass().getCanonicalName());
        }
        throw new UnsupportedOperationException(this.wrappedNode.getClass().getCanonicalName());
    }

    public Node getWrappedNode() {
        return this.wrappedNode;
    }
}

