/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javassistmodel;

import com.github.javaparser.ast.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import me.tomassetti.symbolsolver.javaparsermodel.LambdaArgumentTypeUsagePlaceholder;
import me.tomassetti.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistTypeParameter;
import me.tomassetti.symbolsolver.javassistmodel.contexts.JavassistMethodContext;
import me.tomassetti.symbolsolver.logic.AbstractClassDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ClassDeclaration;
import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.declarations.FieldDeclaration;
import me.tomassetti.symbolsolver.model.declarations.InterfaceDeclaration;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.resolution.MethodResolutionLogic;
import me.tomassetti.symbolsolver.resolution.SymbolSolver;

public class JavassistClassDeclaration
extends AbstractClassDeclaration {
    private CtClass ctClass;
    private TypeSolver typeSolver;

    protected ReferenceTypeUsage object() {
        return new ReferenceTypeUsageImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver);
    }

    public ClassDeclaration asClass() {
        return this;
    }

    public Set<MethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.ctClass.getDeclaredMethods()).map(m -> new JavassistMethodDeclaration((CtMethod)m, this.typeSolver())).collect(Collectors.toSet());
    }

    public JavassistClassDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        if (ctClass == null) {
            throw new IllegalArgumentException();
        }
        if (ctClass.isInterface() || ctClass.isAnnotation() || ctClass.isPrimitive() || ctClass.isEnum()) {
            throw new IllegalArgumentException("Trying to instantiate a JavassistClassDeclaration with something which is not a class: " + ctClass.toString());
        }
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
    }

    protected TypeSolver typeSolver() {
        return this.typeSolver;
    }

    public boolean isAssignableBy(TypeDeclaration other) {
        return this.isAssignableBy((TypeUsage)new ReferenceTypeUsageImpl(other, this.typeSolver));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavassistClassDeclaration that = (JavassistClassDeclaration)((Object)o);
        return this.ctClass.equals(that.ctClass);
    }

    public int hashCode() {
        return this.ctClass.hashCode();
    }

    public String getQualifiedName() {
        return this.ctClass.getName();
    }

    private List<TypeUsage> parseTypeParameters(String signature, TypeSolver typeSolver, Context context, Context invokationContext) {
        String originalSignature = signature;
        if (signature.contains("<")) {
            if (!(signature = signature.substring(signature.indexOf(60) + 1)).endsWith(">")) {
                throw new IllegalArgumentException();
            }
            if ((signature = signature.substring(0, signature.length() - 1)).contains(",")) {
                throw new UnsupportedOperationException();
            }
            if (signature.contains("<")) {
                throw new UnsupportedOperationException(originalSignature);
            }
            if (signature.contains(">")) {
                throw new UnsupportedOperationException();
            }
            ArrayList<TypeUsage> typeUsages = new ArrayList<TypeUsage>();
            typeUsages.add(new SymbolSolver(typeSolver).solveTypeUsage(signature, invokationContext));
            return typeUsages;
        }
        return Collections.emptyList();
    }

    public Optional<MethodUsage> solveMethodAsUsage(String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver, Context invokationContext, List<TypeUsage> typeParameterValues) {
        CtMethod[] ctMethodArray = this.ctClass.getDeclaredMethods();
        int n = ctMethodArray.length;
        for (int i = 0; i < n; ++i) {
            CtMethod method = ctMethodArray[i];
            if (!method.getName().equals(name)) continue;
            MethodUsage methodUsage = new MethodUsage((MethodDeclaration)new JavassistMethodDeclaration(method, typeSolver), typeSolver);
            try {
                if (method.getGenericSignature() != null) {
                    SignatureAttribute.MethodSignature classSignature = SignatureAttribute.toMethodSignature((String)method.getGenericSignature());
                    List<TypeUsage> parametersOfReturnType = this.parseTypeParameters(classSignature.getReturnType().toString(), typeSolver, new JavassistMethodContext(method), invokationContext);
                    TypeUsage newReturnType = methodUsage.returnType();
                    for (int i2 = 0; i2 < parametersOfReturnType.size(); ++i2) {
                        newReturnType = newReturnType.asReferenceTypeUsage().replaceParam(i2, parametersOfReturnType.get(i2));
                    }
                    methodUsage = methodUsage.replaceReturnType(newReturnType);
                }
                return Optional.of(methodUsage);
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Optional<MethodUsage> ref;
            CtClass superClass = this.ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, typeSolver).solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, null)).isPresent()) {
                return ref;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                Optional<MethodUsage> ref = new JavassistClassDeclaration(interfaze, typeSolver).solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, null);
                if (!ref.isPresent()) continue;
                return ref;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return Optional.empty();
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        CtField[] ctFieldArray = this.ctClass.getDeclaredFields();
        int n = ctFieldArray.length;
        for (int i = 0; i < n; ++i) {
            CtField field = ctFieldArray[i];
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved((Declaration)new JavassistFieldDeclaration(field, typeSolver));
        }
        try {
            SymbolReference<? extends ValueDeclaration> ref;
            CtClass superClass = this.ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, typeSolver).solveSymbol(name, typeSolver)).isSolved()) {
                return ref;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                SymbolReference<? extends ValueDeclaration> ref = new JavassistClassDeclaration(interfaze, typeSolver).solveSymbol(name, typeSolver);
                if (!ref.isSolved()) continue;
                return ref;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return SymbolReference.unsolved(ValueDeclaration.class);
    }

    public SymbolReference<TypeDeclaration> solveType(String substring, TypeSolver typeSolver) {
        throw new UnsupportedOperationException();
    }

    public List<ReferenceTypeUsage> getAllAncestors() {
        LinkedList<ReferenceTypeUsage> ancestors = new LinkedList<ReferenceTypeUsage>();
        if (this.getSuperClass() != null) {
            ancestors.add(this.getSuperClass());
            ancestors.addAll(this.getSuperClass().getAllAncestors());
        }
        ancestors.addAll(this.getAllInterfaces().stream().map(i -> new ReferenceTypeUsageImpl((TypeDeclaration)i, this.typeSolver)).collect(Collectors.toList()));
        return ancestors;
    }

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public SymbolReference<MethodDeclaration> solveMethod(String name, List<TypeUsage> parameterTypes) {
        ArrayList<MethodDeclaration> candidates = new ArrayList<MethodDeclaration>();
        CtMethod[] ctMethodArray = this.ctClass.getDeclaredMethods();
        int n = ctMethodArray.length;
        for (int i = 0; i < n; ++i) {
            CtMethod method = ctMethodArray[i];
            if (!method.getName().equals(name)) continue;
            candidates.add(new JavassistMethodDeclaration(method, this.typeSolver));
        }
        try {
            SymbolReference<MethodDeclaration> ref;
            CtClass superClass = this.ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, this.typeSolver).solveMethod(name, parameterTypes)).isSolved()) {
                candidates.add((MethodDeclaration)ref.getCorrespondingDeclaration());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                SymbolReference<MethodDeclaration> ref = new JavassistInterfaceDeclaration(interfaze, this.typeSolver).solveMethod(name, parameterTypes);
                if (!ref.isSolved()) continue;
                candidates.add((MethodDeclaration)ref.getCorrespondingDeclaration());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return MethodResolutionLogic.findMostApplicable(candidates, name, parameterTypes, this.typeSolver);
    }

    public TypeUsage getUsage(Node node) {
        return new ReferenceTypeUsageImpl((TypeDeclaration)this, this.typeSolver);
    }

    public boolean isAssignableBy(TypeUsage typeUsage) {
        if (typeUsage.isNull()) {
            return true;
        }
        if (typeUsage instanceof LambdaArgumentTypeUsagePlaceholder) {
            return this.ctClass.getName().equals(Predicate.class.getCanonicalName()) || this.ctClass.getName().equals(Function.class.getCanonicalName());
        }
        if (typeUsage.describe().equals(this.getQualifiedName())) {
            return true;
        }
        try {
            if (this.ctClass.getSuperclass() != null && new JavassistClassDeclaration(this.ctClass.getSuperclass(), this.typeSolver).isAssignableBy(typeUsage)) {
                return true;
            }
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                if (!new JavassistClassDeclaration(interfaze, this.typeSolver).isAssignableBy(typeUsage)) continue;
                return true;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public FieldDeclaration getField(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean hasField(String name) {
        throw new UnsupportedOperationException();
    }

    public List<FieldDeclaration> getAllFields() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.ctClass.getSimpleName();
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isType() {
        return true;
    }

    public boolean isClass() {
        return !this.ctClass.isInterface();
    }

    public ReferenceTypeUsageImpl getSuperClass() {
        try {
            if (this.ctClass.getSuperclass() == null) {
                return new ReferenceTypeUsageImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver());
            }
            return new ReferenceTypeUsageImpl((TypeDeclaration)new JavassistClassDeclaration(this.ctClass.getSuperclass(), this.typeSolver).asClass(), this.typeSolver);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public List<InterfaceDeclaration> getInterfaces() {
        try {
            return Arrays.stream(this.ctClass.getInterfaces()).map(i -> new JavassistInterfaceDeclaration((CtClass)i, this.typeSolver())).collect(Collectors.toList());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isInterface() {
        return this.ctClass.isInterface();
    }

    public String toString() {
        return "JavassistClassDeclaration {" + this.ctClass.getName() + '}';
    }

    public List<TypeParameter> getTypeParameters() {
        if (null == this.ctClass.getGenericSignature()) {
            return Collections.emptyList();
        }
        try {
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return Arrays.stream(classSignature.getParameters()).map(tp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)tp, true, this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }
}

