/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javassistmodel;

import javassist.CtClass;
import javassist.NotFoundException;
import me.tomassetti.symbolsolver.javassistmodel.JavassistClassDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.ArrayTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.PrimitiveTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;

public class JavassistFactory {
    public static TypeUsage typeUsageFor(CtClass ctClazz, TypeSolver typeSolver) {
        try {
            if (ctClazz.isArray()) {
                return new ArrayTypeUsage(JavassistFactory.typeUsageFor(ctClazz.getComponentType(), typeSolver));
            }
            if (ctClazz.isPrimitive()) {
                return PrimitiveTypeUsage.byName((String)ctClazz.getName());
            }
            if (ctClazz.isInterface()) {
                return new ReferenceTypeUsageImpl((TypeDeclaration)new JavassistInterfaceDeclaration(ctClazz, typeSolver), typeSolver);
            }
            return new ReferenceTypeUsageImpl((TypeDeclaration)new JavassistClassDeclaration(ctClazz, typeSolver), typeSolver);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static TypeDeclaration toTypeDeclaration(CtClass ctClazz, TypeSolver typeSolver) {
        if (ctClazz.isInterface()) {
            return new JavassistInterfaceDeclaration(ctClazz, typeSolver);
        }
        if (ctClazz.isEnum()) {
            throw new UnsupportedOperationException("CtClass of enum not yet supported");
        }
        if (ctClazz.isAnnotation()) {
            throw new UnsupportedOperationException("CtClass of annotation not yet supported");
        }
        if (ctClazz.isArray()) {
            throw new IllegalArgumentException("This method should not be called passing an array");
        }
        return new JavassistClassDeclaration(ctClazz, typeSolver);
    }
}

