/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javassistmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import me.tomassetti.symbolsolver.javassistmodel.JavassistClassDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistFactory;
import me.tomassetti.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistTypeParameter;
import me.tomassetti.symbolsolver.javassistmodel.contexts.JavassistMethodContext;
import me.tomassetti.symbolsolver.logic.AbstractTypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.FieldDeclaration;
import me.tomassetti.symbolsolver.model.declarations.InterfaceDeclaration;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.resolution.MethodResolutionLogic;
import me.tomassetti.symbolsolver.resolution.SymbolSolver;

public class JavassistInterfaceDeclaration
extends AbstractTypeDeclaration
implements InterfaceDeclaration {
    private CtClass ctClass;
    private TypeSolver typeSolver;

    public String toString() {
        return "JavassistInterfaceDeclaration{ctClass=" + this.ctClass.getName() + ", typeSolver=" + this.typeSolver + '}';
    }

    public JavassistInterfaceDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        if (!ctClass.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + ctClass.getName());
        }
    }

    public List<InterfaceDeclaration> getInterfacesExtended() {
        try {
            return Arrays.stream(this.ctClass.getInterfaces()).map(i -> new JavassistInterfaceDeclaration((CtClass)i, this.typeSolver)).collect(Collectors.toList());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getQualifiedName() {
        return this.ctClass.getName();
    }

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    private List<TypeUsage> parseTypeParameters(String signature, TypeSolver typeSolver, Context context, Context invokationContext) {
        String originalSignature = signature;
        if (signature.contains("<")) {
            if (!(signature = signature.substring(signature.indexOf(60) + 1)).endsWith(">")) {
                throw new IllegalArgumentException();
            }
            if ((signature = signature.substring(0, signature.length() - 1)).contains(",")) {
                throw new UnsupportedOperationException();
            }
            if (signature.contains("<")) {
                throw new UnsupportedOperationException(originalSignature);
            }
            if (signature.contains(">")) {
                throw new UnsupportedOperationException();
            }
            ArrayList<TypeUsage> typeUsages = new ArrayList<TypeUsage>();
            typeUsages.add(new SymbolSolver(typeSolver).solveTypeUsage(signature, invokationContext));
            return typeUsages;
        }
        return Collections.emptyList();
    }

    public Optional<MethodUsage> solveMethodAsUsage(String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver, Context invokationContext, List<TypeUsage> typeParameterValues) {
        CtMethod[] ctMethodArray = this.ctClass.getDeclaredMethods();
        int n = ctMethodArray.length;
        for (int i = 0; i < n; ++i) {
            CtMethod method = ctMethodArray[i];
            if (!method.getName().equals(name)) continue;
            MethodUsage methodUsage = new MethodUsage((MethodDeclaration)new JavassistMethodDeclaration(method, typeSolver), typeSolver);
            try {
                if (method.getGenericSignature() != null) {
                    SignatureAttribute.MethodSignature classSignature = SignatureAttribute.toMethodSignature((String)method.getGenericSignature());
                    List<TypeUsage> parametersOfReturnType = this.parseTypeParameters(classSignature.getReturnType().toString(), typeSolver, new JavassistMethodContext(method), invokationContext);
                    TypeUsage newReturnType = methodUsage.returnType();
                    for (int i2 = 0; i2 < parametersOfReturnType.size(); ++i2) {
                        newReturnType = newReturnType.asReferenceTypeUsage().replaceParam(i2, parametersOfReturnType.get(i2));
                    }
                    methodUsage = methodUsage.replaceReturnType(newReturnType);
                }
                return Optional.of(methodUsage);
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Optional<MethodUsage> ref;
            CtClass superClass = this.ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, typeSolver).solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, null)).isPresent()) {
                return ref;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                Optional<MethodUsage> ref = new JavassistInterfaceDeclaration(interfaze, typeSolver).solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, null);
                if (!ref.isPresent()) continue;
                return ref;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return Optional.empty();
    }

    public SymbolReference<MethodDeclaration> solveMethod(String name, List<TypeUsage> parameterTypes) {
        ArrayList<MethodDeclaration> candidates = new ArrayList<MethodDeclaration>();
        CtMethod[] ctMethodArray = this.ctClass.getDeclaredMethods();
        int n = ctMethodArray.length;
        for (int i = 0; i < n; ++i) {
            CtMethod method = ctMethodArray[i];
            if (!method.getName().equals(name)) continue;
            candidates.add(new JavassistMethodDeclaration(method, this.typeSolver));
        }
        try {
            SymbolReference<MethodDeclaration> ref;
            CtClass superClass = this.ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, this.typeSolver).solveMethod(name, parameterTypes)).isSolved()) {
                candidates.add((MethodDeclaration)ref.getCorrespondingDeclaration());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                SymbolReference<MethodDeclaration> ref = new JavassistInterfaceDeclaration(interfaze, this.typeSolver).solveMethod(name, parameterTypes);
                if (!ref.isSolved()) continue;
                candidates.add((MethodDeclaration)ref.getCorrespondingDeclaration());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return MethodResolutionLogic.findMostApplicable(candidates, name, parameterTypes, this.typeSolver);
    }

    protected TypeSolver typeSolver() {
        return this.typeSolver;
    }

    public boolean isAssignableBy(TypeUsage typeUsage) {
        throw new UnsupportedOperationException();
    }

    public FieldDeclaration getField(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean hasField(String name) {
        throw new UnsupportedOperationException();
    }

    public List<FieldDeclaration> getAllFields() {
        throw new UnsupportedOperationException();
    }

    public boolean isAssignableBy(TypeDeclaration other) {
        throw new UnsupportedOperationException();
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String substring, TypeSolver typeSolver) {
        throw new UnsupportedOperationException();
    }

    public SymbolReference<TypeDeclaration> solveType(String substring, TypeSolver typeSolver) {
        throw new UnsupportedOperationException();
    }

    public List<ReferenceTypeUsage> getAllAncestors() {
        List<Object> ancestors = new ArrayList();
        try {
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                ReferenceTypeUsage superInterfaze = JavassistFactory.typeUsageFor(interfaze, this.typeSolver()).asReferenceTypeUsage();
                ancestors.add(superInterfaze);
                ancestors.addAll(superInterfaze.getAllAncestors());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        ancestors = ancestors.stream().filter(a -> a.getQualifiedName() != Object.class.getCanonicalName()).collect(Collectors.toList());
        ancestors.add((Object)new ReferenceTypeUsageImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver));
        return ancestors;
    }

    public Set<MethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.ctClass.getDeclaredMethods()).map(m -> new JavassistMethodDeclaration((CtMethod)m, this.typeSolver())).collect(Collectors.toSet());
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public List<TypeParameter> getTypeParameters() {
        if (null == this.ctClass.getGenericSignature()) {
            return Collections.emptyList();
        }
        try {
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return Arrays.stream(classSignature.getParameters()).map(tp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)tp, true, this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }
}

