/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.javassistmodel;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ModifierSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import me.tomassetti.symbolsolver.javassistmodel.JavassistClassDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistFactory;
import me.tomassetti.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistParameterDeclaration;
import me.tomassetti.symbolsolver.javassistmodel.JavassistTypeParameter;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ParameterDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;

public class JavassistMethodDeclaration
implements MethodDeclaration {
    private CtMethod ctMethod;
    private TypeSolver typeSolver;

    public JavassistMethodDeclaration(CtMethod ctMethod, TypeSolver typeSolver) {
        this.ctMethod = ctMethod;
        this.typeSolver = typeSolver;
    }

    public String toString() {
        return "JavassistMethodDeclaration{ctMethod=" + this.ctMethod + '}';
    }

    public String getName() {
        return this.ctMethod.getName();
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isType() {
        return false;
    }

    public TypeDeclaration declaringType() {
        if (this.ctMethod.getDeclaringClass().isInterface()) {
            return new JavassistInterfaceDeclaration(this.ctMethod.getDeclaringClass(), this.typeSolver);
        }
        return new JavassistClassDeclaration(this.ctMethod.getDeclaringClass(), this.typeSolver);
    }

    public TypeUsage getReturnType() {
        try {
            return JavassistFactory.typeUsageFor(this.ctMethod.getReturnType(), this.typeSolver);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public int getNoParams() {
        try {
            return this.ctMethod.getParameterTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ParameterDeclaration getParam(int i) {
        try {
            boolean variadic = false;
            if ((this.ctMethod.getModifiers() & 0x80) > 0) {
                variadic = i == this.ctMethod.getParameterTypes().length - 1;
            }
            return new JavassistParameterDeclaration(this.ctMethod.getParameterTypes()[i], this.typeSolver, variadic);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public MethodUsage getUsage(Node node) {
        throw new UnsupportedOperationException();
    }

    public MethodUsage resolveTypeVariables(Context context, List<TypeUsage> parameterTypes) {
        throw new UnsupportedOperationException();
    }

    public boolean isAbstract() {
        return ModifierSet.isAbstract((int)this.ctMethod.getModifiers());
    }

    public boolean isPrivate() {
        return ModifierSet.isPrivate((int)this.ctMethod.getModifiers());
    }

    public boolean isPackageProtected() {
        throw new UnsupportedOperationException();
    }

    public List<TypeParameter> getTypeParameters() {
        try {
            if (this.ctMethod.getGenericSignature() == null) {
                return Collections.emptyList();
            }
            SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)this.ctMethod.getGenericSignature());
            return Arrays.stream(methodSignature.getTypeParameters()).map(jasTp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)jasTp, false, this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }
}

