/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.Node;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.tomassetti.symbolsolver.javaparsermodel.LambdaArgumentTypeUsagePlaceholder;
import me.tomassetti.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import me.tomassetti.symbolsolver.logic.AbstractClassDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ClassDeclaration;
import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.declarations.FieldDeclaration;
import me.tomassetti.symbolsolver.model.declarations.InterfaceDeclaration;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.NullTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.reflectionmodel.ClassOrInterfaceDeclarationContext;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionFactory;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionTypeParameter;
import me.tomassetti.symbolsolver.resolution.MethodResolutionLogic;

public class ReflectionClassDeclaration
extends AbstractClassDeclaration {
    private Class<?> clazz;
    private TypeSolver typeSolver;

    protected ReferenceTypeUsage object() {
        return new ReferenceTypeUsageImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver);
    }

    public Set<MethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.clazz.getDeclaredMethods()).filter(m -> !m.isSynthetic() && !m.isBridge()).map(m -> new ReflectionMethodDeclaration((Method)m, this.typeSolver())).collect(Collectors.toSet());
    }

    public ReflectionClassDeclaration(Class<?> clazz, TypeSolver typeSolver) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.typeSolver = typeSolver;
        if (clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException();
        }
        this.clazz = clazz;
    }

    protected TypeSolver typeSolver() {
        return this.typeSolver;
    }

    public List<ReferenceTypeUsage> getAllAncestors() {
        LinkedList<ReferenceTypeUsage> ancestors = new LinkedList<ReferenceTypeUsage>();
        if (this.getSuperClass() != null) {
            ReferenceTypeUsageImpl superClass = this.getSuperClass();
            ancestors.add(superClass);
            ancestors.addAll(this.getSuperClass().getAllAncestors());
        }
        ancestors.addAll(this.getAllInterfaces().stream().map(i -> new ReferenceTypeUsageImpl((TypeDeclaration)i, this.typeSolver)).collect(Collectors.toList()));
        for (int i2 = 0; i2 < ancestors.size(); ++i2) {
            ReferenceTypeUsage ancestor = (ReferenceTypeUsage)ancestors.get(i2);
            if (!ancestor.hasName() || !ancestor.getQualifiedName().equals(Object.class.getCanonicalName())) continue;
            ancestors.remove(i2);
            --i2;
        }
        ReferenceTypeUsageImpl object = new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionClassDeclaration(Object.class, this.typeSolver), this.typeSolver);
        ancestors.add(object);
        return ancestors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReflectionClassDeclaration that = (ReflectionClassDeclaration)((Object)o);
        return this.clazz.getCanonicalName().equals(that.clazz.getCanonicalName());
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public String getQualifiedName() {
        return this.clazz.getCanonicalName();
    }

    public Context getContext() {
        return new ClassOrInterfaceDeclarationContext(this.clazz);
    }

    public SymbolReference<MethodDeclaration> solveMethod(String name, List<TypeUsage> parameterTypes) {
        ClassDeclaration superClass;
        SymbolReference ref;
        ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        for (Method method : Arrays.stream(this.clazz.getDeclaredMethods()).filter(m -> m.getName().equals(name)).sorted(new MethodComparator()).collect(Collectors.toList())) {
            if (method.isBridge() || method.isSynthetic()) continue;
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method, this.typeSolver);
            methods.add(methodDeclaration);
        }
        if (this.getSuperClass() != null && (ref = (superClass = (ClassDeclaration)this.getSuperClass().getTypeDeclaration()).solveMethod(name, parameterTypes)).isSolved()) {
            methods.add((MethodDeclaration)ref.getCorrespondingDeclaration());
        }
        for (InterfaceDeclaration interfaceDeclaration : this.getInterfaces()) {
            SymbolReference ref2 = interfaceDeclaration.solveMethod(name, parameterTypes);
            if (!ref2.isSolved()) continue;
            methods.add((MethodDeclaration)ref2.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(methods, name, parameterTypes, this.typeSolver);
    }

    public String toString() {
        return "ReflectionClassDeclaration{clazz=" + this.clazz.getCanonicalName() + '}';
    }

    public TypeUsage getUsage(Node node) {
        return new ReferenceTypeUsageImpl((TypeDeclaration)this, this.typeSolver);
    }

    public Optional<MethodUsage> solveMethodAsUsage(String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver, Context invokationContext, List<TypeUsage> typeParameterValues) {
        ClassDeclaration superClass;
        Optional ref;
        ArrayList<MethodUsage> methods = new ArrayList<MethodUsage>();
        for (Method method : Arrays.stream(this.clazz.getDeclaredMethods()).filter(m -> m.getName().equals(name)).sorted(new MethodComparator()).collect(Collectors.toList())) {
            if (method.isBridge() || method.isSynthetic()) continue;
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method, typeSolver);
            MethodUsage methodUsage = new MethodUsage((MethodDeclaration)methodDeclaration, typeSolver);
            for (int i = 0; i < this.getTypeParameters().size(); ++i) {
                String nameToReplace = this.getTypeParameters().get(i).getName();
                TypeUsage newValue = typeParameterValues.get(i);
                methodUsage = methodUsage.replaceNameParam(nameToReplace, newValue);
            }
            methods.add(methodUsage);
        }
        if (this.getSuperClass() != null && (ref = (superClass = (ClassDeclaration)this.getSuperClass().getTypeDeclaration()).solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, typeParameterValues)).isPresent()) {
            methods.add((MethodUsage)ref.get());
        }
        for (InterfaceDeclaration interfaceDeclaration : this.getInterfaces()) {
            Optional ref2 = interfaceDeclaration.solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, typeParameterValues);
            if (!ref2.isPresent()) continue;
            methods.add((MethodUsage)ref2.get());
        }
        Optional<MethodUsage> ref3 = MethodResolutionLogic.findMostApplicableUsage(methods, name, parameterTypes, typeSolver);
        return ref3;
    }

    public boolean canBeAssignedTo(TypeDeclaration other) {
        if (other instanceof LambdaArgumentTypeUsagePlaceholder) {
            return this.getQualifiedName().equals(Predicate.class.getCanonicalName()) || this.getQualifiedName().equals(Function.class.getCanonicalName());
        }
        if (other.getQualifiedName().equals(this.getQualifiedName())) {
            return true;
        }
        if (this.clazz.getSuperclass() != null && new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver).canBeAssignedTo(other)) {
            return true;
        }
        for (Class<?> interfaze : this.clazz.getInterfaces()) {
            if (!new ReflectionInterfaceDeclaration(interfaze, this.typeSolver).canBeAssignedTo(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableBy(TypeUsage typeUsage) {
        if (typeUsage instanceof NullTypeUsage) {
            return true;
        }
        if (typeUsage instanceof LambdaArgumentTypeUsagePlaceholder) {
            return this.getQualifiedName().equals(Predicate.class.getCanonicalName()) || this.getQualifiedName().equals(Function.class.getCanonicalName());
        }
        if (typeUsage.isArray()) {
            return false;
        }
        if (typeUsage.isPrimitive()) {
            return false;
        }
        if (typeUsage.describe().equals(this.getQualifiedName())) {
            return true;
        }
        if (typeUsage instanceof ReferenceTypeUsageImpl) {
            ReferenceTypeUsageImpl otherTypeDeclaration = (ReferenceTypeUsageImpl)typeUsage;
            return otherTypeDeclaration.getTypeDeclaration().canBeAssignedTo((TypeDeclaration)this);
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public FieldDeclaration getField(String name) {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return new ReflectionFieldDeclaration(field, this.typeSolver);
        }
        for (ReferenceTypeUsage ancestor : this.getAllAncestors()) {
            if (!ancestor.getTypeDeclaration().hasField(name)) continue;
            return ancestor.getTypeDeclaration().getField(name).replaceType((TypeUsage)ancestor.getFieldType(name).get());
        }
        throw new UnsolvedSymbolException("Field in " + (Object)((Object)this), name);
    }

    public List<FieldDeclaration> getAllFields() {
        ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
        for (Field field : this.clazz.getDeclaredFields()) {
            fields.add(new ReflectionFieldDeclaration(field, this.typeSolver));
        }
        for (ReferenceTypeUsage ancestor : this.getAllAncestors()) {
            fields.addAll(ancestor.getTypeDeclaration().getAllFields());
        }
        return fields;
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Field field : this.clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved((Declaration)new ReflectionFieldDeclaration(field, typeSolver));
        }
        return SymbolReference.unsolved(ValueDeclaration.class);
    }

    public SymbolReference<TypeDeclaration> solveType(String substring, TypeSolver typeSolver) {
        return SymbolReference.unsolved(TypeDeclaration.class);
    }

    public ClassDeclaration asClass() {
        return this;
    }

    public boolean hasField(String name) {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        ReferenceTypeUsageImpl superclass = this.getSuperClass();
        if (superclass == null) {
            return false;
        }
        return superclass.getTypeDeclaration().hasField(name);
    }

    public boolean isAssignableBy(TypeDeclaration other) {
        return this.isAssignableBy((TypeUsage)new ReferenceTypeUsageImpl(other, this.typeSolver));
    }

    public String getName() {
        return this.clazz.getSimpleName();
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isType() {
        return true;
    }

    public boolean isClass() {
        return !this.clazz.isInterface();
    }

    public ReferenceTypeUsageImpl getSuperClass() {
        if (this.clazz.getGenericSuperclass() == null) {
            return null;
        }
        Type superType = this.clazz.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)superType;
            List<TypeUsage> typeParameters = Arrays.stream(parameterizedType.getActualTypeArguments()).map(t -> ReflectionFactory.typeUsageFor(t, this.typeSolver)).collect(Collectors.toList());
            return new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver), typeParameters, this.typeSolver);
        }
        return new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver), this.typeSolver);
    }

    public List<InterfaceDeclaration> getInterfaces() {
        ArrayList<InterfaceDeclaration> interfaces = new ArrayList<InterfaceDeclaration>();
        for (Class<?> i : this.clazz.getInterfaces()) {
            interfaces.add(new ReflectionInterfaceDeclaration(i, this.typeSolver));
        }
        return interfaces;
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public List<TypeParameter> getTypeParameters() {
        ArrayList<TypeParameter> params = new ArrayList<TypeParameter>();
        for (TypeVariable<Class<?>> tv : this.clazz.getTypeParameters()) {
            params.add(new ReflectionTypeParameter(tv, true));
        }
        return params;
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            int compareName = o1.getName().compareTo(o2.getName());
            if (compareName != 0) {
                return compareName;
            }
            int compareNParams = o1.getParameterCount() - o2.getParameterCount();
            if (compareNParams != 0) {
                return compareNParams;
            }
            for (int i = 0; i < o1.getParameterCount(); ++i) {
                int compareParam = new ParameterComparator().compare(o1.getParameters()[i], o2.getParameters()[i]);
                if (compareParam == 0) continue;
                return compareParam;
            }
            int compareResult = new ClassComparator().compare(o1.getReturnType(), o2.getReturnType());
            if (compareResult != 0) {
                return compareResult;
            }
            return 0;
        }
    }

    private static class ClassComparator
    implements Comparator<Class<?>> {
        private ClassComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            int subCompare = o1.getCanonicalName().compareTo(o2.getCanonicalName());
            if (subCompare != 0) {
                return subCompare;
            }
            subCompare = Boolean.compare(o1.isAnnotation(), o2.isAnnotation());
            if (subCompare != 0) {
                return subCompare;
            }
            subCompare = Boolean.compare(o1.isArray(), o2.isArray());
            if (subCompare != 0) {
                return subCompare;
            }
            subCompare = Boolean.compare(o1.isEnum(), o2.isEnum());
            if (subCompare != 0) {
                return subCompare;
            }
            subCompare = Boolean.compare(o1.isInterface(), o2.isInterface());
            if (subCompare != 0) {
                return subCompare;
            }
            return 0;
        }
    }

    private static class ParameterComparator
    implements Comparator<Parameter> {
        private ParameterComparator() {
        }

        @Override
        public int compare(Parameter o1, Parameter o2) {
            int compareName = o1.getName().compareTo(o2.getName());
            if (compareName != 0) {
                return compareName;
            }
            int compareType = new ClassComparator().compare(o1.getType(), o2.getType());
            if (compareType != 0) {
                return compareType;
            }
            return 0;
        }
    }
}

