/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.reflectionmodel;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.ArrayTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.PrimitiveTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeParameterUsage;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.VoidTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.WildcardUsage;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionTypeParameter;

public class ReflectionFactory {
    public static TypeUsage typeUsageFor(Class<?> clazz, TypeSolver typeSolver) {
        if (clazz.isArray()) {
            return new ArrayTypeUsage(ReflectionFactory.typeUsageFor(clazz.getComponentType(), typeSolver));
        }
        if (clazz.isPrimitive()) {
            if (clazz.getName().equals("void")) {
                return VoidTypeUsage.INSTANCE;
            }
            return PrimitiveTypeUsage.byName((String)clazz.getName());
        }
        if (clazz.isInterface()) {
            return new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionInterfaceDeclaration(clazz, typeSolver), typeSolver);
        }
        return new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionClassDeclaration(clazz, typeSolver), typeSolver);
    }

    public static TypeUsage typeUsageFor(Type type, TypeSolver typeSolver) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            boolean declaredOnClass = ((TypeVariable)type).getGenericDeclaration() instanceof Type;
            ReflectionTypeParameter typeParameter = new ReflectionTypeParameter(tv, declaredOnClass);
            return new TypeParameterUsage((TypeParameter)typeParameter);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            ReferenceTypeUsage rawType = ReflectionFactory.typeUsageFor(pt.getRawType(), typeSolver).asReferenceTypeUsage();
            int i = 0;
            for (Type actualTypeArgument : pt.getActualTypeArguments()) {
                rawType = rawType.replaceParam(i, ReflectionFactory.typeUsageFor(actualTypeArgument, typeSolver)).asReferenceTypeUsage();
                ++i;
            }
            return rawType;
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isPrimitive()) {
                if (c.getName().equals("void")) {
                    return VoidTypeUsage.INSTANCE;
                }
                return PrimitiveTypeUsage.byName((String)c.getName());
            }
            if (c.isArray()) {
                return new ArrayTypeUsage(ReflectionFactory.typeUsageFor(c.getComponentType(), typeSolver));
            }
            if (c.isInterface()) {
                return new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionInterfaceDeclaration(c, typeSolver), typeSolver);
            }
            return new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionClassDeclaration(c, typeSolver), typeSolver);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new ArrayTypeUsage(ReflectionFactory.typeUsageFor(genericArrayType.getGenericComponentType(), typeSolver));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length <= 0 || wildcardType.getUpperBounds().length <= 0 || wildcardType.getUpperBounds().length != 1 || wildcardType.getUpperBounds()[0].getTypeName().equals("java.lang.Object")) {
                // empty if block
            }
            if (wildcardType.getLowerBounds().length > 0) {
                if (wildcardType.getLowerBounds().length > 1) {
                    throw new UnsupportedOperationException();
                }
                return WildcardUsage.superBound((TypeUsage)ReflectionFactory.typeUsageFor(wildcardType.getLowerBounds()[0], typeSolver));
            }
            if (wildcardType.getUpperBounds().length > 0) {
                if (wildcardType.getUpperBounds().length > 1) {
                    throw new UnsupportedOperationException();
                }
                return WildcardUsage.extendsBound((TypeUsage)ReflectionFactory.typeUsageFor(wildcardType.getUpperBounds()[0], typeSolver));
            }
            return WildcardUsage.UNBOUNDED;
        }
        throw new UnsupportedOperationException(type.getClass().getCanonicalName() + " " + type);
    }
}

