/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.reflectionmodel;

import java.lang.reflect.Field;
import me.tomassetti.symbolsolver.model.declarations.FieldDeclaration;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionFactory;

public class ReflectionFieldDeclaration
implements FieldDeclaration {
    private Field field;
    private TypeSolver typeSolver;
    private TypeUsage type;

    public ReflectionFieldDeclaration(Field field, TypeSolver typeSolver) {
        this.field = field;
        this.typeSolver = typeSolver;
        this.type = this.calcType();
    }

    private ReflectionFieldDeclaration(Field field, TypeSolver typeSolver, TypeUsage type) {
        this.field = field;
        this.typeSolver = typeSolver;
        this.type = type;
    }

    public TypeUsage getType() {
        return this.type;
    }

    private TypeUsage calcType() {
        return ReflectionFactory.typeUsageFor(this.field.getGenericType(), this.typeSolver);
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean isField() {
        return true;
    }

    public FieldDeclaration replaceType(TypeUsage fieldType) {
        return new ReflectionFieldDeclaration(this.field, this.typeSolver, fieldType);
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isType() {
        return false;
    }
}

