/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.Node;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javaslang.Tuple2;
import me.tomassetti.symbolsolver.javaparsermodel.LambdaArgumentTypeUsagePlaceholder;
import me.tomassetti.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import me.tomassetti.symbolsolver.logic.AbstractTypeDeclaration;
import me.tomassetti.symbolsolver.logic.GenericTypeInferenceLogic;
import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.declarations.FieldDeclaration;
import me.tomassetti.symbolsolver.model.declarations.InterfaceDeclaration;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeParametrized;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.NullTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.reflectionmodel.ClassOrInterfaceDeclarationContext;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionMethodResolutionLogic;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionTypeParameter;
import me.tomassetti.symbolsolver.resolution.MethodResolutionLogic;

public class ReflectionInterfaceDeclaration
extends AbstractTypeDeclaration
implements InterfaceDeclaration {
    private Class<?> clazz;
    private TypeSolver typeSolver;

    public ReflectionInterfaceDeclaration(Class<?> clazz, TypeSolver typeSolver) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        this.clazz = clazz;
        this.typeSolver = typeSolver;
    }

    public boolean isAssignableBy(TypeDeclaration other) {
        return this.isAssignableBy((TypeUsage)new ReferenceTypeUsageImpl(other, this.typeSolver));
    }

    public String getQualifiedName() {
        return this.clazz.getCanonicalName();
    }

    public Context getContext() {
        return new ClassOrInterfaceDeclarationContext(this.clazz);
    }

    public SymbolReference<MethodDeclaration> solveMethod(String name, List<TypeUsage> parameterTypes) {
        ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        for (Method method : this.clazz.getMethods()) {
            if (method.isBridge() || method.isSynthetic()) continue;
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method, this.typeSolver);
            methods.add(methodDeclaration);
        }
        return MethodResolutionLogic.findMostApplicable(methods, name, parameterTypes, this.typeSolver);
    }

    public String toString() {
        return "ReflectionClassDeclaration{clazz=" + this.clazz.getCanonicalName() + '}';
    }

    public TypeUsage getUsage(Node node) {
        return new ReferenceTypeUsageImpl((TypeDeclaration)this, this.typeSolver);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReflectionInterfaceDeclaration)) {
            return false;
        }
        ReflectionInterfaceDeclaration that = (ReflectionInterfaceDeclaration)((Object)o);
        if (!this.clazz.getCanonicalName().equals(that.clazz.getCanonicalName())) {
            return false;
        }
        return this.getTypeParameters().equals(that.getTypeParameters());
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public Optional<MethodUsage> solveMethodAsUsage(String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver, Context invokationContext, List<TypeUsage> typeParameterValues) {
        Optional<MethodUsage> res = ReflectionMethodResolutionLogic.solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, typeParameterValues, (TypeParametrized)this, this.clazz);
        if (res.isPresent()) {
            ArrayList<Tuple2> formalActualTypePairs = new ArrayList<Tuple2>();
            MethodUsage methodUsage = res.get();
            int i = 0;
            for (TypeUsage actualType : parameterTypes) {
                TypeUsage formalType = methodUsage.getParamType(i, typeSolver);
                formalActualTypePairs.add(new Tuple2((Object)formalType, (Object)actualType));
                ++i;
            }
            Map map = GenericTypeInferenceLogic.inferGenericTypes(formalActualTypePairs);
            for (String key : map.keySet()) {
                if (map.get(key) == null) {
                    throw new IllegalArgumentException();
                }
                methodUsage = methodUsage.replaceNameParam(key, (TypeUsage)map.get(key));
            }
            return Optional.of(methodUsage);
        }
        return res;
    }

    public boolean canBeAssignedTo(TypeDeclaration other) {
        if (other instanceof LambdaArgumentTypeUsagePlaceholder) {
            return this.getQualifiedName().equals(Predicate.class.getCanonicalName()) || this.getQualifiedName().equals(Function.class.getCanonicalName());
        }
        if (other.getQualifiedName().equals(this.getQualifiedName())) {
            return true;
        }
        if (this.clazz.getSuperclass() != null && new ReflectionInterfaceDeclaration(this.clazz.getSuperclass(), this.typeSolver).canBeAssignedTo(other)) {
            return true;
        }
        for (Class<?> interfaze : this.clazz.getInterfaces()) {
            if (!new ReflectionInterfaceDeclaration(interfaze, this.typeSolver).canBeAssignedTo(other)) continue;
            return true;
        }
        return other.getQualifiedName().equals(Object.class.getCanonicalName());
    }

    public boolean isAssignableBy(TypeUsage typeUsage) {
        if (typeUsage instanceof NullTypeUsage) {
            return true;
        }
        if (typeUsage instanceof LambdaArgumentTypeUsagePlaceholder) {
            return this.getQualifiedName().equals(Predicate.class.getCanonicalName()) || this.getQualifiedName().equals(Function.class.getCanonicalName());
        }
        if (typeUsage.isArray()) {
            return false;
        }
        if (typeUsage.isPrimitive()) {
            return false;
        }
        if (typeUsage.describe().equals(this.getQualifiedName())) {
            return true;
        }
        if (typeUsage instanceof ReferenceTypeUsageImpl) {
            ReferenceTypeUsageImpl otherTypeDeclaration = (ReferenceTypeUsageImpl)typeUsage;
            return otherTypeDeclaration.getTypeDeclaration().canBeAssignedTo((TypeDeclaration)this);
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public FieldDeclaration getField(String name) {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return new ReflectionFieldDeclaration(field, this.typeSolver);
        }
        for (ReferenceTypeUsage ancestor : this.getAllAncestors()) {
            if (!ancestor.getTypeDeclaration().hasField(name)) continue;
            return ancestor.getTypeDeclaration().getField(name);
        }
        throw new UnsolvedSymbolException("Field in " + (Object)((Object)this), name);
    }

    public List<FieldDeclaration> getAllFields() {
        ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
        for (Field field : this.clazz.getDeclaredFields()) {
            fields.add(new ReflectionFieldDeclaration(field, this.typeSolver));
        }
        for (ReferenceTypeUsage ancestor : this.getAllAncestors()) {
            fields.addAll(ancestor.getTypeDeclaration().getAllFields());
        }
        return fields;
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Field field : this.clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved((Declaration)new ReflectionFieldDeclaration(field, typeSolver));
        }
        return SymbolReference.unsolved(ValueDeclaration.class);
    }

    public SymbolReference<TypeDeclaration> solveType(String substring, TypeSolver typeSolver) {
        return SymbolReference.unsolved(TypeDeclaration.class);
    }

    /*
     * WARNING - void declaration
     */
    public List<ReferenceTypeUsage> getAllAncestors() {
        void var2_5;
        LinkedList<ReferenceTypeUsage> ancestors = new LinkedList<ReferenceTypeUsage>();
        if (this.clazz.getSuperclass() != null) {
            ReferenceTypeUsageImpl referenceTypeUsageImpl = new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionInterfaceDeclaration(this.clazz.getSuperclass(), this.typeSolver), this.typeSolver);
            ancestors.add(referenceTypeUsageImpl);
            ancestors.addAll(referenceTypeUsageImpl.getAllAncestors());
        }
        for (Class<?> interfaze : this.clazz.getInterfaces()) {
            ReferenceTypeUsageImpl interfazeDecl = new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionInterfaceDeclaration(interfaze, this.typeSolver), this.typeSolver);
            ancestors.add(interfazeDecl);
            ancestors.addAll(interfazeDecl.getAllAncestors());
        }
        boolean bl = false;
        while (var2_5 < ancestors.size()) {
            if (((ReferenceTypeUsage)ancestors.get((int)var2_5)).getQualifiedName().equals(Object.class.getCanonicalName())) {
                ancestors.remove((int)var2_5);
                --var2_5;
            }
            ++var2_5;
        }
        ReferenceTypeUsageImpl referenceTypeUsageImpl = new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionClassDeclaration(Object.class, this.typeSolver), this.typeSolver);
        ancestors.add(referenceTypeUsageImpl);
        return ancestors;
    }

    public Set<MethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.clazz.getDeclaredMethods()).filter(m -> !m.isSynthetic() && !m.isBridge()).map(m -> new ReflectionMethodDeclaration((Method)m, this.typeSolver())).collect(Collectors.toSet());
    }

    public boolean hasField(String name) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.clazz.getSimpleName();
    }

    public boolean isInterface() {
        return true;
    }

    public List<InterfaceDeclaration> getInterfacesExtended() {
        ArrayList<InterfaceDeclaration> res = new ArrayList<InterfaceDeclaration>();
        for (Class<?> i : this.clazz.getInterfaces()) {
            res.add(new ReflectionInterfaceDeclaration(i, this.typeSolver));
        }
        return res;
    }

    public InterfaceDeclaration asInterface() {
        return this;
    }

    public List<TypeParameter> getTypeParameters() {
        ArrayList<TypeParameter> params = new ArrayList<TypeParameter>();
        for (TypeVariable<Class<?>> tv : this.clazz.getTypeParameters()) {
            params.add(new ReflectionTypeParameter(tv, true));
        }
        return params;
    }

    protected TypeSolver typeSolver() {
        return this.typeSolver;
    }
}

