/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ModifierSet;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ParameterDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionFactory;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionParameterDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionTypeParameter;

public class ReflectionMethodDeclaration
implements MethodDeclaration {
    private Method method;
    private TypeSolver typeSolver;

    public ReflectionMethodDeclaration(Method method, TypeSolver typeSolver) {
        this.method = method;
        if (method.isSynthetic() || method.isBridge()) {
            throw new IllegalArgumentException();
        }
        this.typeSolver = typeSolver;
    }

    public String getName() {
        return this.method.getName();
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public String toString() {
        return "ReflectionMethodDeclaration{method=" + this.method + '}';
    }

    public boolean isType() {
        return false;
    }

    public TypeDeclaration declaringType() {
        if (this.method.getDeclaringClass().isInterface()) {
            return new ReflectionInterfaceDeclaration(this.method.getDeclaringClass(), this.typeSolver);
        }
        return new ReflectionClassDeclaration(this.method.getDeclaringClass(), this.typeSolver);
    }

    public TypeUsage getReturnType() {
        return ReflectionFactory.typeUsageFor(this.method.getGenericReturnType(), this.typeSolver);
    }

    public int getNoParams() {
        return this.method.getParameterTypes().length;
    }

    public ParameterDeclaration getParam(int i) {
        boolean variadic = false;
        if (this.method.isVarArgs()) {
            variadic = i == this.method.getParameterCount() - 1;
        }
        return new ReflectionParameterDeclaration(this.method.getParameterTypes()[i], this.method.getGenericParameterTypes()[i], this.typeSolver, variadic);
    }

    public MethodUsage getUsage(Node node) {
        throw new UnsupportedOperationException();
    }

    public List<TypeParameter> getTypeParameters() {
        return Arrays.stream(this.method.getTypeParameters()).map(refTp -> new ReflectionTypeParameter((TypeVariable)refTp, false)).collect(Collectors.toList());
    }

    public MethodUsage resolveTypeVariables(Context context, List<TypeUsage> parameterTypes) {
        return new MethodUsage((MethodDeclaration)new ReflectionMethodDeclaration(this.method, this.typeSolver), this.typeSolver);
    }

    public boolean isAbstract() {
        return ModifierSet.isAbstract((int)this.method.getModifiers());
    }

    public boolean isPrivate() {
        return ModifierSet.isPrivate((int)this.method.getModifiers());
    }

    public boolean isPackageProtected() {
        return !ModifierSet.isPrivate((int)this.method.getModifiers()) && !ModifierSet.isProtected((int)this.method.getModifiers()) && !ModifierSet.isPublic((int)this.method.getModifiers());
    }
}

