/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.reflectionmodel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeParametrized;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeParameterUsage;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;
import me.tomassetti.symbolsolver.resolution.MethodResolutionLogic;

class ReflectionMethodResolutionLogic {
    ReflectionMethodResolutionLogic() {
    }

    static Optional<MethodUsage> solveMethodAsUsage(String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver, Context invokationContext, List<TypeUsage> typeParameterValues, TypeParametrized typeParametrized, Class clazz) {
        if (typeParameterValues.size() != typeParametrized.getTypeParameters().size() && !typeParametrized.getTypeParameters().isEmpty()) {
            typeParameterValues = new ArrayList<TypeUsage>();
            for (int i = 0; i < typeParametrized.getTypeParameters().size(); ++i) {
                typeParameterValues.add((TypeUsage)new ReferenceTypeUsageImpl((TypeDeclaration)new ReflectionClassDeclaration(Object.class, typeSolver), typeSolver));
            }
        }
        ArrayList<MethodUsage> methods = new ArrayList<MethodUsage>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.isBridge() || method.isSynthetic()) continue;
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method, typeSolver);
            MethodUsage methodUsage = new MethodUsage((MethodDeclaration)methodDeclaration, typeSolver);
            int i = 0;
            for (TypeParameter tp : typeParametrized.getTypeParameters()) {
                methodUsage = methodUsage.replaceNameParam(tp.getName(), typeParameterValues.get(i));
                ++i;
            }
            for (TypeParameter methodTypeParameter : methodDeclaration.getTypeParameters()) {
                methodUsage = methodUsage.replaceNameParam(methodTypeParameter.getName(), (TypeUsage)new TypeParameterUsage(methodTypeParameter));
            }
            methods.add(methodUsage);
        }
        List<TypeUsage> finalTypeParameterValues = typeParameterValues;
        parameterTypes = parameterTypes.stream().map(pt -> {
            int i = 0;
            for (TypeParameter tp : typeParametrized.getTypeParameters()) {
                pt = pt.replaceParam(tp.getName(), (TypeUsage)finalTypeParameterValues.get(i));
                ++i;
            }
            return pt;
        }).collect(Collectors.toList());
        return MethodResolutionLogic.findMostApplicableUsage(methods, name, parameterTypes, typeSolver);
    }
}

