/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.reflectionmodel;

import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.reflectionmodel.ReflectionFactory;

public class ReflectionTypeParameter
implements TypeParameter {
    private TypeVariable typeVariable;
    private boolean declaredOnClass;
    private String qNameOfDeclaringClass;

    public ReflectionTypeParameter(TypeVariable typeVariable, boolean declaredOnClass) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (genericDeclaration instanceof Class) {
            Class clazz = (Class)genericDeclaration;
            this.qNameOfDeclaringClass = clazz.getTypeName();
        } else {
            this.qNameOfDeclaringClass = null;
        }
        this.typeVariable = typeVariable;
        this.declaredOnClass = declaredOnClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeParameter)) {
            return false;
        }
        TypeParameter that = (TypeParameter)o;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.declaredOnClass() != that.declaredOnClass()) {
            return false;
        }
        return this.declaredOnMethod() == that.declaredOnMethod();
    }

    public int hashCode() {
        int result = this.typeVariable.hashCode();
        result = 31 * result + (this.declaredOnClass ? 1 : 0);
        return result;
    }

    public String getName() {
        return this.typeVariable.getName();
    }

    public boolean declaredOnClass() {
        return this.declaredOnClass;
    }

    public boolean declaredOnMethod() {
        return !this.declaredOnClass;
    }

    public String getQNameOfDeclaringClass() {
        if (this.qNameOfDeclaringClass == null) {
            throw new UnsupportedOperationException();
        }
        return this.qNameOfDeclaringClass;
    }

    public List<TypeParameter.Bound> getBounds(TypeSolver typeSolver) {
        return Arrays.stream(this.typeVariable.getBounds()).map(refB -> TypeParameter.Bound.extendsBound((TypeUsage)ReflectionFactory.typeUsageFor(refB, typeSolver))).collect(Collectors.toList());
    }

    public String toString() {
        return "ReflectionTypeParameter{typeVariable=" + this.typeVariable + '}';
    }
}

