/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.resolution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.tomassetti.symbolsolver.model.declarations.Declaration;
import me.tomassetti.symbolsolver.model.declarations.MethodAmbiguityException;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeParameter;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.typesystem.ArrayTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;
import me.tomassetti.symbolsolver.model.typesystem.WildcardUsage;

public class MethodResolutionLogic {
    private static List<TypeUsage> groupVariadicParamValues(List<TypeUsage> paramTypes, int startVariadic, TypeUsage variadicType) {
        ArrayList<TypeUsage> res = new ArrayList<TypeUsage>(paramTypes.subList(0, startVariadic));
        List<TypeUsage> variadicValues = paramTypes.subList(startVariadic, paramTypes.size());
        if (variadicValues.isEmpty()) {
            res.add(variadicType);
        } else {
            TypeUsage componentType = MethodResolutionLogic.findCommonType(variadicValues);
            res.add((TypeUsage)new ArrayTypeUsage(componentType));
        }
        return res;
    }

    private static TypeUsage findCommonType(List<TypeUsage> variadicValues) {
        if (variadicValues.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return variadicValues.get(0);
    }

    public static boolean isApplicable(MethodDeclaration method, String name, List<TypeUsage> paramTypes, TypeSolver typeSolver) {
        List<TypeUsage> originalParamTypes = paramTypes;
        if (!method.getName().equals(name)) {
            return false;
        }
        if (method.hasVariadicParameter()) {
            int pos = method.getNoParams() - 1;
            if (method.getNoParams() == paramTypes.size()) {
                TypeUsage actualType;
                TypeUsage expectedType = method.getLastParam().getType();
                if (!expectedType.isAssignableBy(actualType = paramTypes.get(pos))) {
                    for (TypeParameter tp : method.getTypeParameters()) {
                        expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, typeSolver);
                    }
                    if (!expectedType.isAssignableBy(actualType)) {
                        paramTypes = MethodResolutionLogic.groupVariadicParamValues(paramTypes, pos, method.getLastParam().getType());
                    }
                }
            } else {
                paramTypes = MethodResolutionLogic.groupVariadicParamValues(paramTypes, pos, method.getLastParam().getType());
            }
        }
        if (method.getNoParams() != paramTypes.size()) {
            return false;
        }
        HashMap<String, TypeUsage> matchedParameters = new HashMap<String, TypeUsage>();
        for (int i = 0; i < method.getNoParams(); ++i) {
            TypeUsage actualType;
            TypeUsage expectedType = method.getParam(i).getType();
            boolean isAssignableWithoutSubstitution = expectedType.isAssignableBy(actualType = paramTypes.get(i));
            if (!isAssignableWithoutSubstitution && expectedType.isReferenceType() && actualType.isReferenceType()) {
                isAssignableWithoutSubstitution = MethodResolutionLogic.isAssignableMatchTypeParameters(expectedType.asReferenceTypeUsage(), actualType.asReferenceTypeUsage(), matchedParameters);
            }
            if (isAssignableWithoutSubstitution) continue;
            for (TypeParameter tp : method.getTypeParameters()) {
                expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, typeSolver);
            }
            if (expectedType.isAssignableBy(actualType)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignableMatchTypeParameters(ReferenceTypeUsage expected, ReferenceTypeUsage actual, Map<String, TypeUsage> matchedParameters) {
        if (actual.getQualifiedName().equals(expected.getQualifiedName())) {
            return MethodResolutionLogic.isAssignableMatchTypeParametersMatchingQName(expected, actual, matchedParameters);
        }
        List ancestors = actual.getAllAncestors();
        for (ReferenceTypeUsage ancestor : ancestors) {
            if (!MethodResolutionLogic.isAssignableMatchTypeParametersMatchingQName(expected, ancestor, matchedParameters)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableMatchTypeParametersMatchingQName(ReferenceTypeUsage expected, ReferenceTypeUsage actual, Map<String, TypeUsage> matchedParameters) {
        if (!expected.getQualifiedName().equals(actual.getQualifiedName())) {
            return false;
        }
        if (expected.parameters().size() != actual.parameters().size()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < expected.parameters().size(); ++i) {
            TypeUsage expectedParam = (TypeUsage)expected.parameters().get(i);
            TypeUsage actualParam = (TypeUsage)actual.parameters().get(i);
            if (expectedParam.isTypeVariable()) {
                String expectedParamName = expectedParam.asTypeParameter().getName();
                if (actualParam.isTypeVariable() && actualParam.asTypeParameter().getName().equals(expectedParamName)) continue;
                if (matchedParameters.containsKey(expectedParamName)) {
                    throw new UnsupportedOperationException("We should check if they are compatible");
                }
                matchedParameters.put(expectedParamName, actualParam);
                continue;
            }
            if (expectedParam.isReferenceType()) {
                if (expectedParam.equals(actualParam)) continue;
                return false;
            }
            if (expectedParam.isWildcard()) {
                return true;
            }
            throw new UnsupportedOperationException(expectedParam.describe());
        }
        return true;
    }

    public static TypeUsage replaceTypeParam(TypeUsage typeUsage, TypeParameter tp, TypeSolver typeSolver) {
        if (typeUsage.isTypeVariable()) {
            if (typeUsage.describe().equals(tp.getName())) {
                List bounds = tp.getBounds(typeSolver);
                if (bounds.size() > 1) {
                    throw new UnsupportedOperationException();
                }
                if (bounds.size() == 1) {
                    return ((TypeParameter.Bound)bounds.get(0)).getType();
                }
                return new ReferenceTypeUsageImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver);
            }
            return typeUsage;
        }
        if (typeUsage.isPrimitive()) {
            return typeUsage;
        }
        if (typeUsage.isArray()) {
            return new ArrayTypeUsage(MethodResolutionLogic.replaceTypeParam(typeUsage.asArrayTypeUsage().getComponentType(), tp, typeSolver));
        }
        if (typeUsage.isReferenceType()) {
            ReferenceTypeUsage result = typeUsage.asReferenceTypeUsage();
            int i = 0;
            for (TypeUsage typeParam : result.parameters()) {
                result = result.replaceParam(i, MethodResolutionLogic.replaceTypeParam(typeParam, tp, typeSolver)).asReferenceTypeUsage();
                ++i;
            }
            return result;
        }
        throw new UnsupportedOperationException(typeUsage.getClass().getCanonicalName());
    }

    public static boolean isApplicable(MethodUsage method, String name, List<TypeUsage> paramTypes, TypeSolver typeSolver) {
        if (!method.getName().equals(name)) {
            return false;
        }
        if (method.getNoParams() != paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < method.getNoParams(); ++i) {
            TypeUsage expectedType;
            TypeUsage expectedTypeWithoutSubstitutions = expectedType = method.getParamType(i, typeSolver);
            TypeUsage actualType = paramTypes.get(i);
            for (TypeParameter tp : method.getDeclaration().getTypeParameters()) {
                if (tp.getBounds(typeSolver).isEmpty()) {
                    expectedType = expectedType.replaceParam(tp.getName(), (TypeUsage)WildcardUsage.extendsBound((TypeUsage)new ReferenceTypeUsageImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver)));
                    continue;
                }
                if (tp.getBounds(typeSolver).size() == 1) {
                    TypeParameter.Bound bound = (TypeParameter.Bound)tp.getBounds(typeSolver).get(0);
                    if (bound.isExtends()) {
                        expectedType = expectedType.replaceParam(tp.getName(), (TypeUsage)WildcardUsage.extendsBound((TypeUsage)bound.getType()));
                        continue;
                    }
                    expectedType = expectedType.replaceParam(tp.getName(), (TypeUsage)WildcardUsage.superBound((TypeUsage)bound.getType()));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            TypeUsage expectedType2 = expectedTypeWithoutSubstitutions;
            for (TypeParameter tp : method.getDeclaration().getTypeParameters()) {
                if (tp.getBounds(typeSolver).isEmpty()) {
                    expectedType2 = expectedType2.replaceParam(tp.getName(), (TypeUsage)new ReferenceTypeUsageImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver));
                    continue;
                }
                if (tp.getBounds(typeSolver).size() == 1) {
                    TypeParameter.Bound bound = (TypeParameter.Bound)tp.getBounds(typeSolver).get(0);
                    if (bound.isExtends()) {
                        expectedType2 = expectedType2.replaceParam(tp.getName(), bound.getType());
                        continue;
                    }
                    expectedType2 = expectedType2.replaceParam(tp.getName(), (TypeUsage)new ReferenceTypeUsageImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            if (expectedType.isAssignableBy(actualType) || expectedType2.isAssignableBy(actualType) || expectedTypeWithoutSubstitutions.isAssignableBy(actualType)) continue;
            return false;
        }
        return true;
    }

    public static SymbolReference<MethodDeclaration> findMostApplicable(List<MethodDeclaration> methods, String name, List<TypeUsage> paramTypes, TypeSolver typeSolver) {
        List applicableMethods = methods.stream().filter(m -> MethodResolutionLogic.isApplicable(m, name, paramTypes, typeSolver)).collect(Collectors.toList());
        if (applicableMethods.isEmpty()) {
            return SymbolReference.unsolved(MethodDeclaration.class);
        }
        if (applicableMethods.size() == 1) {
            return SymbolReference.solved((Declaration)((Declaration)applicableMethods.get(0)));
        }
        MethodDeclaration winningCandidate = (MethodDeclaration)applicableMethods.get(0);
        for (int i = 1; i < applicableMethods.size(); ++i) {
            MethodDeclaration other = (MethodDeclaration)applicableMethods.get(i);
            if (MethodResolutionLogic.isMoreSpecific(winningCandidate, other, typeSolver)) continue;
            if (MethodResolutionLogic.isMoreSpecific(other, winningCandidate, typeSolver)) {
                winningCandidate = other;
                continue;
            }
            if (!winningCandidate.declaringType().getQualifiedName().equals(other.declaringType().getQualifiedName())) continue;
            throw new MethodAmbiguityException("Ambiguous method call: cannot find a most applicable method: " + winningCandidate + ", " + other);
        }
        return SymbolReference.solved((Declaration)winningCandidate);
    }

    private static boolean isMoreSpecific(MethodDeclaration methodA, MethodDeclaration methodB, TypeSolver typeSolver) {
        boolean oneMoreSpecificFound = false;
        for (int i = 0; i < methodA.getNoParams(); ++i) {
            TypeUsage tdA = methodA.getParam(i).getType();
            TypeUsage tdB = methodB.getParam(i).getType();
            if (tdB.isAssignableBy(tdA) && !tdA.isAssignableBy(tdB)) {
                oneMoreSpecificFound = true;
            }
            if (!tdA.isAssignableBy(tdB) || tdB.isAssignableBy(tdA)) continue;
            return false;
        }
        return oneMoreSpecificFound;
    }

    private static boolean isMoreSpecific(MethodUsage methodA, MethodUsage methodB, TypeSolver typeSolver) {
        boolean oneMoreSpecificFound = false;
        for (int i = 0; i < methodA.getNoParams(); ++i) {
            TypeUsage tdA = methodA.getParamType(i, typeSolver);
            TypeUsage tdB = methodB.getParamType(i, typeSolver);
            boolean aIsAssignableByB = tdA.isAssignableBy(tdB);
            boolean bIsAssignableByA = tdB.isAssignableBy(tdA);
            if (bIsAssignableByA && !aIsAssignableByB) {
                oneMoreSpecificFound = true;
            }
            if (!aIsAssignableByB || bIsAssignableByA) continue;
            return false;
        }
        return oneMoreSpecificFound;
    }

    public static Optional<MethodUsage> findMostApplicableUsage(List<MethodUsage> methods, String name, List<TypeUsage> parameterTypes, TypeSolver typeSolver) {
        List applicableMethods = methods.stream().filter(m -> MethodResolutionLogic.isApplicable(m, name, parameterTypes, typeSolver)).collect(Collectors.toList());
        if (applicableMethods.isEmpty()) {
            return Optional.empty();
        }
        if (applicableMethods.size() == 1) {
            return Optional.of(applicableMethods.get(0));
        }
        MethodUsage winningCandidate = (MethodUsage)applicableMethods.get(0);
        for (int i = 1; i < applicableMethods.size(); ++i) {
            MethodUsage other = (MethodUsage)applicableMethods.get(i);
            if (MethodResolutionLogic.isMoreSpecific(winningCandidate, other, typeSolver)) continue;
            if (MethodResolutionLogic.isMoreSpecific(other, winningCandidate, typeSolver)) {
                winningCandidate = other;
                continue;
            }
            if (!winningCandidate.declaringType().getQualifiedName().equals(other.declaringType().getQualifiedName()) || MethodResolutionLogic.areOverride(winningCandidate, other)) continue;
            throw new MethodAmbiguityException("Ambiguous method call: cannot find a most applicable method: " + winningCandidate + ", " + other + ". First declared in " + winningCandidate.declaringType().getQualifiedName());
        }
        return Optional.of(winningCandidate);
    }

    private static boolean areOverride(MethodUsage winningCandidate, MethodUsage other) {
        if (!winningCandidate.getName().equals(other.getName())) {
            return false;
        }
        if (winningCandidate.getNoParams() != other.getNoParams()) {
            return false;
        }
        for (int i = 0; i < winningCandidate.getNoParams(); ++i) {
            if (((TypeUsage)winningCandidate.getParamTypes().get(i)).equals(other.getParamTypes().get(i))) continue;
            return false;
        }
        return true;
    }
}

