/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.resolution;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import java.util.List;
import java.util.Optional;
import me.tomassetti.symbolsolver.javaparsermodel.JavaParserFactory;
import me.tomassetti.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import me.tomassetti.symbolsolver.model.declarations.MethodDeclaration;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.declarations.ValueDeclaration;
import me.tomassetti.symbolsolver.model.invokations.MethodUsage;
import me.tomassetti.symbolsolver.model.resolution.Context;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;
import me.tomassetti.symbolsolver.model.resolution.Value;
import me.tomassetti.symbolsolver.model.typesystem.ReferenceTypeUsageImpl;
import me.tomassetti.symbolsolver.model.typesystem.TypeUsage;

public class SymbolSolver {
    private TypeSolver typeSolver;

    public SymbolSolver(TypeSolver typeSolver) {
        if (typeSolver == null) {
            throw new IllegalArgumentException();
        }
        this.typeSolver = typeSolver;
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String name, Context context) {
        return context.solveSymbol(name, this.typeSolver);
    }

    public SymbolReference<? extends ValueDeclaration> solveSymbol(String name, Node node) {
        return this.solveSymbol(name, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public Optional<Value> solveSymbolAsValue(String name, Context context) {
        return context.solveSymbolAsValue(name, this.typeSolver);
    }

    public Optional<Value> solveSymbolAsValue(String name, Node node) {
        Context context = JavaParserFactory.getContext(node, this.typeSolver);
        return this.solveSymbolAsValue(name, context);
    }

    public SymbolReference<? extends TypeDeclaration> solveType(String name, Context context) {
        return context.solveType(name, this.typeSolver);
    }

    public SymbolReference<? extends TypeDeclaration> solveType(String name, Node node) {
        return this.solveType(name, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public MethodUsage solveMethod(String methodName, List<TypeUsage> params, Context context) {
        SymbolReference decl = context.solveMethod(methodName, params, this.typeSolver);
        if (!decl.isSolved()) {
            throw new UnsolvedSymbolException(context, methodName);
        }
        return new MethodUsage((MethodDeclaration)decl.getCorrespondingDeclaration(), this.typeSolver);
    }

    public MethodUsage solveMethod(String methodName, List<TypeUsage> params, Node node) {
        return this.solveMethod(methodName, params, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public TypeDeclaration solveType(Type type) {
        if (type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)type;
            return this.solveType(referenceType.getType());
        }
        if (type instanceof ClassOrInterfaceType) {
            String name = ((ClassOrInterfaceType)type).getName();
            SymbolReference ref = JavaParserFactory.getContext((Node)type, this.typeSolver).solveType(name, this.typeSolver);
            if (!ref.isSolved()) {
                throw new UnsolvedSymbolException(JavaParserFactory.getContext((Node)type, this.typeSolver), name);
            }
            return (TypeDeclaration)ref.getCorrespondingDeclaration();
        }
        throw new UnsupportedOperationException(type.getClass().getCanonicalName());
    }

    public TypeUsage solveTypeUsage(String name, Context context) {
        Optional genericType = context.solveGenericType(name, this.typeSolver);
        if (genericType.isPresent()) {
            return (TypeUsage)genericType.get();
        }
        TypeDeclaration typeDeclaration = this.typeSolver.solveType(name);
        ReferenceTypeUsageImpl typeUsage = new ReferenceTypeUsageImpl(typeDeclaration, this.typeSolver);
        return typeUsage;
    }
}

