/*
 * Decompiled with CFR 0.152.
 */
package me.tomassetti.symbolsolver.resolution.typesolvers;

import java.util.ArrayList;
import java.util.List;
import me.tomassetti.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import me.tomassetti.symbolsolver.model.declarations.TypeDeclaration;
import me.tomassetti.symbolsolver.model.resolution.SymbolReference;
import me.tomassetti.symbolsolver.model.resolution.TypeSolver;

public class CombinedTypeSolver
implements TypeSolver {
    private TypeSolver parent;
    private List<TypeSolver> elements = new ArrayList<TypeSolver>();

    public CombinedTypeSolver(TypeSolver ... elements) {
        for (TypeSolver el : elements) {
            this.add(el);
        }
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }

    public void add(TypeSolver typeSolver) {
        this.elements.add(typeSolver);
        typeSolver.setParent((TypeSolver)this);
    }

    public SymbolReference<TypeDeclaration> tryToSolveType(String name) {
        for (TypeSolver ts : this.elements) {
            SymbolReference res = ts.tryToSolveType(name);
            if (!res.isSolved()) continue;
            return res;
        }
        return SymbolReference.unsolved(TypeDeclaration.class);
    }

    public TypeDeclaration solveType(String name) throws UnsolvedSymbolException {
        SymbolReference<TypeDeclaration> res = this.tryToSolveType(name);
        if (res.isSolved()) {
            return (TypeDeclaration)res.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }
}

